/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.tools;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.platform.image.internal.Image;
import com.jetbrains.toolbox.tools.model.ToolDescription;
import com.jetbrains.toolbox.tools.model.subscription.OverviewAccess;
import com.jetbrains.toolbox.tools.model.subscription.ToolCategory;
import com.jetbrains.toolbox.tools.model.subscription.ToolEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolCategoryViewState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalizableString name;
    @NotNull
    private final List<ToolEntryViewState> tools;

    public ToolCategoryViewState(@NotNull LocalizableString name2, @NotNull List<ToolEntryViewState> tools2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(tools2, (String)"tools");
        this.name = name2;
        this.tools = tools2;
    }

    @NotNull
    public final LocalizableString getName() {
        return this.name;
    }

    @NotNull
    public final List<ToolEntryViewState> getTools() {
        return this.tools;
    }

    @NotNull
    public String toString() {
        return "ToolCategoryViewState(name=" + this.name + ", tools=" + this.tools + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + ((Object)this.tools).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ToolCategoryViewState)) {
            return false;
        }
        ToolCategoryViewState toolCategoryViewState = (ToolCategoryViewState)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)toolCategoryViewState.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.tools, toolCategoryViewState.tools);
    }

    @SourceDebugExtension(value={"SMAP\nSubscriptionOverviewViewState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptionOverviewViewState.kt\ncom/jetbrains/toolbox/viewmodel/tools/ToolCategoryViewState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1563#2:77\n1634#2,3:78\n*S KotlinDebug\n*F\n+ 1 SubscriptionOverviewViewState.kt\ncom/jetbrains/toolbox/viewmodel/tools/ToolCategoryViewState$Companion\n*L\n72#1:77\n72#1:78,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ToolCategoryViewState of(@NotNull ToolCategory toolCategory, @NotNull Set<ToolDescription> installedTools2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)toolCategory, (String)"toolCategory");
            Intrinsics.checkNotNullParameter(installedTools2, (String)"installedTools");
            Iterable iterable = toolCategory.getTools();
            LocalizableString localizableString = toolCategory.getName();
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void toolEntry;
                ToolEntry toolEntry2 = (ToolEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ToolEntryViewState.Companion.of((ToolEntry)toolEntry, installedTools2));
            }
            List list2 = (List)destination$iv$iv;
            LocalizableString localizableString2 = localizableString;
            return new ToolCategoryViewState(localizableString2, list2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ToolEntryViewState {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String toolId;
        @NotNull
        private final String name;
        @Nullable
        private final Image icon;
        private final boolean isInstalled;
        @Nullable
        private final OS.Type platform;
        @NotNull
        private final OverviewAccess overviewAccess;

        private ToolEntryViewState(String toolId, String name2, Image icon2, boolean isInstalled2, OS.Type platform, OverviewAccess overviewAccess) {
            Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)overviewAccess, (String)"overviewAccess");
            this.toolId = toolId;
            this.name = name2;
            this.icon = icon2;
            this.isInstalled = isInstalled2;
            this.platform = platform;
            this.overviewAccess = overviewAccess;
        }

        @NotNull
        public final String getToolId-UtVBrGo() {
            return this.toolId;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Image getIcon() {
            return this.icon;
        }

        public final boolean isInstalled() {
            return this.isInstalled;
        }

        @Nullable
        public final OS.Type getPlatform() {
            return this.platform;
        }

        @NotNull
        public final OverviewAccess getOverviewAccess() {
            return this.overviewAccess;
        }

        @NotNull
        public String toString() {
            return "ToolEntryViewState(toolId=" + ApplicationType.toString-impl(this.toolId) + ", name=" + this.name + ", icon=" + this.icon + ", isInstalled=" + this.isInstalled + ", platform=" + this.platform + ", overviewAccess=" + this.overviewAccess + ")";
        }

        public int hashCode() {
            int result2 = ApplicationType.hashCode-impl(this.toolId);
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + (this.icon == null ? 0 : this.icon.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.isInstalled);
            result2 = result2 * 31 + (this.platform == null ? 0 : this.platform.hashCode());
            result2 = result2 * 31 + this.overviewAccess.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ToolEntryViewState)) {
                return false;
            }
            ToolEntryViewState toolEntryViewState = (ToolEntryViewState)other;
            if (!ApplicationType.equals-impl0(this.toolId, toolEntryViewState.toolId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)toolEntryViewState.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.icon, (Object)toolEntryViewState.icon)) {
                return false;
            }
            if (this.isInstalled != toolEntryViewState.isInstalled) {
                return false;
            }
            if (this.platform != toolEntryViewState.platform) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.overviewAccess, (Object)toolEntryViewState.overviewAccess);
        }

        public /* synthetic */ ToolEntryViewState(String toolId, String name2, Image icon2, boolean isInstalled2, OS.Type platform, OverviewAccess overviewAccess, DefaultConstructorMarker $constructor_marker) {
            this(toolId, name2, icon2, isInstalled2, platform, overviewAccess);
        }

        @SourceDebugExtension(value={"SMAP\nSubscriptionOverviewViewState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptionOverviewViewState.kt\ncom/jetbrains/toolbox/viewmodel/tools/ToolCategoryViewState$ToolEntryViewState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1761#2,3:77\n*S KotlinDebug\n*F\n+ 1 SubscriptionOverviewViewState.kt\ncom/jetbrains/toolbox/viewmodel/tools/ToolCategoryViewState$ToolEntryViewState$Companion\n*L\n60#1:77,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ToolEntryViewState of(@NotNull ToolEntry toolEntry, @NotNull Set<ToolDescription> installedTools2) {
                boolean bl;
                String string;
                String string2;
                Image image;
                block3: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter((Object)toolEntry, (String)"toolEntry");
                    Intrinsics.checkNotNullParameter(installedTools2, (String)"installedTools");
                    Iterable iterable = installedTools2;
                    image = toolEntry.getIcon();
                    string2 = toolEntry.getName();
                    string = toolEntry.getToolId-UtVBrGo();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ToolDescription toolDescription = (ToolDescription)element$iv;
                            boolean bl2 = false;
                            if (!(ApplicationType.equals-impl0(toolDescription.getToolId-UtVBrGo(), toolEntry.getToolId-UtVBrGo()) && toolDescription.isInstalled())) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                boolean bl3 = bl;
                DefaultConstructorMarker defaultConstructorMarker = null;
                OverviewAccess overviewAccess = toolEntry.getOverviewAccess();
                OS.Type type2 = toolEntry.getPlatform();
                boolean bl4 = bl3;
                Image image2 = image;
                String string3 = string2;
                String string4 = string;
                return new ToolEntryViewState(string4, string3, image2, bl4, type2, overviewAccess, defaultConstructorMarker);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

