/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.tools;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.UtilKt;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.SupportedLanguage;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.platform.image.internal.Image;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import com.jetbrains.toolbox.tools.model.FreshnessPeriod;
import com.jetbrains.toolbox.tools.model.licensing.LicenseInfo;
import com.jetbrains.toolbox.viewmodel.DistributionId;
import com.jetbrains.toolbox.viewmodel.Rankable;
import com.jetbrains.toolbox.viewmodel.tools.AvailableToolMatchRanks;
import com.jetbrains.toolbox.viewmodel.tools.AvailableToolViewStateKt;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nAvailableToolViewState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvailableToolViewState.kt\ncom/jetbrains/toolbox/viewmodel/tools/AvailableToolViewState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n295#2,2:133\n*S KotlinDebug\n*F\n+ 1 AvailableToolViewState.kt\ncom/jetbrains/toolbox/viewmodel/tools/AvailableToolViewState\n*L\n63#1:133,2\n*E\n"})
public final class AvailableToolViewState
implements Rankable {
    @NotNull
    private final String toolId;
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @Nullable
    private final String vendor;
    @Nullable
    private final Image icon;
    @NotNull
    private final String stableVersionName;
    @NotNull
    private final String latestBuildNumber;
    @Nullable
    private final FreshnessPeriod freshnessPeriod;
    @Nullable
    private final LicenseInfo licenseInfo;
    @NotNull
    private final List<SupportedLanguage> languages;
    @Nullable
    private final String htmlDescription;
    @NotNull
    private final DistributionId bestDistribution;
    @NotNull
    private final Lazy technologies$delegate;

    private AvailableToolViewState(String toolId, String name2, String description2, String vendor, Image icon2, String stableVersionName, String latestBuildNumber, FreshnessPeriod freshnessPeriod, LicenseInfo licenseInfo, List<SupportedLanguage> languages, String htmlDescription, DistributionId bestDistribution) {
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        Intrinsics.checkNotNullParameter((Object)stableVersionName, (String)"stableVersionName");
        Intrinsics.checkNotNullParameter((Object)latestBuildNumber, (String)"latestBuildNumber");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)bestDistribution, (String)"bestDistribution");
        this.toolId = toolId;
        this.name = name2;
        this.description = description2;
        this.vendor = vendor;
        this.icon = icon2;
        this.stableVersionName = stableVersionName;
        this.latestBuildNumber = latestBuildNumber;
        this.freshnessPeriod = freshnessPeriod;
        this.licenseInfo = licenseInfo;
        this.languages = languages;
        this.htmlDescription = htmlDescription;
        this.bestDistribution = bestDistribution;
        this.technologies$delegate = LazyKt.lazy(() -> AvailableToolViewState.technologies_delegate$lambda$2(this));
    }

    @NotNull
    public final String getToolId-UtVBrGo() {
        return this.toolId;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @Nullable
    public final String getVendor() {
        return this.vendor;
    }

    @Nullable
    public final Image getIcon() {
        return this.icon;
    }

    @NotNull
    public final String getStableVersionName() {
        return this.stableVersionName;
    }

    @NotNull
    public final String getLatestBuildNumber-Y_E1uuk() {
        return this.latestBuildNumber;
    }

    @Nullable
    public final FreshnessPeriod getFreshnessPeriod() {
        return this.freshnessPeriod;
    }

    @Nullable
    public final LicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }

    @NotNull
    public final LocalizableString getAccessibleContent() {
        LocalizableString localizableString;
        if (this.vendor != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)this.name), TuplesKt.to((Object)"vendor", (Object)this.vendor), TuplesKt.to((Object)"description", (Object)this.description)};
            localizableString = LocalizableStringExKt.trl("{{toolName}} by {{vendor}}: {{description}}. Click to learn more.", pairArray);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)this.name), TuplesKt.to((Object)"description", (Object)this.description)};
            localizableString = LocalizableStringExKt.trl("{{toolName}}: {{description}}. Click to learn more.", pairArray);
        }
        return localizableString;
    }

    private final String getTechnologies() {
        Lazy lazy = this.technologies$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public int rankByMatch(@NotNull String filter2) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        if (((CharSequence)filter2).length() == 0) {
            return (int)Math.pow(2.0f, AvailableToolMatchRanks.Default.getRank());
        }
        float rank = 0.0f;
        if (StringsKt.equals((String)filter2, (String)"R", (boolean)true) && ApplicationType.equals-impl0(this.toolId, WellKnownApplications.INSTANCE.getDataSpell-UtVBrGo()) || StringsKt.equals((String)filter2, (String)"C", (boolean)true) && (ApplicationType.equals-impl0(this.toolId, WellKnownApplications.INSTANCE.getCLion-UtVBrGo()) || ApplicationType.equals-impl0(this.toolId, WellKnownApplications.INSTANCE.getAppCode-UtVBrGo()))) {
            rank += (float)Math.pow(2.0f, AvailableToolMatchRanks.OneLetterLanguage.getRank());
        }
        if (UtilKt.valueMatches(this.name, filter2)) {
            rank += (float)Math.pow(2.0f, AvailableToolMatchRanks.Name.getRank());
        }
        if (UtilKt.valueMatches(this.description, filter2)) {
            rank += (float)Math.pow(2.0f, AvailableToolMatchRanks.Description.getRank());
        }
        if (UtilKt.valueMatches(CollectionsKt.joinToString$default((Iterable)this.languages, null, null, null, (int)0, null, AvailableToolViewState::rankByMatch$lambda$3, (int)31, null), filter2) || UtilKt.valueMatches(this.getTechnologies(), filter2)) {
            rank += (float)Math.pow(2.0f, AvailableToolMatchRanks.Language.getRank());
        }
        return (int)rank;
    }

    @NotNull
    public String toString() {
        return "AvailableToolViewState(toolId=" + ApplicationType.toString-impl(this.toolId) + ", name=" + this.name + ", description=" + this.description + ", vendor=" + this.vendor + ", icon=" + this.icon + ", stableVersionName=" + this.stableVersionName + ", latestBuildNumber=" + BuildNumber.toString-impl(this.latestBuildNumber) + ", freshnessPeriod=" + this.freshnessPeriod + ", licenseInfo=" + this.licenseInfo + ", languages=" + this.languages + ", htmlDescription=" + this.htmlDescription + ", bestDistribution=" + this.bestDistribution + ")";
    }

    public int hashCode() {
        int result2 = ApplicationType.hashCode-impl(this.toolId);
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.description.hashCode();
        result2 = result2 * 31 + (this.vendor == null ? 0 : this.vendor.hashCode());
        result2 = result2 * 31 + (this.icon == null ? 0 : this.icon.hashCode());
        result2 = result2 * 31 + this.stableVersionName.hashCode();
        result2 = result2 * 31 + BuildNumber.hashCode-impl(this.latestBuildNumber);
        result2 = result2 * 31 + (this.freshnessPeriod == null ? 0 : this.freshnessPeriod.hashCode());
        result2 = result2 * 31 + (this.licenseInfo == null ? 0 : this.licenseInfo.hashCode());
        result2 = result2 * 31 + ((Object)this.languages).hashCode();
        result2 = result2 * 31 + (this.htmlDescription == null ? 0 : this.htmlDescription.hashCode());
        result2 = result2 * 31 + this.bestDistribution.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AvailableToolViewState)) {
            return false;
        }
        AvailableToolViewState availableToolViewState = (AvailableToolViewState)other;
        if (!ApplicationType.equals-impl0(this.toolId, availableToolViewState.toolId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)availableToolViewState.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)availableToolViewState.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.vendor, (Object)availableToolViewState.vendor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.icon, (Object)availableToolViewState.icon)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stableVersionName, (Object)availableToolViewState.stableVersionName)) {
            return false;
        }
        if (!BuildNumber.equals-impl0(this.latestBuildNumber, availableToolViewState.latestBuildNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.freshnessPeriod, (Object)availableToolViewState.freshnessPeriod)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.licenseInfo, (Object)availableToolViewState.licenseInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.languages, availableToolViewState.languages)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.htmlDescription, (Object)availableToolViewState.htmlDescription)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.bestDistribution, (Object)availableToolViewState.bestDistribution);
    }

    private static final String technologies_delegate$lambda$2(AvailableToolViewState this$0) {
        String string;
        Object v1;
        String htmlDescription;
        block7: {
            String string2 = this$0.htmlDescription;
            if (string2 == null) {
                return "";
            }
            htmlDescription = string2;
            Iterable $this$firstOrNull$iv = AvailableToolViewStateKt.access$getSupportedLanguagesPrefixes();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)htmlDescription, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                v1 = element$iv;
                break block7;
            }
            v1 = null;
        }
        String string3 = v1;
        if (string3 == null) {
            return "";
        }
        String prefix = string3;
        String it = StringsKt.substringAfter$default((String)htmlDescription, (String)prefix, null, (int)2, null);
        boolean bl = false;
        if (StringsKt.startsWith$default((String)it, (String)"<br>", (boolean)false, (int)2, null)) {
            string = StringsKt.substringAfter$default((String)it, (String)"<br>", null, (int)2, null);
        } else if (StringsKt.startsWith$default((String)it, (String)"<ul>", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"</li><li>"};
            string = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)it, (String)"<li>", null, (int)2, null), (String)"</li>", null, (int)2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null), null, null, null, (int)0, null, null, (int)63, null);
        } else {
            string = "";
        }
        return string;
    }

    private static final CharSequence rankByMatch$lambda$3(SupportedLanguage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDisplayName();
    }

    public /* synthetic */ AvailableToolViewState(String toolId, String name2, String description2, String vendor, Image icon2, String stableVersionName, String latestBuildNumber, FreshnessPeriod freshnessPeriod, LicenseInfo licenseInfo, List languages, String htmlDescription, DistributionId bestDistribution, DefaultConstructorMarker $constructor_marker) {
        this(toolId, name2, description2, vendor, icon2, stableVersionName, latestBuildNumber, freshnessPeriod, licenseInfo, languages, htmlDescription, bestDistribution);
    }
}

