/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.settings.remote;

import com.jetbrains.toolbox.agent.network.mappers.DtoMappers;
import com.jetbrains.toolbox.agentNetworkApi.settings.SettingsService;
import com.jetbrains.toolbox.agentNetworkApi.settings.dto.LoggingLevelDto;
import com.jetbrains.toolbox.agentNetworkApi.settings.dto.SettingsDto;
import com.jetbrains.toolbox.environment.EnvironmentDescriptorManager;
import com.jetbrains.toolbox.environment.model.EnvironmentDescriptor;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.openssh.SshExecutable;
import com.jetbrains.toolbox.settings.GraphicsApi;
import com.jetbrains.toolbox.settings.HttpLoggingVerbosity;
import com.jetbrains.toolbox.viewmodel.settings.SettingsViewModel;
import com.jetbrains.toolbox.viewmodel.settings.SettingsViewState;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.Level;

public final class RemoteAdvancedSettingsViewModel
implements SettingsViewModel.Advanced {
    @NotNull
    private final SettingsService settingsService;
    @NotNull
    private final EnvironmentDescriptorManager environmentDescriptorManager;
    @NotNull
    private final CoroutineScope envCoroutineScope;
    @NotNull
    private final StateFlow<SettingsViewState.Advanced> state;

    public RemoteAdvancedSettingsViewModel(@NotNull SettingsService settingsService, @NotNull EnvironmentDescriptorManager environmentDescriptorManager, @NotNull CoroutineScope envCoroutineScope, @NotNull CoroutineScope publishCoroutineScope) {
        Intrinsics.checkNotNullParameter((Object)settingsService, (String)"settingsService");
        Intrinsics.checkNotNullParameter((Object)environmentDescriptorManager, (String)"environmentDescriptorManager");
        Intrinsics.checkNotNullParameter((Object)envCoroutineScope, (String)"envCoroutineScope");
        Intrinsics.checkNotNullParameter((Object)publishCoroutineScope, (String)"publishCoroutineScope");
        this.settingsService = settingsService;
        this.environmentDescriptorManager = environmentDescriptorManager;
        this.envCoroutineScope = envCoroutineScope;
        this.state = FlowKt.stateIn((Flow)FlowKt.combine((Flow)this.settingsService.getSettings(), (Flow)((Flow)this.environmentDescriptorManager.getEnvironmentDescriptor()), (Function3)((Function3)new Function3<SettingsDto, EnvironmentDescriptor, Continuation<? super SettingsViewState.Advanced>, Object>(null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                SettingsDto settingsDto = (SettingsDto)this.L$0;
                EnvironmentDescriptor environmentDescriptor = (EnvironmentDescriptor)this.L$1;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void settingsDto2;
                        void environmentDescriptor2;
                        ResultKt.throwOnFailure((Object)$result);
                        if (environmentDescriptor2 == null) {
                            return null;
                        }
                        LoggingLevelDto loggingLevelDto = settingsDto2.getLoggingLevel();
                        if (loggingLevelDto == null || (loggingLevelDto = DtoMappers.toLoggingLevel(loggingLevelDto)) == null) {
                            loggingLevelDto = Level.INFO;
                        }
                        LoggingLevelDto loggingLevelDto2 = loggingLevelDto;
                        List<Level> list2 = SettingsViewModel.Advanced.Companion.getAvailableLoggingLevels();
                        HttpLoggingVerbosity httpLoggingVerbosity = DtoMappers.toVerbosity(settingsDto2.getHttpLoggingVerbosity());
                        List<HttpLoggingVerbosity> list3 = SettingsViewModel.Advanced.Companion.getAvailableHttpLoggingVerbosity();
                        Boolean bl = Boxing.boxBoolean((boolean)settingsDto2.getAllowPatches());
                        boolean it = bl;
                        boolean bl2 = false;
                        Boolean bl3 = environmentDescriptor2.getTools().getAllowUpdate() ? bl : null;
                        return new SettingsViewState.Advanced(null, bl3, null, null, null, (Level)loggingLevelDto2, list2, null, httpLoggingVerbosity, list3, null, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(SettingsDto p1, EnvironmentDescriptor p2, Continuation<? super SettingsViewState.Advanced> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)publishCoroutineScope, (SharingStarted)SharingStarted.Companion.getEagerly(), null);
    }

    @Override
    @NotNull
    public StateFlow<SettingsViewState.Advanced> getState() {
        return this.state;
    }

    @Override
    public void onAllowPatchesChange(boolean value2) {
        this.launchInEnvScope((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value2, null){
            int label;
            final /* synthetic */ RemoteAdvancedSettingsViewModel this$0;
            final /* synthetic */ boolean $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = RemoteAdvancedSettingsViewModel.access$getSettingsService$p(this.this$0).setAllowPatches(this.$value, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public void onLoggingLevelChange(@NotNull Level value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.launchInEnvScope((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value2, null){
            int label;
            final /* synthetic */ RemoteAdvancedSettingsViewModel this$0;
            final /* synthetic */ Level $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = RemoteAdvancedSettingsViewModel.access$getSettingsService$p(this.this$0).setLoggingLevel(DtoMappers.toDto(this.$value), (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public void onHttpLoggingVerbosityChange(@NotNull HttpLoggingVerbosity value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        this.launchInEnvScope((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value2, null){
            int label;
            final /* synthetic */ RemoteAdvancedSettingsViewModel this$0;
            final /* synthetic */ HttpLoggingVerbosity $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = RemoteAdvancedSettingsViewModel.access$getSettingsService$p(this.this$0).setHttpLoggingVerbosity(DtoMappers.toDto(this.$value), (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public void onSshExecutableChange(@Nullable SshExecutable value2) {
    }

    @Override
    public boolean onCustomSshExecutablePathChange(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return false;
    }

    private final void launchInEnvScope(Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> block) {
        BuildersKt.launch$default((CoroutineScope)this.envCoroutineScope, null, null, block, (int)3, null);
    }

    @Override
    public void onSectionExpand(@NotNull FusEnums.UIGenerator eventGenerator) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventGenerator), (String)"eventGenerator");
    }

    @NotNull
    public Void onShowInstalledBuildChange(boolean value2) {
        this.methodIsNotSupported();
        throw new KotlinNothingValueException();
    }

    @NotNull
    public Void onSubmitExceptionsAutomaticallyChange(boolean value2) {
        this.methodIsNotSupported();
        throw new KotlinNothingValueException();
    }

    @NotNull
    public Void onAdditionalHeaderNameChange(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.methodIsNotSupported();
        throw new KotlinNothingValueException();
    }

    @NotNull
    public Void onAdditionalHeaderValueChange(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.methodIsNotSupported();
        throw new KotlinNothingValueException();
    }

    @NotNull
    public Void onGraphicsApiChange(@NotNull GraphicsApi value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        this.methodIsNotSupported();
        throw new KotlinNothingValueException();
    }

    @NotNull
    public Void loadAdditionalHeaderOnce() {
        this.methodIsNotSupported();
        throw new KotlinNothingValueException();
    }

    private final Void methodIsNotSupported() {
        throw new IllegalStateException("method is not supported".toString());
    }

    public static final /* synthetic */ SettingsService access$getSettingsService$p(RemoteAdvancedSettingsViewModel $this) {
        return $this.settingsService;
    }
}

