/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.settings.local;

import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.fus.FusFieldDescriptions;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.manager.StatisticsManager;
import com.jetbrains.toolbox.viewmodel.settings.SettingsViewModel;
import com.jetbrains.toolbox.viewmodel.settings.SettingsViewState;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class LocalSettingsViewModel
implements SettingsViewModel {
    @NotNull
    private final SettingsViewModel.About about;
    @NotNull
    private final SettingsViewModel.Accounts accounts;
    @NotNull
    private final SettingsViewModel.Appearance appearance;
    @NotNull
    private final SettingsViewModel.Tools tools;
    @NotNull
    private final SettingsViewModel.Proxy proxy;
    @NotNull
    private final SettingsViewModel.Advanced advanced;
    @NotNull
    private final SettingsViewModel.Internal internal;
    @NotNull
    private final StatisticsManager statisticsManager;
    @NotNull
    private final StateFlow<SettingsViewState> state;

    public LocalSettingsViewModel(@NotNull SettingsViewModel.About about, @NotNull SettingsViewModel.Accounts accounts2, @NotNull SettingsViewModel.Appearance appearance, @NotNull SettingsViewModel.Tools tools2, @NotNull SettingsViewModel.Proxy proxy, @NotNull SettingsViewModel.Advanced advanced, @NotNull SettingsViewModel.Internal internal, @NotNull StatisticsManager statisticsManager) {
        Intrinsics.checkNotNullParameter((Object)about, (String)"about");
        Intrinsics.checkNotNullParameter((Object)accounts2, (String)"accounts");
        Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
        Intrinsics.checkNotNullParameter((Object)tools2, (String)"tools");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)advanced, (String)"advanced");
        Intrinsics.checkNotNullParameter((Object)internal, (String)"internal");
        Intrinsics.checkNotNullParameter((Object)statisticsManager, (String)"statisticsManager");
        this.about = about;
        this.accounts = accounts2;
        this.appearance = appearance;
        this.tools = tools2;
        this.proxy = proxy;
        this.advanced = advanced;
        this.internal = internal;
        this.statisticsManager = statisticsManager;
        this.state = FlowExtensionsKt.combineStates(this.getAccounts().getState(), this.getAppearance().getState(), this.getTools().getState(), this.getProxy().getState(), this.getAdvanced().getState(), this.getInternal().getState(), LocalSettingsViewModel::state$lambda$0);
    }

    @Override
    @NotNull
    public SettingsViewModel.About getAbout() {
        return this.about;
    }

    @Override
    @NotNull
    public SettingsViewModel.Accounts getAccounts() {
        return this.accounts;
    }

    @Override
    @NotNull
    public SettingsViewModel.Appearance getAppearance() {
        return this.appearance;
    }

    @Override
    @NotNull
    public SettingsViewModel.Tools getTools() {
        return this.tools;
    }

    @Override
    @NotNull
    public SettingsViewModel.Proxy getProxy() {
        return this.proxy;
    }

    @Override
    @NotNull
    public SettingsViewModel.Advanced getAdvanced() {
        return this.advanced;
    }

    @Override
    @NotNull
    public SettingsViewModel.Internal getInternal() {
        return this.internal;
    }

    @Override
    @NotNull
    public StateFlow<SettingsViewState> getState() {
        return this.state;
    }

    @Override
    public void onTabSwitch(@NotNull FusEnums.UITab uiTab, @NotNull FusEnums.UIGenerator eventGenerator) {
        Intrinsics.checkNotNullParameter((Object)((Object)uiTab), (String)"uiTab");
        Intrinsics.checkNotNullParameter((Object)((Object)eventGenerator), (String)"eventGenerator");
        this.statisticsManager.getLogger().logVararg(Fus.Counters.UI.INSTANCE.getSelfSettings(), arg_0 -> LocalSettingsViewModel.onTabSwitch$lambda$1(eventGenerator, uiTab, arg_0));
    }

    @Override
    public void onShowLogFilesClick() {
        this.getAbout().onShowLogFilesClick();
    }

    private static final SettingsViewState state$lambda$0(SettingsViewState.Accounts accounts2, SettingsViewState.Appearance appearance, SettingsViewState.Tools tools2, SettingsViewState.Proxy proxy, SettingsViewState.Advanced advanced, SettingsViewState.Internal internal) {
        Intrinsics.checkNotNullParameter((Object)accounts2, (String)"accounts");
        Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
        return new SettingsViewState(LocalizableStringExKt.trl("Toolbox App"), accounts2, appearance, tools2, proxy, advanced, internal, null);
    }

    private static final Unit onTabSwitch$lambda$1(FusEnums.UIGenerator $eventGenerator, FusEnums.UITab $uiTab, FusFieldDescriptions.UISettings $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setAction(FusEnums.UIAction.OPEN);
        $this$logVararg.setGenerator($eventGenerator);
        $this$logVararg.setTab($uiTab);
        return Unit.INSTANCE;
    }
}

