/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.settings.local;

import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.fus.FusFieldDescriptions;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.integration.OSIntegrationManager;
import com.jetbrains.toolbox.manager.StatisticsManager;
import com.jetbrains.toolbox.settings.ProxyAuthSettings;
import com.jetbrains.toolbox.settings.ProxySettings;
import com.jetbrains.toolbox.settings.ProxyType;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.viewmodel.settings.SettingsViewModel;
import com.jetbrains.toolbox.viewmodel.settings.SettingsViewState;
import com.jetbrains.toolbox.viewmodel.settings.local.LocalProxySettingsViewModel;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nLocalProxySettingsViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalProxySettingsViewModel.kt\ncom/jetbrains/toolbox/viewmodel/settings/local/LocalProxySettingsViewModel\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n*L\n1#1,181:1\n230#2,5:182\n230#2,5:187\n230#2,5:199\n7#3,7:192\n*S KotlinDebug\n*F\n+ 1 LocalProxySettingsViewModel.kt\ncom/jetbrains/toolbox/viewmodel/settings/local/LocalProxySettingsViewModel\n*L\n92#1:182,5\n133#1:187,5\n139#1:199,5\n135#1:192,7\n*E\n"})
public final class LocalProxySettingsViewModel
implements SettingsViewModel.Proxy.Transactional {
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final OSIntegrationManager osIntegrationManager;
    @NotNull
    private final StatisticsManager statisticsManager;
    @NotNull
    private final CoroutineScope uiCoroutineScope;
    @NotNull
    private final CoroutineScope appCoroutineScope;
    private final boolean isAutoSaveEnabled;
    @NotNull
    private final Mutex passwordMutex;
    @NotNull
    private final MutableStateFlow<SettingsViewState.Proxy> _state;
    @NotNull
    private final StateFlow<SettingsViewState.Proxy> state;

    public LocalProxySettingsViewModel(@NotNull SettingsManager settingsManager, @NotNull OSIntegrationManager osIntegrationManager, @NotNull StatisticsManager statisticsManager, @NotNull CoroutineScope uiCoroutineScope, @NotNull CoroutineScope appCoroutineScope, boolean isAutoSaveEnabled) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)osIntegrationManager, (String)"osIntegrationManager");
        Intrinsics.checkNotNullParameter((Object)statisticsManager, (String)"statisticsManager");
        Intrinsics.checkNotNullParameter((Object)uiCoroutineScope, (String)"uiCoroutineScope");
        Intrinsics.checkNotNullParameter((Object)appCoroutineScope, (String)"appCoroutineScope");
        this.settingsManager = settingsManager;
        this.osIntegrationManager = osIntegrationManager;
        this.statisticsManager = statisticsManager;
        this.uiCoroutineScope = uiCoroutineScope;
        this.appCoroutineScope = appCoroutineScope;
        this.isAutoSaveEnabled = isAutoSaveEnabled;
        this.passwordMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this._state = StateFlowKt.MutableStateFlow((Object)this.toViewState(((SelfSettings)this.settingsManager.getSettings().getValue()).getProxy(), null));
        this.state = (StateFlow)this._state;
    }

    @Override
    @NotNull
    public StateFlow<SettingsViewState.Proxy> getState() {
        return this.state;
    }

    @Override
    public void onSectionExpand(@NotNull FusEnums.UIGenerator eventGenerator) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventGenerator), (String)"eventGenerator");
        this.statisticsManager.getLogger().logVararg(Fus.Counters.UI.INSTANCE.getSelfSettings(), LocalProxySettingsViewModel::onSectionExpand$lambda$0);
    }

    @Override
    public void onProxyTypeChange(@NotNull SettingsViewState.Proxy.Type value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        LocalProxySettingsViewModel.updateProperty$default(this, false, arg_0 -> LocalProxySettingsViewModel.onProxyTypeChange$lambda$1(value2, arg_0), 1, null);
    }

    @Override
    public void onConfigurationUrlChange(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        LocalProxySettingsViewModel.updateProperty$default(this, false, arg_0 -> LocalProxySettingsViewModel.onConfigurationUrlChange$lambda$2(value2, arg_0), 1, null);
    }

    @Override
    public void onHostChange(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        LocalProxySettingsViewModel.updateProperty$default(this, false, arg_0 -> LocalProxySettingsViewModel.onHostChange$lambda$3(value2, arg_0), 1, null);
    }

    @Override
    public void onPortChange(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        LocalProxySettingsViewModel.updateProperty$default(this, false, arg_0 -> LocalProxySettingsViewModel.onPortChange$lambda$4(value2, arg_0), 1, null);
    }

    @Override
    public void onUsernameChange(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        LocalProxySettingsViewModel.updateProperty$default(this, false, arg_0 -> LocalProxySettingsViewModel.onUsernameChange$lambda$5(value2, arg_0), 1, null);
    }

    @Override
    public void onPasswordChange(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.updateProperty(true, (Function1<? super SettingsViewState.Proxy, SettingsViewState.Proxy>)((Function1)arg_0 -> LocalProxySettingsViewModel.onPasswordChange$lambda$6(value2, arg_0)));
    }

    @Override
    public void loadPasswordOnce() {
        BuildersKt.launch$default((CoroutineScope)this.appCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LocalProxySettingsViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (((SettingsViewState.Proxy)LocalProxySettingsViewModel.access$get_state$p(this.this$0).getValue()).getPassword() == null) {
                            CharSequence charSequence;
                            SettingsViewState.Proxy it;
                            SettingsViewState.Proxy nextValue$iv;
                            Object prevValue$iv;
                            void $this$update$iv;
                            MutableStateFlow mutableStateFlow = LocalProxySettingsViewModel.access$get_state$p(this.this$0);
                            LocalProxySettingsViewModel localProxySettingsViewModel = this.this$0;
                            boolean $i$f$update = false;
                            do {
                                prevValue$iv = $this$update$iv.getValue();
                                it = (SettingsViewState.Proxy)prevValue$iv;
                                boolean bl = false;
                            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SettingsViewState.Proxy.copy$default(it, null, null, null, null, null, null, (charSequence = (CharSequence)it.getUsername()) == null || charSequence.length() == 0 ? "" : LocalProxySettingsViewModel.access$getSettingsManager$p(localProxySettingsViewModel).getProxyPassword(), false, false, null, 959, null))));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void openSystemProxySettings() {
        this.osIntegrationManager.openSystemProxySettings();
    }

    private final void updateProperty(boolean isPasswordUpdated, Function1<? super SettingsViewState.Proxy, SettingsViewState.Proxy> transform2) {
        SettingsViewState.Proxy it;
        SettingsViewState.Proxy nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<SettingsViewState.Proxy> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (SettingsViewState.Proxy)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SettingsViewState.Proxy.copy$default((SettingsViewState.Proxy)transform2.invoke((Object)it), null, null, null, null, null, null, null, false, false, SettingsViewState.Proxy.ConnectionStatus.NotChecked.INSTANCE, 511, null))));
        if (this.isAutoSaveEnabled) {
            this.save(isPasswordUpdated);
        }
    }

    static /* synthetic */ void updateProperty$default(LocalProxySettingsViewModel localProxySettingsViewModel, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        localProxySettingsViewModel.updateProperty(bl, (Function1<? super SettingsViewState.Proxy, SettingsViewState.Proxy>)function1);
    }

    @Override
    public void save(boolean savePassword) {
        SettingsViewState.Proxy proxySettings2 = (SettingsViewState.Proxy)this._state.getValue();
        this.settingsManager.updateSettings((Function1<? super SelfSettings, SelfSettings>)((Function1)arg_0 -> LocalProxySettingsViewModel.save$lambda$8(this, proxySettings2, arg_0)));
        if (savePassword) {
            BuildersKt.launch$default((CoroutineScope)this.uiCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, proxySettings2, null){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                int I$1;
                int label;
                final /* synthetic */ LocalProxySettingsViewModel this$0;
                final /* synthetic */ SettingsViewState.Proxy $proxySettings;
                {
                    this.this$0 = $receiver;
                    this.$proxySettings = $proxySettings;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var2_3 = LocalProxySettingsViewModel.access$getPasswordMutex$p(this.this$0);
                            var4_4 = this.this$0;
                            var5_5 = this.$proxySettings;
                            owner$iv = null;
                            $i$f$withLock = 0;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = var4_4;
                            this.L$2 = var5_5;
                            this.I$0 = $i$f$withLock;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl28
                        }
                        case 1: {
                            $i$f$withLock = this.I$0;
                            var5_5 = (SettingsViewState.Proxy)this.L$2;
                            var4_4 = (LocalProxySettingsViewModel)this.L$1;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl28:
                            // 3 sources

                            $i$a$-withLock$default-LocalProxySettingsViewModel$save$2$1 = 0;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = null;
                            this.L$2 = null;
                            this.I$0 = $i$f$withLock;
                            this.I$1 = $i$a$-withLock$default-LocalProxySettingsViewModel$save$2$1;
                            this.label = 2;
                            v1 = BuildersKt.withContext((CoroutineContext)LocalProxySettingsViewModel.access$getAppCoroutineScope$p(var4_4).getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(var4_4, var5_5, null){
                                int label;
                                final /* synthetic */ LocalProxySettingsViewModel this$0;
                                final /* synthetic */ SettingsViewState.Proxy $proxySettings;
                                {
                                    this.this$0 = $receiver;
                                    this.$proxySettings = $proxySettings;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            SettingsManager settingsManager = LocalProxySettingsViewModel.access$getSettingsManager$p(this.this$0);
                                            String string = this.$proxySettings.getPassword();
                                            if (string == null) {
                                                string = "";
                                            }
                                            settingsManager.setProxyPassword(string);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                            ** if (v1 != var10_2) goto lbl39
lbl38:
                            // 1 sources

                            return var10_2;
lbl39:
                            // 1 sources

                            ** GOTO lbl49
                        }
                        case 2: {
                            $i$a$-withLock$default-LocalProxySettingsViewModel$save$2$1 = this.I$1;
                            $i$f$withLock = this.I$0;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl49:
                                // 2 sources

                                var8_11 = Unit.INSTANCE;
                            }
                            catch (Throwable var9_12) {
                                throw var9_12;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Override
    public void reset() {
        this._state.setValue((Object)this.toViewState(((SelfSettings)this.settingsManager.getSettings().getValue()).getProxy(), null));
        this.loadPasswordOnce();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public <T> Object testConnection(@NotNull Function1<? super Continuation<? super T>, ? extends Object> testCall, @NotNull Continuation<? super T> $completion) {
        if (!($completion instanceof testConnection.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ LocalProxySettingsViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.testConnection(null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$update$iv = this._state;
                $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    it = (SettingsViewState.Proxy)prevValue$iv;
                    $i$a$-update-LocalProxySettingsViewModel$testConnection$2 = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, nextValue$iv = SettingsViewState.Proxy.copy$default(it, null, null, null, null, null, null, null, false, false, SettingsViewState.Proxy.ConnectionStatus.Connecting.INSTANCE, 511, null)));
                $i$f$catching = 0;
                $i$a$-catching-LocalProxySettingsViewModel$testConnection$callResponse$1 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)testCall);
                $continuation.I$0 = $i$f$catching;
                $continuation.I$1 = $i$a$-catching-LocalProxySettingsViewModel$testConnection$callResponse$1;
                $continuation.label = 1;
                v0 = testCall.invoke($continuation);
                ** if (v0 != var11_5) goto lbl33
lbl32:
                // 1 sources

                return var11_5;
lbl33:
                // 1 sources

                ** GOTO lbl43
            }
            case 1: {
                $i$a$-catching-LocalProxySettingsViewModel$testConnection$callResponse$1 = $continuation.I$1;
                $i$f$catching = $continuation.I$0;
                testCall = (Function1)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl43:
                    // 2 sources

                    nextValue$iv = Result.constructor-impl((Object)v0);
                }
                catch (CancellationException c$iv) {
                    throw c$iv;
                }
                catch (Throwable t$iv) {
                    nextValue$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                }
                $i$f$catching = nextValue$iv;
                callResponse = Result.isFailure-impl((Object)$i$f$catching) != false ? null : $i$f$catching;
                $this$update$iv = this._state;
                $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    it = (SettingsViewState.Proxy)prevValue$iv;
                    $i$a$-update-LocalProxySettingsViewModel$testConnection$3 = false;
                    if (callResponse != null) {
                        v1 = SettingsViewState.Proxy.ConnectionStatus.Valid.INSTANCE;
                        continue;
                    }
                    v1 = new SettingsViewState.Proxy.ConnectionStatus.Failure(LocalizableStringExKt.trl("Cannot connect"));
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SettingsViewState.Proxy.copy$default(it, null, null, null, null, null, null, null, false, false, v1, 511, null))));
                return callResponse;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final SettingsViewState.Proxy toViewState(ProxySettings $this$toViewState, String password) {
        return new SettingsViewState.Proxy((List)SettingsViewState.Proxy.Type.getEntries(), this.toViewState($this$toViewState.getType()), $this$toViewState.getConfigurationUrl(), $this$toViewState.getHost(), $this$toViewState.getPort() == 0 ? "" : String.valueOf($this$toViewState.getPort()), $this$toViewState.getAuth().getUsername(), password, true, true, SettingsViewState.Proxy.ConnectionStatus.NotChecked.INSTANCE);
    }

    private final SettingsViewState.Proxy.Type toViewState(ProxyType $this$toViewState) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toViewState.ordinal()]) {
            case 1 -> SettingsViewState.Proxy.Type.Disabled;
            case 2 -> SettingsViewState.Proxy.Type.System;
            case 3 -> SettingsViewState.Proxy.Type.Automatic;
            case 4 -> SettingsViewState.Proxy.Type.HTTP;
            case 5 -> SettingsViewState.Proxy.Type.SOCKS;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final ProxyType toDomain(SettingsViewState.Proxy.Type $this$toDomain) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toDomain.ordinal()]) {
            case 1 -> ProxyType.Disabled;
            case 2 -> ProxyType.System;
            case 3 -> ProxyType.Automatic;
            case 4 -> ProxyType.HTTP;
            case 5 -> ProxyType.SOCKS;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit onSectionExpand$lambda$0(FusFieldDescriptions.UISettings $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setAction(FusEnums.UIAction.EXPAND_SECTION);
        $this$logVararg.setGenerator(FusEnums.UIGenerator.MOUSE);
        $this$logVararg.setSection(FusEnums.SelfSettingsSection.PROXY);
        return Unit.INSTANCE;
    }

    private static final SettingsViewState.Proxy onProxyTypeChange$lambda$1(SettingsViewState.Proxy.Type $value, SettingsViewState.Proxy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SettingsViewState.Proxy.copy$default(it, null, $value, null, null, null, null, null, false, false, null, 1021, null);
    }

    private static final SettingsViewState.Proxy onConfigurationUrlChange$lambda$2(String $value, SettingsViewState.Proxy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SettingsViewState.Proxy.copy$default(it, null, null, $value, null, null, null, null, false, false, null, 1019, null);
    }

    private static final SettingsViewState.Proxy onHostChange$lambda$3(String $value, SettingsViewState.Proxy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SettingsViewState.Proxy.copy$default(it, null, null, null, $value, null, null, null, false, false, null, 1015, null);
    }

    private static final SettingsViewState.Proxy onPortChange$lambda$4(String $value, SettingsViewState.Proxy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SettingsViewState.Proxy.copy$default(it, null, null, null, null, $value, null, null, false, false, null, 1007, null);
    }

    private static final SettingsViewState.Proxy onUsernameChange$lambda$5(String $value, SettingsViewState.Proxy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SettingsViewState.Proxy.copy$default(it, null, null, null, null, null, $value, null, false, false, null, 991, null);
    }

    private static final SettingsViewState.Proxy onPasswordChange$lambda$6(String $value, SettingsViewState.Proxy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SettingsViewState.Proxy.copy$default(it, null, null, null, null, null, null, $value, false, false, null, 959, null);
    }

    private static final SelfSettings save$lambda$8(LocalProxySettingsViewModel this$0, SettingsViewState.Proxy $proxySettings, SelfSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ProxySettings proxySettings2 = it.getProxy();
        ProxyType proxyType = this$0.toDomain($proxySettings.getType());
        String string = $proxySettings.getConfigurationUrl();
        String string2 = $proxySettings.getHost();
        Integer n = StringsKt.toIntOrNull((String)$proxySettings.getPort());
        int n2 = n != null ? n : 0;
        ProxyAuthSettings proxyAuthSettings = it.getProxy().getAuth();
        String string3 = $proxySettings.getUsername();
        if (string3 == null) {
            string3 = "";
        }
        return SelfSettings.copy$default(it, null, null, false, false, null, 0, null, null, proxySettings2.copy(proxyType, string, string2, n2, proxyAuthSettings.copy(string3)), null, null, null, null, null, null, null, null, 130815, null);
    }

    public static final /* synthetic */ MutableStateFlow access$get_state$p(LocalProxySettingsViewModel $this) {
        return $this._state;
    }

    public static final /* synthetic */ SettingsManager access$getSettingsManager$p(LocalProxySettingsViewModel $this) {
        return $this.settingsManager;
    }

    public static final /* synthetic */ Mutex access$getPasswordMutex$p(LocalProxySettingsViewModel $this) {
        return $this.passwordMutex;
    }

    public static final /* synthetic */ CoroutineScope access$getAppCoroutineScope$p(LocalProxySettingsViewModel $this) {
        return $this.appCoroutineScope;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProxyType.values().length];
            try {
                nArray[ProxyType.Disabled.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyType.System.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyType.Automatic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyType.HTTP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyType.SOCKS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SettingsViewState.Proxy.Type.values().length];
            try {
                nArray[SettingsViewState.Proxy.Type.Disabled.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsViewState.Proxy.Type.System.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsViewState.Proxy.Type.Automatic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsViewState.Proxy.Type.HTTP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsViewState.Proxy.Type.SOCKS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

