/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.settings.local;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.BuildKt;
import com.jetbrains.toolbox.common.ToolboxLoggingProvider;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.fus.FusFieldDescriptions;
import com.jetbrains.toolbox.manager.StatisticsManager;
import com.jetbrains.toolbox.openssh.CommonOpenSshPathsProvider;
import com.jetbrains.toolbox.openssh.SshExecutable;
import com.jetbrains.toolbox.openssh.SshExecutableValidator;
import com.jetbrains.toolbox.settings.AdvancedSettings;
import com.jetbrains.toolbox.settings.GraphicsApi;
import com.jetbrains.toolbox.settings.HttpLoggingVerbosity;
import com.jetbrains.toolbox.settings.InternalSettings;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.settings.SettingsManagerKt;
import com.jetbrains.toolbox.viewmodel.settings.SettingsViewModel;
import com.jetbrains.toolbox.viewmodel.settings.SettingsViewState;
import com.jetbrains.toolbox.viewmodel.settings.local.LocalAdvancedSettingsViewModel;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.Level;

@SourceDebugExtension(value={"SMAP\nLocalAdvancedSettingsViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalAdvancedSettingsViewModel.kt\ncom/jetbrains/toolbox/viewmodel/settings/local/LocalAdvancedSettingsViewModel\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n116#2,11:145\n1#3:156\n*S KotlinDebug\n*F\n+ 1 LocalAdvancedSettingsViewModel.kt\ncom/jetbrains/toolbox/viewmodel/settings/local/LocalAdvancedSettingsViewModel\n*L\n97#1:145,11\n*E\n"})
public final class LocalAdvancedSettingsViewModel
implements SettingsViewModel.Advanced {
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final StatisticsManager statisticsManager;
    @NotNull
    private final ToolboxLoggingProvider loggingProvider;
    @NotNull
    private final SshExecutableValidator sshExecutableValidator;
    @NotNull
    private final CoroutineScope uiCoroutineScope;
    @NotNull
    private final CoroutineScope appCoroutineScope;
    @NotNull
    private final Mutex additionalHeaderValueMutex;
    @NotNull
    private final MutableStateFlow<String> additionalHeaderValue;
    @NotNull
    private final StateFlow<SettingsViewState.Advanced> state;

    public LocalAdvancedSettingsViewModel(@NotNull SettingsManager settingsManager, @NotNull StatisticsManager statisticsManager, @NotNull ToolboxLoggingProvider loggingProvider, @NotNull CommonOpenSshPathsProvider commonOpenSshPathsProvider, @NotNull SshExecutableValidator sshExecutableValidator, @NotNull CoroutineScope uiCoroutineScope, @NotNull CoroutineScope appCoroutineScope) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)statisticsManager, (String)"statisticsManager");
        Intrinsics.checkNotNullParameter((Object)loggingProvider, (String)"loggingProvider");
        Intrinsics.checkNotNullParameter((Object)commonOpenSshPathsProvider, (String)"commonOpenSshPathsProvider");
        Intrinsics.checkNotNullParameter((Object)sshExecutableValidator, (String)"sshExecutableValidator");
        Intrinsics.checkNotNullParameter((Object)uiCoroutineScope, (String)"uiCoroutineScope");
        Intrinsics.checkNotNullParameter((Object)appCoroutineScope, (String)"appCoroutineScope");
        this.settingsManager = settingsManager;
        this.statisticsManager = statisticsManager;
        this.loggingProvider = loggingProvider;
        this.sshExecutableValidator = sshExecutableValidator;
        this.uiCoroutineScope = uiCoroutineScope;
        this.appCoroutineScope = appCoroutineScope;
        this.additionalHeaderValueMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.additionalHeaderValue = StateFlowKt.MutableStateFlow(null);
        this.state = FlowExtensionsKt.combineStates(this.settingsManager.getSettings(), (StateFlow)this.additionalHeaderValue, (arg_0, arg_1) -> LocalAdvancedSettingsViewModel.state$lambda$2(this, commonOpenSshPathsProvider, arg_0, arg_1));
    }

    @Override
    @NotNull
    public StateFlow<SettingsViewState.Advanced> getState() {
        return this.state;
    }

    @Override
    public void onSectionExpand(@NotNull FusEnums.UIGenerator eventGenerator) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventGenerator), (String)"eventGenerator");
        this.statisticsManager.getLogger().logVararg(Fus.Counters.UI.INSTANCE.getSelfSettings(), arg_0 -> LocalAdvancedSettingsViewModel.onSectionExpand$lambda$3(eventGenerator, arg_0));
    }

    @Override
    public void onShowInstalledBuildChange(boolean value2) {
        SettingsManagerKt.updateAdvancedSettings(this.settingsManager, (Function1<? super AdvancedSettings, AdvancedSettings>)((Function1)arg_0 -> LocalAdvancedSettingsViewModel.onShowInstalledBuildChange$lambda$4(value2, arg_0)));
    }

    @Override
    public void onAllowPatchesChange(boolean value2) {
        SettingsManagerKt.updateAdvancedSettings(this.settingsManager, (Function1<? super AdvancedSettings, AdvancedSettings>)((Function1)arg_0 -> LocalAdvancedSettingsViewModel.onAllowPatchesChange$lambda$5(value2, arg_0)));
    }

    @Override
    public void onSubmitExceptionsAutomaticallyChange(boolean value2) {
        SettingsManagerKt.updateAdvancedSettings(this.settingsManager, (Function1<? super AdvancedSettings, AdvancedSettings>)((Function1)arg_0 -> LocalAdvancedSettingsViewModel.onSubmitExceptionsAutomaticallyChange$lambda$6(value2, arg_0)));
    }

    @Override
    public void onAdditionalHeaderNameChange(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        SettingsManagerKt.updateAdvancedSettings(this.settingsManager, (Function1<? super AdvancedSettings, AdvancedSettings>)((Function1)arg_0 -> LocalAdvancedSettingsViewModel.onAdditionalHeaderNameChange$lambda$7(value2, arg_0)));
    }

    @Override
    public void onAdditionalHeaderValueChange(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        BuildersKt.launch$default((CoroutineScope)this.uiCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value2, null){
            int label;
            final /* synthetic */ LocalAdvancedSettingsViewModel this$0;
            final /* synthetic */ String $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        LocalAdvancedSettingsViewModel.access$getAdditionalHeaderValue$p(this.this$0).setValue((Object)this.$value);
                        this.label = 1;
                        Object object2 = LocalAdvancedSettingsViewModel.access$updateAdditionalHeaderValue(this.this$0, this.$value, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object updateAdditionalHeaderValue(String value, Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateAdditionalHeaderValue.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ LocalAdvancedSettingsViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LocalAdvancedSettingsViewModel.access$updateAdditionalHeaderValue(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.additionalHeaderValueMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = value;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl31
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                value = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 3 sources

                $i$a$-withLock$default-LocalAdvancedSettingsViewModel$updateAdditionalHeaderValue$2 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-LocalAdvancedSettingsViewModel$updateAdditionalHeaderValue$2;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)this.appCoroutineScope.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value, null){
                    int label;
                    final /* synthetic */ LocalAdvancedSettingsViewModel this$0;
                    final /* synthetic */ String $value;
                    {
                        this.this$0 = $receiver;
                        this.$value = $value;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                LocalAdvancedSettingsViewModel.access$getSettingsManager$p(this.this$0).setApiKeyHeaderValue(this.$value);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var11_5) goto lbl41
lbl40:
                // 1 sources

                return var11_5;
lbl41:
                // 1 sources

                ** GOTO lbl52
            }
            case 2: {
                $i$a$-withLock$default-LocalAdvancedSettingsViewModel$updateAdditionalHeaderValue$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                value = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl52:
                    // 2 sources

                    var7_12 = Unit.INSTANCE;
                }
                catch (Throwable var8_13) {
                    throw var8_13;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void onGraphicsApiChange(@NotNull GraphicsApi value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        SettingsManagerKt.updateInternalSettings(this.settingsManager, (Function1<? super InternalSettings, InternalSettings>)((Function1)arg_0 -> LocalAdvancedSettingsViewModel.onGraphicsApiChange$lambda$9(value2, arg_0)));
    }

    @Override
    public void onLoggingLevelChange(@NotNull Level value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.loggingProvider.setLevel(value2);
        SettingsManagerKt.updateAdvancedSettings(this.settingsManager, (Function1<? super AdvancedSettings, AdvancedSettings>)((Function1)arg_0 -> LocalAdvancedSettingsViewModel.onLoggingLevelChange$lambda$11(value2, arg_0)));
    }

    @Override
    public void onHttpLoggingVerbosityChange(@NotNull HttpLoggingVerbosity value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        SettingsManagerKt.updateAdvancedSettings(this.settingsManager, (Function1<? super AdvancedSettings, AdvancedSettings>)((Function1)arg_0 -> LocalAdvancedSettingsViewModel.onHttpLoggingVerbosityChange$lambda$12(value2, arg_0)));
    }

    @Override
    public void onSshExecutableChange(@Nullable SshExecutable value2) {
        SettingsManagerKt.updateAdvancedSettings(this.settingsManager, (Function1<? super AdvancedSettings, AdvancedSettings>)((Function1)arg_0 -> LocalAdvancedSettingsViewModel.onSshExecutableChange$lambda$13(value2, arg_0)));
    }

    @Override
    public boolean onCustomSshExecutablePathChange(@NotNull String value2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        SshExecutableValidator.Result res2 = this.sshExecutableValidator.validate(value2);
        if (res2 instanceof SshExecutableValidator.Result.Success) {
            SettingsManagerKt.updateAdvancedSettings(this.settingsManager, (Function1<? super AdvancedSettings, AdvancedSettings>)((Function1)arg_0 -> LocalAdvancedSettingsViewModel.onCustomSshExecutablePathChange$lambda$14(res2, value2, arg_0)));
            bl = true;
        } else if (res2 instanceof SshExecutableValidator.Result.Failure) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public void loadAdditionalHeaderOnce() {
        BuildersKt.launch$default((CoroutineScope)this.appCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LocalAdvancedSettingsViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (LocalAdvancedSettingsViewModel.access$getAdditionalHeaderValue$p(this.this$0).getValue() == null) {
                            CharSequence charSequence;
                            LocalAdvancedSettingsViewModel.access$getAdditionalHeaderValue$p(this.this$0).setValue((Object)((charSequence = (CharSequence)((SettingsViewState.Advanced)this.this$0.getState().getValue()).getAdditionalHeaderName()) == null || charSequence.length() == 0 ? "" : LocalAdvancedSettingsViewModel.access$getSettingsManager$p(this.this$0).getApiKeyHeaderValue()));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final SettingsViewState.Advanced state$lambda$2(LocalAdvancedSettingsViewModel this$0, CommonOpenSshPathsProvider $commonOpenSshPathsProvider, SelfSettings settings2, String additionalHeaderValue) {
        List<SshExecutable> list2;
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        AdvancedSettings $this$state_u24lambda_u242_u24lambda_u241 = settings2.getAdvanced();
        boolean bl = false;
        Boolean bl2 = $this$state_u24lambda_u242_u24lambda_u241.getShowInstalledBuild();
        Boolean bl3 = $this$state_u24lambda_u242_u24lambda_u241.getAllowPatches();
        Boolean bl4 = $this$state_u24lambda_u242_u24lambda_u241.getSubmitExceptionsAutomatically();
        String string = $this$state_u24lambda_u242_u24lambda_u241.getApiKeyHeader();
        Level level = this$0.loggingProvider.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        List<SshExecutable> list3 = list2 = $commonOpenSshPathsProvider.getPaths();
        SshExecutable sshExecutable = $this$state_u24lambda_u242_u24lambda_u241.getUserSelectedSshExecutable();
        List<HttpLoggingVerbosity> list4 = SettingsViewModel.Advanced.Companion.getAvailableHttpLoggingVerbosity();
        HttpLoggingVerbosity httpLoggingVerbosity = $this$state_u24lambda_u242_u24lambda_u241.getHttpLoggingVerbosity();
        GraphicsApi graphicsApi = settings2.getInternal().getGraphicsApi();
        List<Level> list5 = SettingsViewModel.Advanced.Companion.getAvailableLoggingLevels();
        Level level2 = level;
        String string2 = additionalHeaderValue;
        String string3 = string;
        Boolean bl5 = bl4;
        Boolean bl6 = bl3;
        Boolean bl7 = bl2;
        boolean bl8 = false;
        boolean bl9 = settings2.getInternal().getGateway();
        List<SshExecutable> list6 = bl9 ? list2 : null;
        SshExecutable sshExecutable2 = sshExecutable;
        List<HttpLoggingVerbosity> list7 = list4;
        HttpLoggingVerbosity httpLoggingVerbosity2 = httpLoggingVerbosity;
        GraphicsApi graphicsApi2 = graphicsApi;
        List<Level> list8 = list5;
        Level level3 = level2;
        String string4 = string2;
        String string5 = string3;
        Boolean bl10 = bl5;
        Boolean bl11 = bl6;
        Boolean bl12 = bl7;
        return new SettingsViewState.Advanced(bl12, bl11, bl10, string5, string4, level3, list8, graphicsApi2, httpLoggingVerbosity2, list7, sshExecutable2, list6);
    }

    private static final Unit onSectionExpand$lambda$3(FusEnums.UIGenerator $eventGenerator, FusFieldDescriptions.UISettings $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setAction(FusEnums.UIAction.EXPAND_SECTION);
        $this$logVararg.setGenerator($eventGenerator);
        $this$logVararg.setSection(FusEnums.SelfSettingsSection.ADVANCED);
        return Unit.INSTANCE;
    }

    private static final AdvancedSettings onShowInstalledBuildChange$lambda$4(boolean $value, AdvancedSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AdvancedSettings.copy$default(it, $value, false, false, null, null, null, null, 126, null);
    }

    private static final AdvancedSettings onAllowPatchesChange$lambda$5(boolean $value, AdvancedSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AdvancedSettings.copy$default(it, false, $value, false, null, null, null, null, 125, null);
    }

    private static final AdvancedSettings onSubmitExceptionsAutomaticallyChange$lambda$6(boolean $value, AdvancedSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AdvancedSettings.copy$default(it, false, false, $value, null, null, null, null, 123, null);
    }

    private static final AdvancedSettings onAdditionalHeaderNameChange$lambda$7(String $value, AdvancedSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AdvancedSettings.copy$default(it, false, false, false, null, $value, null, null, 111, null);
    }

    private static final InternalSettings onGraphicsApiChange$lambda$9(GraphicsApi $value, InternalSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return InternalSettings.copy-U8J3xAA$default(it, false, null, null, $value, 0L, 0L, 0L, false, 0L, false, false, false, false, false, false, false, null, 0L, false, 0L, 0L, 0L, 0L, false, false, false, null, 0L, null, null, null, null, false, false, false, false, false, false, false, -9, 127, null);
    }

    private static final AdvancedSettings onLoggingLevelChange$lambda$11(Level $value, AdvancedSettings it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = string = $value.toString();
        SshExecutable sshExecutable = null;
        String string3 = null;
        HttpLoggingVerbosity httpLoggingVerbosity = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        AdvancedSettings advancedSettings = it;
        boolean bl4 = false;
        boolean bl5 = !StringsKt.equals((String)$value.toString(), (String)BuildKt.getDefaultLogLevel(Build.INSTANCE), (boolean)true);
        return AdvancedSettings.copy$default(advancedSettings, bl3, bl2, bl, httpLoggingVerbosity, string3, sshExecutable, bl5 ? string : null, 63, null);
    }

    private static final AdvancedSettings onHttpLoggingVerbosityChange$lambda$12(HttpLoggingVerbosity $value, AdvancedSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AdvancedSettings.copy$default(it, false, false, false, $value, null, null, null, 119, null);
    }

    private static final AdvancedSettings onSshExecutableChange$lambda$13(SshExecutable $value, AdvancedSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AdvancedSettings.copy$default(it, false, false, false, null, null, $value, null, 95, null);
    }

    private static final AdvancedSettings onCustomSshExecutablePathChange$lambda$14(SshExecutableValidator.Result $res, String $value, AdvancedSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AdvancedSettings.copy$default(it, false, false, false, null, null, new SshExecutable(((SshExecutableValidator.Result.Success)$res).getClientType(), ((SshExecutableValidator.Result.Success)$res).getVersion(), $value, $value), null, 95, null);
    }

    public static final /* synthetic */ MutableStateFlow access$getAdditionalHeaderValue$p(LocalAdvancedSettingsViewModel $this) {
        return $this.additionalHeaderValue;
    }

    public static final /* synthetic */ Object access$updateAdditionalHeaderValue(LocalAdvancedSettingsViewModel $this, String value2, Continuation $completion) {
        return $this.updateAdditionalHeaderValue(value2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ SettingsManager access$getSettingsManager$p(LocalAdvancedSettingsViewModel $this) {
        return $this.settingsManager;
    }
}

