/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.settings.local;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.LocalLogCollector;
import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.SnackbarResult;
import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.fus.FusFieldDescriptions;
import com.jetbrains.toolbox.integration.OSIntegrationManager;
import com.jetbrains.toolbox.manager.SnackbarManager;
import com.jetbrains.toolbox.manager.StatisticsManager;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import com.jetbrains.toolbox.viewmodel.settings.AppVersionState;
import com.jetbrains.toolbox.viewmodel.settings.SettingsViewModel;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class LocalAboutToolboxViewModel
implements SettingsViewModel.About {
    @NotNull
    private final StatisticsManager statisticsManager;
    @NotNull
    private final OSIntegrationManager osIntegrationManager;
    @NotNull
    private final LocalLogCollector localLogCollector;
    @NotNull
    private final SnackbarManager snackbarManager;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final AppVersionState state;

    public LocalAboutToolboxViewModel(@NotNull StatisticsManager statisticsManager, @NotNull OSIntegrationManager osIntegrationManager, @NotNull LocalLogCollector localLogCollector, @NotNull SnackbarManager snackbarManager, @NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)statisticsManager, (String)"statisticsManager");
        Intrinsics.checkNotNullParameter((Object)osIntegrationManager, (String)"osIntegrationManager");
        Intrinsics.checkNotNullParameter((Object)localLogCollector, (String)"localLogCollector");
        Intrinsics.checkNotNullParameter((Object)snackbarManager, (String)"snackbarManager");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.statisticsManager = statisticsManager;
        this.osIntegrationManager = osIntegrationManager;
        this.localLogCollector = localLogCollector;
        this.snackbarManager = snackbarManager;
        this.scope = scope2;
        this.state = new AppVersionState(Build.INSTANCE.getBuildNumber-Y_E1uuk(), Build.INSTANCE.getBuildDate(), Build.INSTANCE.getApplicationFullNameVersion() + ", " + OS.INSTANCE.getNameAndVersion() + ", " + OS.INSTANCE.getCpuArch());
    }

    @Override
    @NotNull
    public AppVersionState getState() {
        return this.state;
    }

    @Override
    public void onLinkClick(@NotNull String type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.statisticsManager.getLogger().logVararg(Fus.Counters.UI.INSTANCE.getToolOpenWebsite(), arg_0 -> LocalAboutToolboxViewModel.onLinkClick$lambda$0(type2, arg_0));
    }

    @Override
    public void onShowLogFilesClick() {
        this.statisticsManager.getLogger().logVararg(Fus.Counters.UI.INSTANCE.getSelfSettings(), LocalAboutToolboxViewModel::onShowLogFilesClick$lambda$1);
        this.osIntegrationManager.openLogFile();
    }

    @Override
    @NotNull
    public Job onCollectLogFilesClick() {
        this.statisticsManager.getLogger().logVararg(Fus.Counters.UI.INSTANCE.getSelfSettings(), LocalAboutToolboxViewModel::onCollectLogFilesClick$lambda$2);
        return BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ LocalAboutToolboxViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2;
                        ResultKt.throwOnFailure((Object)$result);
                        Path file = LocalAboutToolboxViewModel.access$getLocalLogCollector$p(this.this$0).collectLocalLogs();
                        if (file != null) {
                            LocalAboutToolboxViewModel.access$getOsIntegrationManager$p(this.this$0).openPath(file);
                            object2 = Unit.INSTANCE;
                            return Unit.INSTANCE;
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)file);
                        this.label = 1;
                        object2 = LocalAboutToolboxViewModel.access$getSnackbarManager$p(this.this$0).showSnackbar(LocalAboutToolboxViewModel.access$getSnackbarManager$p(this.this$0).failedToCollectLogs(), (Continuation<? super SnackbarResult>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Path file = (Path)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    public void onThirdPartyLinkClick() {
        this.statisticsManager.getLogger().log(Fus.Counters.UI.INSTANCE.getThirdPartySoftware(), FusEnums.UIAction.OPEN, FusEnums.UIGenerator.MOUSE);
    }

    private static final Unit onLinkClick$lambda$0(String $type, FusFieldDescriptions.UIToolAction $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setAction(FusEnums.UIAction.OPEN);
        $this$logVararg.setGenerator(FusEnums.UIGenerator.MOUSE);
        $this$logVararg.setTool-sDA0F08(WellKnownApplications.INSTANCE.getToolbox-UtVBrGo());
        $this$logVararg.setLinkType($type);
        return Unit.INSTANCE;
    }

    private static final Unit onShowLogFilesClick$lambda$1(FusFieldDescriptions.UISettings $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setAction(FusEnums.UIAction.LOG);
        $this$logVararg.setGenerator(FusEnums.UIGenerator.MOUSE);
        return Unit.INSTANCE;
    }

    private static final Unit onCollectLogFilesClick$lambda$2(FusFieldDescriptions.UISettings $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setAction(FusEnums.UIAction.LOG);
        $this$logVararg.setGenerator(FusEnums.UIGenerator.MOUSE);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ LocalLogCollector access$getLocalLogCollector$p(LocalAboutToolboxViewModel $this) {
        return $this.localLogCollector;
    }

    public static final /* synthetic */ OSIntegrationManager access$getOsIntegrationManager$p(LocalAboutToolboxViewModel $this) {
        return $this.osIntegrationManager;
    }

    public static final /* synthetic */ SnackbarManager access$getSnackbarManager$p(LocalAboutToolboxViewModel $this) {
        return $this.snackbarManager;
    }
}

