/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.settings;

import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.gateway.MarketplaceInstance;
import com.jetbrains.toolbox.i18n.UILanguage;
import com.jetbrains.toolbox.i18n.UIRegion;
import com.jetbrains.toolbox.openssh.SshExecutable;
import com.jetbrains.toolbox.settings.BackgroundEffects;
import com.jetbrains.toolbox.settings.GraphicsApi;
import com.jetbrains.toolbox.settings.HttpLoggingVerbosity;
import com.jetbrains.toolbox.settings.Theme;
import com.jetbrains.toolbox.settings.ToolFeedSource;
import com.jetbrains.toolbox.viewmodel.settings.AboutEnvironmentState;
import com.jetbrains.toolbox.viewmodel.settings.AppVersionState;
import com.jetbrains.toolbox.viewmodel.settings.SettingsViewState;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.Level;

public interface SettingsViewModel {
    @NotNull
    public StateFlow<SettingsViewState> getState();

    @Nullable
    public About getAbout();

    @Nullable
    public Accounts getAccounts();

    @Nullable
    public Appearance getAppearance();

    @NotNull
    public Tools getTools();

    @NotNull
    public Proxy getProxy();

    @NotNull
    public Advanced getAdvanced();

    @Nullable
    public Internal getInternal();

    public void onTabSwitch(@NotNull FusEnums.UITab var1, @NotNull FusEnums.UIGenerator var2);

    public void onShowLogFilesClick();

    public static interface About {
        @NotNull
        public AppVersionState getState();

        public void onLinkClick(@NotNull String var1);

        public void onShowLogFilesClick();

        @NotNull
        public Job onCollectLogFilesClick();

        public void onThirdPartyLinkClick();
    }

    public static interface AboutEnvironment {
        @NotNull
        public StateFlow<AboutEnvironmentState> getState();
    }

    public static interface Accounts {
        @NotNull
        public StateFlow<SettingsViewState.Accounts> getState();

        @NotNull
        public SharedFlow<Unit> getLoggedInAutomatically();

        @NotNull
        public StateFlow<String> getJbaSignUpUrl();

        public void onCreateAccountClicked();

        public void leaveEnterprise();

        public void login();

        public void logout();

        public void cancelLogin();

        public void startTroubleshooting();

        public void endTroubleshooting();
    }

    public static interface Advanced {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public StateFlow<SettingsViewState.Advanced> getState();

        public void onSectionExpand(@NotNull FusEnums.UIGenerator var1);

        public void onShowInstalledBuildChange(boolean var1);

        public void onAllowPatchesChange(boolean var1);

        public void onSubmitExceptionsAutomaticallyChange(boolean var1);

        public void onAdditionalHeaderNameChange(@NotNull String var1);

        public void onAdditionalHeaderValueChange(@NotNull String var1);

        public void onGraphicsApiChange(@NotNull GraphicsApi var1);

        public void onLoggingLevelChange(@NotNull Level var1);

        public void onHttpLoggingVerbosityChange(@NotNull HttpLoggingVerbosity var1);

        public void onSshExecutableChange(@Nullable SshExecutable var1);

        public boolean onCustomSshExecutablePathChange(@NotNull String var1);

        public void loadAdditionalHeaderOnce();

        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final List<Level> availableLoggingLevels;
            @NotNull
            private static final List<HttpLoggingVerbosity> availableHttpLoggingVerbosity;

            private Companion() {
            }

            @NotNull
            public final List<Level> getAvailableLoggingLevels() {
                return availableLoggingLevels;
            }

            @NotNull
            public final List<HttpLoggingVerbosity> getAvailableHttpLoggingVerbosity() {
                return availableHttpLoggingVerbosity;
            }

            static {
                $$INSTANCE = new Companion();
                Object[] objectArray = new Level[]{Level.OFF, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE};
                availableLoggingLevels = CollectionsKt.listOf((Object[])objectArray);
                objectArray = new HttpLoggingVerbosity[]{HttpLoggingVerbosity.None, HttpLoggingVerbosity.Basic, HttpLoggingVerbosity.Headers};
                availableHttpLoggingVerbosity = CollectionsKt.listOf((Object[])objectArray);
            }
        }
    }

    public static interface Appearance {
        @NotNull
        public StateFlow<SettingsViewState.Appearance> getState();

        public void onLanguageChange(@NotNull UILanguage var1);

        public void onRegionChange(@NotNull UIRegion var1);

        public void onThemeChange(@NotNull Theme var1);

        public void onBackgroundEffectsChange(@NotNull BackgroundEffects var1);

        public void onAutostartChange(boolean var1);

        public void onStartMenuShortcutChange(boolean var1);

        public void onUpdateAppAutomaticallyChange(boolean var1);

        public void onAnonymousStatisticsChange(boolean var1);

        public void onHotkeyValueChanged(@NotNull String var1);

        public void onScaleChange(float var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static interface Internal {
        @NotNull
        public StateFlow<SettingsViewState.Internal> getState();

        public void onToolFeedSourceChange(@NotNull ToolFeedSource var1);

        public void onToolFeedPathChange(@NotNull String var1);

        public void onToolFeedUrlChange(@NotNull String var1);

        public void onPluginsSourceChange(@NotNull MarketplaceInstance var1);

        public void onSectionExpand(@NotNull FusEnums.UIGenerator var1);

        public void onAnimatedBorderStyleChange(boolean var1);

        public void onWelcomeChange(boolean var1);

        public void onShowHiddenToolsChange(boolean var1);

        public void onGatewayIntegrationChange(boolean var1);

        public void onDevcontainersIntegrationChange(boolean var1);

        public void onAiChatChange(boolean var1);

        public void onMcpHubChange(boolean var1);

        public void onBrowserIntegrationChange(boolean var1);

        public void onShowBandwidthUsageChange(boolean var1);

        public void onLogTransportMetricsChange(boolean var1);

        public void onMultiWindowModeChange(boolean var1);

        public void onAdvancedIDEDirectoryManagementChange(boolean var1);

        public void onEnableLicenseUIChange(boolean var1);

        public void onEnableInstantUpdate(boolean var1);

        public void onUseModernClientConnectionFlowChange(boolean var1);

        public void onAiChatHotkeyChange(@NotNull String var1);

        public void onFrameFreezeDetectChange(boolean var1);

        public void onAdditionalLatencyChange-LRDsOJo(long var1);

        public void throwException();

        public void showUnsentStatistics();

        public void forceSubmitStatistics();

        public void onNewEnvironmentFormBusyExtensionTimeChange-LRDsOJo(long var1);

        public void onEnableJbidesRdIntegration(boolean var1);

        public void onDetectToolsFreezesChange(boolean var1);
    }

    public static interface Proxy {
        @NotNull
        public StateFlow<SettingsViewState.Proxy> getState();

        public void onSectionExpand(@NotNull FusEnums.UIGenerator var1);

        public void onProxyTypeChange(@NotNull SettingsViewState.Proxy.Type var1);

        public void onConfigurationUrlChange(@NotNull String var1);

        public void onHostChange(@NotNull String var1);

        public void onPortChange(@NotNull String var1);

        public void onUsernameChange(@NotNull String var1);

        public void onPasswordChange(@NotNull String var1);

        public void openSystemProxySettings();

        public void loadPasswordOnce();

        @Nullable
        public <T> Object testConnection(@NotNull Function1<? super Continuation<? super T>, ? extends Object> var1, @NotNull Continuation<? super T> var2);

        public static interface Transactional
        extends Proxy {
            public void save(boolean var1);

            public static /* synthetic */ void save$default(Transactional transactional, boolean bl, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: save");
                }
                if ((n & 1) != 0) {
                    bl = true;
                }
                transactional.save(bl);
            }

            public void reset();
        }
    }

    public static interface Tools {
        @NotNull
        public StateFlow<SettingsViewState.Tools> getState();

        public void navigateToLeftoverIDEDirectories();

        public void navigateToFrontendToolsCleanup();

        public void onSectionExpand(@NotNull FusEnums.UIGenerator var1);

        public void onUpdateAllAutomaticallyChange(boolean var1);

        public void onCreateStartMenuShortcutsChange(boolean var1);

        public void onCreateFileAssociationChange(boolean var1);

        public void onGenerateShellScriptsChange(boolean var1);

        public void onInstantRollbackChange(boolean var1);

        @NotNull
        public String onInstallLocationChange(@NotNull String var1);

        @NotNull
        public String onShellLaunchersLocationChange(@NotNull String var1);

        @Nullable
        public String validateInstallLocation(@NotNull String var1);

        @Nullable
        public String validateShellScriptsLocation(@NotNull String var1);

        public void cleanBackups();

        public void cleanDownloadCache();
    }
}

