/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.settings;

import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AppVersionState {
    @NotNull
    private final String buildNumber;
    @NotNull
    private final Instant buildDate;
    @NotNull
    private final String buildTextToCopy;

    public AppVersionState(@NotNull String buildNumber, @NotNull Instant buildDate, @NotNull String buildTextToCopy) {
        Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
        Intrinsics.checkNotNullParameter((Object)buildDate, (String)"buildDate");
        Intrinsics.checkNotNullParameter((Object)buildTextToCopy, (String)"buildTextToCopy");
        this.buildNumber = buildNumber;
        this.buildDate = buildDate;
        this.buildTextToCopy = buildTextToCopy;
    }

    @NotNull
    public final String getBuildNumber() {
        return this.buildNumber;
    }

    @NotNull
    public final Instant getBuildDate() {
        return this.buildDate;
    }

    @NotNull
    public final String getBuildTextToCopy() {
        return this.buildTextToCopy;
    }

    @NotNull
    public String toString() {
        return "AppVersionState(buildNumber=" + this.buildNumber + ", buildDate=" + this.buildDate + ", buildTextToCopy=" + this.buildTextToCopy + ")";
    }

    public int hashCode() {
        int result2 = this.buildNumber.hashCode();
        result2 = result2 * 31 + this.buildDate.hashCode();
        result2 = result2 * 31 + this.buildTextToCopy.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AppVersionState)) {
            return false;
        }
        AppVersionState appVersionState = (AppVersionState)other;
        if (!Intrinsics.areEqual((Object)this.buildNumber, (Object)appVersionState.buildNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildDate, (Object)appVersionState.buildDate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.buildTextToCopy, (Object)appVersionState.buildTextToCopy);
    }
}

