/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.selfUpdate.local;

import com.jetbrains.toolbox.AppRestartInhibitor;
import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.common.coroutines.flow.DerivedStateFlow;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.feed.ApplicationQuality;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.DataPiecesKt;
import com.jetbrains.toolbox.feed.WhatsNew;
import com.jetbrains.toolbox.i18n.LocalizableStringEx;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.integration.OSIntegrationManager;
import com.jetbrains.toolbox.manager.NotificationManager;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.settings.UpdateSettings;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import com.jetbrains.toolbox.tools.WellKnownChannelId;
import com.jetbrains.toolbox.tools.model.AvailableBuild;
import com.jetbrains.toolbox.tools.model.AvailableTools;
import com.jetbrains.toolbox.tools.model.ChangeOptions;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.ToolUpdate;
import com.jetbrains.toolbox.tools.model.ToolWithVersions;
import com.jetbrains.toolbox.tools.model.UpdateFilter;
import com.jetbrains.toolbox.tools.model.VersionWithBuilds;
import com.jetbrains.toolbox.viewmodel.selfUpdate.SelfUpdateViewModel;
import com.jetbrains.toolbox.viewmodel.selfUpdate.SelfUpdateViewState;
import com.jetbrains.toolbox.viewmodel.tools.InstalledToolSettingsViewState;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nLocalSelfUpdateViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalSelfUpdateViewModel.kt\ncom/jetbrains/toolbox/viewmodel/selfUpdate/local/LocalSelfUpdateViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1374#2:187\n1460#2,5:188\n295#2,2:193\n1563#2:195\n1634#2,3:196\n1056#2:199\n1563#2:200\n1634#2,3:201\n1788#2,4:204\n808#2,11:208\n1563#2:219\n1634#2,3:220\n*S KotlinDebug\n*F\n+ 1 LocalSelfUpdateViewModel.kt\ncom/jetbrains/toolbox/viewmodel/selfUpdate/local/LocalSelfUpdateViewModel\n*L\n127#1:187\n127#1:188,5\n127#1:193,2\n57#1:195\n57#1:196,3\n59#1:199\n60#1:200\n60#1:201,3\n71#1:204,4\n72#1:208,11\n72#1:219\n72#1:220,3\n*E\n"})
public final class LocalSelfUpdateViewModel
implements SelfUpdateViewModel {
    @NotNull
    private final ToolManager toolManager;
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final StateFlow<AvailableTools> availableTools;
    @NotNull
    private final NotificationManager notificationManager;
    @NotNull
    private final OSIntegrationManager osIntegrationManager;
    @NotNull
    private final StateFlow<SelfUpdateViewState> state;

    public LocalSelfUpdateViewModel(@NotNull ToolManager toolManager, @NotNull SettingsManager settingsManager, @NotNull AppRestartInhibitor restartInhibitor, @NotNull StateFlow<AvailableTools> availableTools2, @NotNull NotificationManager notificationManager, @NotNull OSIntegrationManager osIntegrationManager) {
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)restartInhibitor, (String)"restartInhibitor");
        Intrinsics.checkNotNullParameter(availableTools2, (String)"availableTools");
        Intrinsics.checkNotNullParameter((Object)notificationManager, (String)"notificationManager");
        Intrinsics.checkNotNullParameter((Object)osIntegrationManager, (String)"osIntegrationManager");
        this.toolManager = toolManager;
        this.settingsManager = settingsManager;
        this.availableTools = availableTools2;
        this.notificationManager = notificationManager;
        this.osIntegrationManager = osIntegrationManager;
        this.state = FlowExtensionsKt.combineStates(this.toolManager.getModel(), this.settingsManager.getSettings(), this.availableTools, restartInhibitor.getRestartBlockedBy(), LocalSelfUpdateViewModel::state$lambda$6);
    }

    @Override
    @NotNull
    public StateFlow<SelfUpdateViewState> getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public WhatsNew getWhatsNewInCurrentBuild() {
        Object v3;
        Object object;
        block2: {
            void $this$flatMapTo$iv$iv;
            ToolWithVersions toolWithVersions = ((AvailableTools)this.availableTools.getValue()).getTools().get(ApplicationType.box-impl(WellKnownApplications.INSTANCE.getToolbox-UtVBrGo()));
            object = toolWithVersions;
            if (toolWithVersions == null) return null;
            List<VersionWithBuilds> list2 = ((ToolWithVersions)object).getVersions();
            object = list2;
            if (list2 == null) return null;
            Iterable $this$flatMap$iv = (Iterable)object;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                VersionWithBuilds it = (VersionWithBuilds)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getBuilds();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AvailableBuild it = (AvailableBuild)element$iv;
                boolean bl = false;
                if (!BuildNumber.equals-impl0(it.getId-Y_E1uuk(), Build.INSTANCE.getBuildNumber-Y_E1uuk())) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        AvailableBuild availableBuild = v3;
        object = availableBuild;
        if (availableBuild == null) return null;
        WhatsNew whatsNew2 = ((AvailableBuild)object).getWhatsNew();
        return whatsNew2;
    }

    @Override
    @NotNull
    public SelfUpdateViewModel.UpdateResult update(boolean force) {
        SelfUpdateViewModel.UpdateResult updateResult;
        SelfUpdateViewState state2 = (SelfUpdateViewState)this.getState().getValue();
        if (!state2.getUpdateAvailable()) {
            updateResult = SelfUpdateViewModel.UpdateResult.NoUpdateAvailable;
        } else if (state2.getUpdateRunning()) {
            updateResult = SelfUpdateViewModel.UpdateResult.AlreadyRunning;
        } else if (!state2.getUpdateDownloaded()) {
            updateResult = this.update();
        } else if (force) {
            updateResult = this.update();
        } else if (state2.getActiveConnectionsCount() > 0 || state2.getNonIdleToolsCount() > 0) {
            if (state2.getNonIdleToolsCount() > 0) {
                String tools2 = CollectionsKt.joinToString$default((Iterable)state2.getNonIdleTools(), null, null, null, (int)0, null, (Function1)((Function1)new Function1<ChannelId, CharSequence>(this){
                    final /* synthetic */ LocalSelfUpdateViewModel this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final CharSequence invoke-CH08qv8(String it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return ChannelId.toString-impl(it) + ":" + ((object = LocalSelfUpdateViewModel.access$getToolManager$p(this.this$0).getChannelState().get(ChannelId.box-impl(it))) != null && (object = (ChannelState)object.getValue()) != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : null);
                    }
                }), (int)31, null);
                Logger.INSTANCE.info("Tools preventing Toolbox from the update: " + tools2);
            }
            updateResult = SelfUpdateViewModel.UpdateResult.HasBlockers;
        } else {
            updateResult = this.update();
        }
        return updateResult;
    }

    /*
     * WARNING - void declaration
     */
    private final SelfUpdateViewModel.UpdateResult update() {
        block2: {
            Object object;
            NotificationManager notificationManager;
            block4: {
                block3: {
                    void path2;
                    this.notificationManager.clearSelfUpdateFailNotification();
                    if (!((SelfUpdateViewState)this.getState().getValue()).getDirectoryIsNotWritable()) break block2;
                    notificationManager = this.notificationManager;
                    object = this.osIntegrationManager.getInstallationPath().parent();
                    if (object == null) break block3;
                    Path path3 = object;
                    NotificationManager notificationManager2 = notificationManager;
                    boolean bl = false;
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"path", (Object)path2.toString())};
                    LocalizableStringEx localizableStringEx = LocalizableStringExKt.trl("Cannot install the update. The Toolbox App is installed in a directory {{path}} that cannot be modified. Please reinstall it to a user-writable location to enable updates.", pairArray);
                    notificationManager = notificationManager2;
                    object = localizableStringEx;
                    if (localizableStringEx != null) break block4;
                }
                object = LocalizableStringExKt.trl("Cannot install the update. The Toolbox App is installed in a directory that cannot be modified. Please reinstall it to a user-writable location to enable updates.");
            }
            notificationManager.showSelfUpdateFailNotification((LocalizableString)object, new URL("https://www.jetbrains.com/help/toolbox-app/toolbox-app-silent-installation.html#tba_installation"));
        }
        this.toolManager.update-CH08qv8(WellKnownChannelId.INSTANCE.getToolbox-5CZByfs());
        return SelfUpdateViewModel.UpdateResult.Started;
    }

    @Override
    public void changeUpdateTo(@NotNull InstalledToolSettingsViewState.UpdateOption option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        this.settingsManager.updateSettings((Function1<? super SelfSettings, SelfSettings>)((Function1)arg_0 -> LocalSelfUpdateViewModel.changeUpdateTo$lambda$10(option, arg_0)));
    }

    private static final float state$lambda$6$lambda$5(ChannelState $channelState) {
        return ((Number)((ChannelState.Downloading)$channelState).getProgress().getValue().getValue()).floatValue();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final SelfUpdateViewState state$lambda$6(Map tools2, SelfSettings settings2, AvailableTools available2, Set restartBlockedBy) {
        SelfUpdateViewState selfUpdateViewState;
        ToolBuild update2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        int n;
        List list2;
        Object destination$iv$iv;
        Object object;
        Object object2;
        int selectedUpdateToOption;
        boolean directoryIsNotWritable;
        ToolUpdate availableUpdate;
        ChannelState channelState;
        block11: {
            Iterator iterator2;
            block10: {
                block9: {
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    void $this$sortedBy$iv;
                    Iterable $this$mapTo$iv$iv3;
                    List $this$map$iv3;
                    List<VersionWithBuilds> list3;
                    Intrinsics.checkNotNullParameter((Object)tools2, (String)"tools");
                    Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
                    Intrinsics.checkNotNullParameter((Object)available2, (String)"available");
                    Intrinsics.checkNotNullParameter((Object)restartBlockedBy, (String)"restartBlockedBy");
                    channelState = (ChannelState)tools2.get(ChannelId.box-impl(WellKnownChannelId.INSTANCE.getToolbox-5CZByfs()));
                    Object object3 = channelState;
                    availableUpdate = object3 != null && (object3 = object3.getChangeOptions()) != null ? ((ChangeOptions)object3).getUpdate() : null;
                    Object object4 = channelState;
                    directoryIsNotWritable = (object4 != null && (object4 = object4.getChangeOptions()) != null ? ((ChangeOptions)object4).getStatus() : null) == ChangeOptions.Status.DirectoryIsNotWritable;
                    selectedUpdateToOption = settings2.getUpdate().getFilter().getQuality().getOrder();
                    ToolWithVersions toolWithVersions = available2.getTools().get(ApplicationType.box-impl(WellKnownApplications.INSTANCE.getToolbox-UtVBrGo()));
                    if (toolWithVersions == null || (list3 = toolWithVersions.getVersions()) == null) break block9;
                    Iterable iterable = list3;
                    boolean $i$f$map22 = false;
                    void var14_19 = $this$map$iv3;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        void it;
                        VersionWithBuilds versionWithBuilds = (VersionWithBuilds)item$iv$iv;
                        object2 = destination$iv$iv2;
                        boolean bl = false;
                        object2.add(it.getVersion().getQuality());
                    }
                    $this$map$iv3 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
                    if ($this$map$iv3 == null) break block9;
                    $this$mapTo$iv$iv3 = $this$map$iv3;
                    boolean $i$f$sortedBy22 = false;
                    List $i$f$map22 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            ApplicationQuality it = (ApplicationQuality)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(it.getOrder());
                            it = (ApplicationQuality)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOrder()));
                        }
                    });
                    if ($i$f$map22 == null) break block9;
                    Iterable $i$f$sortedBy22 = $i$f$map22;
                    boolean $i$f$map = false;
                    object = $this$map$iv2;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    iterator2 = $this$mapTo$iv$iv2.iterator();
                    break block10;
                }
                list2 = CollectionsKt.emptyList();
                break block11;
            }
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                ApplicationQuality applicationQuality = (ApplicationQuality)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object2.add(new InstalledToolSettingsViewState.UpdateOption(it.getOrder(), it.getName(), it.getDescription(), it.getOrder() == DataPiecesKt.getDevToolboxQuality().getOrder(), it.getAvoidBetterQualities()));
            }
            list2 = (List)destination$iv$iv;
        }
        List updateToOptions = list2;
        Iterable $this$count$iv = restartBlockedBy;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                AppRestartInhibitor.BlockOwner it = (AppRestartInhibitor.BlockOwner)element$iv;
                boolean bl = false;
                if (!(it instanceof AppRestartInhibitor.BlockOwner.ActiveConnection) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int activeConnectionsCount = n;
        Iterable $this$filterIsInstance$iv = restartBlockedBy;
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$map22 = $this$filterIsInstance$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AppRestartInhibitor.BlockOwner.UpdatingTool)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv3;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            destination$iv$iv = (AppRestartInhibitor.BlockOwner.UpdatingTool)item$iv$iv;
            object2 = destination$iv$iv3;
            boolean bl = false;
            object2.add(ChannelId.box-impl(it.getOwner-5CZByfs()));
        }
        List nonIdleTools = (List)destination$iv$iv3;
        ChannelState.HasTargetBuild hasTargetBuild = channelState instanceof ChannelState.HasTargetBuild ? (ChannelState.HasTargetBuild)channelState : null;
        ToolBuild installingBuild = hasTargetBuild != null ? hasTargetBuild.getBuild() : null;
        ToolBuild toolBuild = installingBuild;
        if (toolBuild == null) {
            ToolUpdate toolUpdate = availableUpdate;
            toolBuild = toolUpdate != null ? toolUpdate.getBuild() : null;
        }
        if ((update2 = toolBuild) == null) {
            selfUpdateViewState = new SelfUpdateViewState(false, false, null, false, directoryIsNotWritable, "", "", null, updateToOptions, selectedUpdateToOption, activeConnectionsCount, nonIdleTools);
            return selfUpdateViewState;
        }
        String version = update2.getVersion().getName();
        ChannelState channelState2 = channelState;
        StateFlow downloadingProgressFlow = channelState2 instanceof ChannelState.Downloading ? (StateFlow)new DerivedStateFlow(() -> LocalSelfUpdateViewModel.state$lambda$6$lambda$5(channelState), FlowKt.sample((Flow)((Flow)((ChannelState.Downloading)channelState).getProgress().getValue()), (long)1000L)) : (channelState2 instanceof ChannelState.Verifying || channelState2 instanceof ChannelState.Unpacking ? (StateFlow)StateFlowKt.MutableStateFlow((Object)Float.valueOf(1.0f)) : null);
        boolean bl = !(channelState instanceof ChannelState.Idle) && !(channelState instanceof ChannelState.Refreshing) && !(channelState instanceof ChannelState.SelfUpdatePending);
        boolean bl2 = channelState instanceof ChannelState.SelfUpdatePending;
        object = "Toolbox App " + version;
        WhatsNew whatsNew2 = update2.getBuild().getWhatsNew();
        selfUpdateViewState = new SelfUpdateViewState(bl, true, (StateFlow<Float>)downloadingProgressFlow, bl2, directoryIsNotWritable, version, (String)object, whatsNew2, updateToOptions, selectedUpdateToOption, activeConnectionsCount, nonIdleTools);
        return selfUpdateViewState;
    }

    private static final SelfSettings changeUpdateTo$lambda$10(InstalledToolSettingsViewState.UpdateOption $option, SelfSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SelfSettings.copy$default(it, null, null, false, false, null, 0, null, null, null, null, null, null, null, null, UpdateSettings.copy$default(it.getUpdate(), UpdateFilter.copy-6hF8Tw4$default(it.getUpdate().getFilter(), null, new ApplicationQuality($option.getDescription(), $option.getText(), $option.getOrder(), $option.getAvoidBetterQualities()), null, null, null, 29, null), false, 2, null), null, null, 114687, null);
    }

    public static final /* synthetic */ ToolManager access$getToolManager$p(LocalSelfUpdateViewModel $this) {
        return $this.toolManager;
    }
}

