/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.views;

import com.jetbrains.toolbox.viewmodel.ProviderSelectorViewState;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Providers {
    @NotNull
    private final List<ProviderSelectorViewState> bundledProviders;
    @NotNull
    private final List<ProviderSelectorViewState> externalProviders;
    @NotNull
    private final List<ProviderSelectorViewState> allProviders;

    public Providers(@NotNull List<ProviderSelectorViewState> bundledProviders, @NotNull List<ProviderSelectorViewState> externalProviders) {
        Intrinsics.checkNotNullParameter(bundledProviders, (String)"bundledProviders");
        Intrinsics.checkNotNullParameter(externalProviders, (String)"externalProviders");
        this.bundledProviders = bundledProviders;
        this.externalProviders = externalProviders;
        this.allProviders = CollectionsKt.plus((Collection)this.bundledProviders, (Iterable)this.externalProviders);
    }

    @NotNull
    public final List<ProviderSelectorViewState> getBundledProviders() {
        return this.bundledProviders;
    }

    @NotNull
    public final List<ProviderSelectorViewState> getExternalProviders() {
        return this.externalProviders;
    }

    @NotNull
    public final List<ProviderSelectorViewState> getAllProviders() {
        return this.allProviders;
    }

    @NotNull
    public String toString() {
        return "Providers(bundledProviders=" + this.bundledProviders + ", externalProviders=" + this.externalProviders + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.bundledProviders).hashCode();
        result2 = result2 * 31 + ((Object)this.externalProviders).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Providers)) {
            return false;
        }
        Providers providers = (Providers)other;
        if (!Intrinsics.areEqual(this.bundledProviders, providers.bundledProviders)) {
            return false;
        }
        return Intrinsics.areEqual(this.externalProviders, providers.externalProviders);
    }
}

