/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.rhizome;

import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.EntityType;
import com.jetbrains.rhizomedb.Indexing;
import com.jetbrains.rhizomedb.Mixin;
import com.jetbrains.toolbox.common.code.Languages;
import com.jetbrains.toolbox.common.mime.MediaType;
import com.jetbrains.toolbox.common.mime.MediaTypes;
import com.jetbrains.toolbox.platform.image.ImageKey;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MediaTypeIconEntity
implements Entity {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private final int eid;
    public static final int $stable;
    @NotNull
    private static final Attributes.Required<MediaType> MediaTypeAttr;
    @NotNull
    private static final Attributes.Required<String> MediaSubTypeAttr;
    @NotNull
    private static final Attributes.Required<String> MediaPresentationAttr;
    @NotNull
    private static final Attributes.Optional<ImageKey> IconKeyAttr;
    @NotNull
    private static final Map<String, MediaType> languageToMediaType;

    public MediaTypeIconEntity(int eid2) {
        this.eid = eid2;
    }

    @Override
    public int getEid() {
        return this.eid;
    }

    @Nullable
    public final ImageKey getIconKey() {
        return IconKeyAttr.getValue((Entity)this, $$delegatedProperties[1]);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MediaTypeIconEntity.class, "mediaType", "getMediaType()Lcom/jetbrains/toolbox/common/mime/MediaType;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MediaTypeIconEntity.class, "iconKey", "getIconKey()Lcom/jetbrains/toolbox/platform/image/ImageKey;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        $stable = 8;
        MediaTypeAttr = Attributes.requiredTransient$default(Companion, "mediaType", Indexing.UNIQUE, null, 4, null);
        MediaSubTypeAttr = Attributes.requiredTransient$default(Companion, "mediaSubType", Indexing.INDEXED, null, 4, null);
        MediaPresentationAttr = Attributes.requiredTransient$default(Companion, "mediaPresentation", Indexing.INDEXED, null, 4, null);
        IconKeyAttr = Attributes.optionalTransient$default(Companion, "iconKey", null, null, 6, null);
        kPropertyArray = new Pair[]{TuplesKt.to((Object)Languages.INSTANCE.getBatch().getName(), (Object)MediaTypes.Application.INSTANCE.getBAT()), TuplesKt.to((Object)Languages.INSTANCE.getDockerfile().getName(), (Object)MediaTypes.Text.INSTANCE.getDOCKER()), TuplesKt.to((Object)Languages.INSTANCE.getMarkdown().getName(), (Object)MediaTypes.Text.INSTANCE.getMARKDOWN()), TuplesKt.to((Object)Languages.INSTANCE.getObjectiveC().getName(), (Object)MediaTypes.Text.INSTANCE.getOBJC()), TuplesKt.to((Object)Languages.INSTANCE.getRuby().getName(), (Object)MediaTypes.Text.INSTANCE.getRUBY())};
        languageToMediaType = MapsKt.hashMapOf((Pair[])kPropertyArray);
    }

    public static final class Companion
    extends EntityType<MediaTypeIconEntity> {
        private Companion() {
            super(Reflection.getOrCreateKotlinClass(MediaTypeIconEntity.class), 1.INSTANCE, new Mixin[0]);
        }

        @Nullable
        public final ImageKey findIcon(@NotNull String key2) {
            MediaTypeIconEntity mediaTypeIconEntity;
            Object correctedKey;
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Object object = (MediaType)languageToMediaType.get(key2);
            if (object == null || (object = ((MediaType)object).getSubType()) == null) {
                object = correctedKey = key2;
            }
            if ((mediaTypeIconEntity = (MediaTypeIconEntity)CollectionsKt.firstOrNull((Iterable)EntityAttributeKt.entities(MediaPresentationAttr, correctedKey))) == null || (mediaTypeIconEntity = mediaTypeIconEntity.getIconKey()) == null) {
                MediaTypeIconEntity mediaTypeIconEntity2 = (MediaTypeIconEntity)CollectionsKt.firstOrNull((Iterable)EntityAttributeKt.entities(MediaSubTypeAttr, correctedKey));
                mediaTypeIconEntity = mediaTypeIconEntity2 != null ? mediaTypeIconEntity2.getIconKey() : null;
            }
            return mediaTypeIconEntity;
        }

        public final void registerMediaTypeIcon(@NotNull ChangeScope changeScope, @NotNull MediaType mediaType, @Nullable ImageKey icon2) {
            Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
            Companion.new(changeScope, arg_0 -> Companion.registerMediaTypeIcon$lambda$0(mediaType, icon2, arg_0));
        }

        private static final void registerMediaTypeIcon$lambda$0(MediaType $mediaType, ImageKey $icon, EntityBuilder.Target it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.set(MediaTypeAttr, $mediaType);
            it.set(MediaSubTypeAttr, $mediaType.getSubType());
            it.set(MediaPresentationAttr, $mediaType.presentation());
            it.set(IconKeyAttr, $icon);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

