/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.navigation.route;

import com.jetbrains.toolbox.i18n.dto.LocalizableStringDtoKt;
import com.jetbrains.toolbox.settings.ApplicationState;
import com.jetbrains.toolbox.settings.ApplicationStateManager;
import com.jetbrains.toolbox.ui.navigation.Screen;
import com.jetbrains.toolbox.ui.navigation.ScreenWithTitle;
import com.jetbrains.toolbox.ui.navigation.route.ScreenSerializer;
import com.jetbrains.toolbox.ui.window.WindowID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nNavigationStackStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigationStackStorage.kt\ncom/jetbrains/toolbox/ui/navigation/route/NavigationStackStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1617#2,9:40\n1869#2:49\n1870#2:51\n1626#2:52\n1617#2,9:53\n1869#2:62\n1870#2:64\n1626#2:65\n1#3:50\n1#3:63\n*S KotlinDebug\n*F\n+ 1 NavigationStackStorage.kt\ncom/jetbrains/toolbox/ui/navigation/route/NavigationStackStorage\n*L\n15#1:40,9\n15#1:49\n15#1:51\n15#1:52\n29#1:53,9\n29#1:62\n29#1:64\n29#1:65\n15#1:50\n29#1:63\n*E\n"})
public final class NavigationStackStorage {
    @NotNull
    private final ApplicationStateManager stateManager;
    @NotNull
    private final ScreenSerializer screenSerializer;
    public static final int $stable = 8;

    public NavigationStackStorage(@NotNull ApplicationStateManager stateManager, @NotNull ScreenSerializer screenSerializer) {
        Intrinsics.checkNotNullParameter((Object)stateManager, (String)"stateManager");
        Intrinsics.checkNotNullParameter((Object)screenSerializer, (String)"screenSerializer");
        this.stateManager = stateManager;
        this.screenSerializer = screenSerializer;
    }

    /*
     * WARNING - void declaration
     */
    public final void store(@NotNull WindowID id, @NotNull List<ScreenWithTitle> stack) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        Iterable iterable = stack;
        String string = id.getName();
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ApplicationState.Screen it$iv$iv;
            String url;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ScreenWithTitle it = (ScreenWithTitle)element$iv$iv;
            boolean bl2 = false;
            if ((this.screenSerializer.serialize(it.getScreen()) == null ? null : new ApplicationState.Screen(url, LocalizableStringDtoKt.toDto(it.getTitle()))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Pair newState = TuplesKt.to((Object)string, (Object)((List)destination$iv$iv));
        this.stateManager.updateState((Function1<? super ApplicationState, ApplicationState>)((Function1)arg_0 -> NavigationStackStorage.store$lambda$1(newState, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<ScreenWithTitle> restore(@NotNull WindowID id) {
        List list2;
        List<ApplicationState.Screen> stack;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List<ApplicationState.Screen> list3 = stack = ((ApplicationState)this.stateManager.getState().getValue()).getNavigationStacks().get(id.getName());
        if (list3 != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list3;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ScreenWithTitle screenWithTitle;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ApplicationState.Screen it = (ApplicationState.Screen)element$iv$iv;
                boolean bl2 = false;
                if (this.screenSerializer.deserialize(it.getUrl()) != null) {
                    Screen screen;
                    boolean bl3 = false;
                    screenWithTitle = new ScreenWithTitle(screen, LocalizableStringDtoKt.toLocalizableString(it.getTitle()));
                } else {
                    screenWithTitle = null;
                }
                if (screenWithTitle == null) continue;
                ScreenWithTitle it$iv$iv = screenWithTitle;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    private static final ApplicationState store$lambda$1(Pair $newState, ApplicationState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.copy(MapsKt.plus(it.getNavigationStacks(), (Pair)$newState));
    }
}

