/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.components.gateway;

import com.jetbrains.toolbox.ui.components.gateway.ComboboxItem;
import com.jetbrains.toolbox.ui.components.gateway.Divider;
import com.jetbrains.toolbox.ui.components.gateway.SelectableComboboxItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nCombobox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Combobox.kt\ncom/jetbrains/toolbox/ui/components/gateway/AutocompleteProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,705:1\n808#2,11:706\n808#2,11:717\n808#2,11:728\n808#2,11:739\n774#2:750\n865#2,2:751\n*S KotlinDebug\n*F\n+ 1 Combobox.kt\ncom/jetbrains/toolbox/ui/components/gateway/AutocompleteProvider\n*L\n609#1:706,11\n610#1:717,11\n620#1:728,11\n621#1:739,11\n632#1:750\n632#1:751,2\n*E\n"})
final class AutocompleteProvider {
    @NotNull
    private List<ComboboxItem.Value> values;
    @NotNull
    private List<ComboboxItem.Action> actions;
    @NotNull
    private String currentFilter;
    @NotNull
    private final MutableStateFlow<Suggestions> _suggestions;
    @NotNull
    private final StateFlow<Suggestions> suggestions;

    public AutocompleteProvider(@NotNull List<? extends ComboboxItem> items2, @NotNull String filter2) {
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Iterable iterable = items2;
        AutocompleteProvider autocompleteProvider = this;
        boolean $i$f$filterIsInstance = false;
        void var5_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ComboboxItem.Value)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        autocompleteProvider.values = (List)destination$iv$iv;
        $this$filterIsInstance$iv = items2;
        autocompleteProvider = this;
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ComboboxItem.Action)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        autocompleteProvider.actions = (List)destination$iv$iv;
        this.currentFilter = filter2;
        this._suggestions = StateFlowKt.MutableStateFlow((Object)this.getSuggestions(filter2));
        this.suggestions = FlowKt.asStateFlow(this._suggestions);
    }

    @NotNull
    public final StateFlow<Suggestions> getSuggestions() {
        return this.suggestions;
    }

    public final boolean getAny() {
        return ((Suggestions)this._suggestions.getValue()).getAny();
    }

    public final void updateItems(@NotNull List<? extends ComboboxItem> newItems) {
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter(newItems, (String)"newItems");
        Iterable iterable = newItems;
        AutocompleteProvider autocompleteProvider = this;
        boolean $i$f$filterIsInstance = false;
        void var4_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ComboboxItem.Value)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        autocompleteProvider.values = (List)destination$iv$iv;
        $this$filterIsInstance$iv = newItems;
        autocompleteProvider = this;
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ComboboxItem.Action)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        autocompleteProvider.actions = (List)destination$iv$iv;
        this._suggestions.setValue((Object)this.getSuggestions(this.currentFilter));
    }

    public final void applyFilter(@NotNull String filter2) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        this.currentFilter = filter2;
        this._suggestions.setValue((Object)this.getSuggestions(filter2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Suggestions getSuggestions(@NotNull String filter2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Iterable $this$filter$iv = this.values;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ComboboxItem.Value it = (ComboboxItem.Value)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)filter2).length() == 0 || it.matches(filter2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredValues = (List)destination$iv$iv;
        List filteredItems = new ArrayList();
        ComboboxItem.Group lastGroup = null;
        for (ComboboxItem.Value value2 : filteredValues) {
            if (!Intrinsics.areEqual((Object)value2.getGroup(), lastGroup)) {
                if (!((Collection)filteredItems).isEmpty()) {
                    filteredItems.add(new Divider("before " + value2.getGroup()));
                }
                if (value2.getGroup() != null) {
                    filteredItems.add(value2.getGroup());
                }
            }
            filteredItems.add(value2);
            lastGroup = value2.getGroup();
        }
        if (!((Collection)filteredItems).isEmpty() && !((Collection)this.actions).isEmpty()) {
            filteredItems.add(new Divider("after values"));
            filteredItems.addAll((Collection)this.actions);
        }
        return new Suggestions(CollectionsKt.toList((Iterable)filteredItems));
    }

    @SourceDebugExtension(value={"SMAP\nCombobox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Combobox.kt\ncom/jetbrains/toolbox/ui/components/gateway/AutocompleteProvider$Suggestions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,705:1\n774#2:706\n865#2,2:707\n1#3:709\n*S KotlinDebug\n*F\n+ 1 Combobox.kt\ncom/jetbrains/toolbox/ui/components/gateway/AutocompleteProvider$Suggestions\n*L\n661#1:706\n661#1:707,2\n*E\n"})
    public static final class Suggestions {
        @NotNull
        private final List<ComboboxItem> list;
        private final boolean any;
        @NotNull
        private final List<Integer> selectableItemIndices;
        public static final int $stable = 8;

        /*
         * WARNING - void declaration
         */
        public Suggestions(@NotNull List<? extends ComboboxItem> list2) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            this.list = list2;
            this.any = !((Collection)this.list).isEmpty();
            Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)this.list);
            Suggestions suggestions = this;
            boolean $i$f$filter = false;
            void var4_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!(this.list.get(it) instanceof SelectableComboboxItem)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            suggestions.selectableItemIndices = (List)destination$iv$iv;
        }

        @NotNull
        public final List<ComboboxItem> getList() {
            return this.list;
        }

        public final boolean getAny() {
            return this.any;
        }

        public final int getFirstSelectableIndex() {
            Integer n = (Integer)CollectionsKt.firstOrNull(this.selectableItemIndices);
            return n != null ? n : -1;
        }

        public final int getPreviousSelectableIndex(int selectedItemIndex) {
            Integer n;
            int index = this.selectableItemIndices.indexOf(selectedItemIndex);
            boolean bl = false;
            int prevIndex = index > -1 ? (index + this.selectableItemIndices.size() - 1) % this.selectableItemIndices.size() : -1;
            List<Integer> list2 = this.selectableItemIndices;
            boolean bl2 = 0 <= prevIndex ? prevIndex < list2.size() : false;
            if (bl2) {
                n = list2.get(prevIndex);
            } else {
                int it = prevIndex;
                boolean bl3 = false;
                n = -1;
            }
            return ((Number)n).intValue();
        }

        public final int getNextSelectableIndex(int selectedItemIndex) {
            Integer n;
            int index = this.selectableItemIndices.indexOf(selectedItemIndex);
            boolean bl = false;
            int nextIndex = index > -1 ? (index + 1) % this.selectableItemIndices.size() : 0;
            List<Integer> list2 = this.selectableItemIndices;
            boolean bl2 = 0 <= nextIndex ? nextIndex < list2.size() : false;
            if (bl2) {
                n = list2.get(nextIndex);
            } else {
                int it = nextIndex;
                boolean bl3 = false;
                n = -1;
            }
            return ((Number)n).intValue();
        }

        @Nullable
        public final ComboboxItem getSelectableItem(int index) {
            return (ComboboxItem)CollectionsKt.getOrNull(this.list, (int)index);
        }

        @NotNull
        public String toString() {
            return "Suggestions(list=" + this.list + ")";
        }

        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Suggestions)) {
                return false;
            }
            Suggestions suggestions = (Suggestions)other;
            return Intrinsics.areEqual(this.list, suggestions.list);
        }
    }
}

