/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui;

import com.jetbrains.toolbox.settings.GraphicsApi;
import com.jetbrains.toolbox.settings.InternalSettings;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.settings.SettingsManagerKt;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Ole32;
import java.util.List;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nWindowsRendererSwitcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsRendererSwitcher.kt\ncom/jetbrains/toolbox/ui/WindowsRendererSwitcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1869#2:90\n1869#2,2:91\n1870#2:93\n*S KotlinDebug\n*F\n+ 1 WindowsRendererSwitcher.kt\ncom/jetbrains/toolbox/ui/WindowsRendererSwitcher\n*L\n43#1:90\n44#1:91,2\n43#1:93\n*E\n"})
public final class WindowsRendererSwitcher {
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final List<Rule> rules;
    public static final int $stable = 8;

    public WindowsRendererSwitcher(@NotNull SettingsManager settingsManager, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.settingsManager = settingsManager;
        this.rules = CollectionsKt.listOf((Object)new Rule("TBX-15013: Switching Direct3D renderer to OpenGL for Intel 32.0.101.6554-6557 drivers", (Function1<? super VideoController, Boolean>)((Function1)arg_0 -> WindowsRendererSwitcher.rules$lambda$0(this, arg_0)), (Function0<Unit>)((Function0)() -> WindowsRendererSwitcher.rules$lambda$2(this))));
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ WindowsRendererSwitcher this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.applyRules();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void applyRules() {
        List<VideoController> gpus = this.getVideoControllers();
        Logger.INSTANCE.info("GPUs: " + gpus);
        Iterable $this$forEach$iv = this.rules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rule rule = (Rule)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = gpus;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                VideoController gpu = (VideoController)element$iv2;
                boolean bl2 = false;
                if (!((Boolean)rule.getMatch().invoke((Object)gpu)).booleanValue()) continue;
                Logger.INSTANCE.info("Applying rule '" + rule.getName() + "'. Matched GPU: " + gpu);
                rule.getApply().invoke();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<VideoController> getVideoControllers() {
        List list2;
        List $this$getVideoControllers_u24lambda_u245 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        try {
            Ole32.INSTANCE.CoInitializeEx(null, 0);
            WbemcliUtil.WmiQuery query2 = new WbemcliUtil.WmiQuery("Win32_VideoController", VideoController.Property.class);
            WbemcliUtil.WmiResult wmiResult = query2.execute();
            Intrinsics.checkNotNullExpressionValue((Object)wmiResult, (String)"execute(...)");
            WbemcliUtil.WmiResult result2 = wmiResult;
            int n = result2.getResultCount();
            for (int i2 = 0; i2 < n; ++i2) {
                $this$getVideoControllers_u24lambda_u245.add(new VideoController(result2.getValue((Enum)VideoController.Property.Name, i2).toString(), result2.getValue((Enum)VideoController.Property.DriverVersion, i2).toString()));
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Failed to enumerate video controllers");
        }
        finally {
            Ole32.INSTANCE.CoUninitialize();
        }
        return CollectionsKt.build((List)list2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean rules$lambda$0(WindowsRendererSwitcher this$0, VideoController it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GraphicsApi graphicsApi = ((SelfSettings)this$0.settingsManager.getSettings().getValue()).getInternal().getGraphicsApi();
        if (graphicsApi != GraphicsApi.Default) {
            if (graphicsApi != GraphicsApi.Direct3D) return false;
        }
        if (!StringsKt.contains$default((CharSequence)it.getName(), (CharSequence)"Intel", (boolean)false, (int)2, null)) return false;
        String string = it.getDriverVersion();
        if (0 > ((Comparable)((Object)string)).compareTo("32.0.101.6554")) return false;
        if (((Comparable)((Object)string)).compareTo("32.0.101.6557") > 0) return false;
        return true;
    }

    private static final InternalSettings rules$lambda$2$lambda$1(InternalSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return InternalSettings.copy-U8J3xAA$default(it, false, null, null, GraphicsApi.OpenGL, 0L, 0L, 0L, false, 0L, false, false, false, false, false, false, false, null, 0L, false, 0L, 0L, 0L, 0L, false, false, false, null, 0L, null, null, null, null, false, false, false, false, false, false, false, -9, 127, null);
    }

    private static final Unit rules$lambda$2(WindowsRendererSwitcher this$0) {
        SettingsManagerKt.updateInternalSettings(this$0.settingsManager, (Function1<? super InternalSettings, InternalSettings>)((Function1)WindowsRendererSwitcher::rules$lambda$2$lambda$1));
        return Unit.INSTANCE;
    }

    public static final class Rule {
        @NotNull
        private final String name;
        @NotNull
        private final Function1<VideoController, Boolean> match;
        @NotNull
        private final Function0<Unit> apply;

        public Rule(@NotNull String name2, @NotNull Function1<? super VideoController, Boolean> match2, @NotNull Function0<Unit> apply) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(match2, (String)"match");
            Intrinsics.checkNotNullParameter(apply, (String)"apply");
            this.name = name2;
            this.match = match2;
            this.apply = apply;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Function1<VideoController, Boolean> getMatch() {
            return this.match;
        }

        @NotNull
        public final Function0<Unit> getApply() {
            return this.apply;
        }
    }

    public static final class VideoController {
        @NotNull
        private final String name;
        @NotNull
        private final String driverVersion;

        public VideoController(@NotNull String name2, @NotNull String driverVersion) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)driverVersion, (String)"driverVersion");
            this.name = name2;
            this.driverVersion = driverVersion;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDriverVersion() {
            return this.driverVersion;
        }

        @NotNull
        public String toString() {
            return "VideoController(name=" + this.name + ", driverVersion=" + this.driverVersion + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.driverVersion.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VideoController)) {
                return false;
            }
            VideoController videoController = (VideoController)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)videoController.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.driverVersion, (Object)videoController.driverVersion);
        }

        public static final class Property
        extends Enum<Property> {
            public static final /* enum */ Property Name = new Property();
            public static final /* enum */ Property DriverVersion = new Property();
            private static final /* synthetic */ Property[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Property[] values() {
                return (Property[])$VALUES.clone();
            }

            static {
                $VALUES = propertyArray = new Property[]{Property.Name, Property.DriverVersion};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

