/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui;

import com.jetbrains.toolbox.UIGlobalState;
import com.jetbrains.toolbox.UIModalState;
import com.jetbrains.toolbox.manager.EndUserAgreementManager;
import com.jetbrains.toolbox.settings.Storage;
import com.jetbrains.toolbox.settings.StorageManager;
import com.jetbrains.toolbox.ui.navigation.Navigator;
import com.jetbrains.toolbox.ui.navigation.Screen;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScreenManager {
    @NotNull
    private final EndUserAgreementManager endUserAgreementManager;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final UIGlobalState uiGlobalStateManager;
    public static final int $stable = 8;

    public ScreenManager(@NotNull EndUserAgreementManager endUserAgreementManager, @NotNull StorageManager storageManager, @NotNull UIGlobalState uiGlobalStateManager) {
        Intrinsics.checkNotNullParameter((Object)endUserAgreementManager, (String)"endUserAgreementManager");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)uiGlobalStateManager, (String)"uiGlobalStateManager");
        this.endUserAgreementManager = endUserAgreementManager;
        this.storageManager = storageManager;
        this.uiGlobalStateManager = uiGlobalStateManager;
    }

    @NotNull
    public final Screen initialScreen(@Nullable Screen initialScreen) {
        Screen screen = this.initialScreenOrNull(initialScreen);
        if (screen == null) {
            screen = Screen.Main.INSTANCE;
        }
        return screen;
    }

    @Nullable
    public final Screen initialScreenOrNull(@Nullable Screen initialScreen) {
        if (!((Storage)this.storageManager.getStorage().getValue()).getOnboarding().isTechnicalOnboardingFinished()) {
            return Screen.Onboarding.INSTANCE;
        }
        if (!this.endUserAgreementManager.getAccepted()) {
            return Screen.EndUserAgreement.INSTANCE;
        }
        Screen screen = initialScreen;
        if (screen == null) {
            screen = this.toModalScreenOrNull((UIModalState)this.uiGlobalStateManager.getState().getValue());
        }
        return screen;
    }

    @NotNull
    public final Screen toScreen(@NotNull UIModalState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Screen screen = this.toModalScreenOrNull(state2);
        if (screen == null) {
            screen = Screen.Main.INSTANCE;
        }
        return screen;
    }

    public final void resetBlockingScreen(@NotNull Navigator navigator) {
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        if (this.uiGlobalStateManager.getState().getValue() instanceof UIModalState.Normal && this.isBlockingScreen((Screen)navigator.getCurrent().getValue())) {
            Navigator.back$default(navigator, true, null, 2, null);
        }
    }

    private final boolean isBlockingScreen(Screen screen) {
        Screen screen2 = screen;
        return screen2 instanceof Screen.ProposeEnterpriseConfig || screen2 instanceof Screen.ProposeInstall || screen2 instanceof Screen.LicenseAgreement || screen2 instanceof Screen.ModalAction || screen2 instanceof Screen.UnhandledError;
    }

    private final Screen toModalScreenOrNull(UIModalState state2) {
        Screen screen;
        UIModalState uIModalState = state2;
        if (uIModalState instanceof UIModalState.CandidateEnterpriseConfig) {
            screen = new Screen.ProposeEnterpriseConfig(((UIModalState.CandidateEnterpriseConfig)state2).getConfigUrl(), ((UIModalState.CandidateEnterpriseConfig)state2).getCwmConnectionAfterJoin());
        } else if (uIModalState instanceof UIModalState.FeedjetItem) {
            screen = new Screen.ProposeInstall(((UIModalState.FeedjetItem)state2).getToolBuild());
        } else if (uIModalState instanceof UIModalState.LicenseAgreement) {
            screen = new Screen.LicenseAgreement(((UIModalState.LicenseAgreement)state2).getLicenseAgreement(), ((UIModalState.LicenseAgreement)state2).getToolName());
        } else if (uIModalState instanceof UIModalState.Progress) {
            screen = new Screen.ModalAction(((UIModalState.Progress)state2).getMessage());
        } else if (uIModalState instanceof UIModalState.UnhandledError) {
            screen = new Screen.UnhandledError(((UIModalState.UnhandledError)state2).getError());
        } else if (Intrinsics.areEqual((Object)uIModalState, (Object)UIModalState.Normal.INSTANCE)) {
            screen = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return screen;
    }
}

