/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.uninstaller;

import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.interop.Pid;
import com.jetbrains.toolbox.tools.ToolUninstaller;
import com.jetbrains.toolbox.tools.UninstallResult;
import com.jetbrains.toolbox.tools.model.ChannelUtilsKt;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.runningStatusChecker.LinuxToolRunningStatusChecker;
import com.jetbrains.toolbox.tools.uninstaller.LinuxToolUninstaller;
import com.jetbrains.toolbox.tools.uninstaller.RemoveInstallDirKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.tinylog.kotlin.Logger;

@VisibleForTesting
public final class LinuxToolUninstaller
implements ToolUninstaller {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final LinuxToolRunningStatusChecker toolRunningStatusChecker;

    public LinuxToolUninstaller(@NotNull FileSystem fileSystem, @NotNull FileUtils fileUtils, @NotNull LinuxToolRunningStatusChecker toolRunningStatusChecker) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)fileUtils, (String)"fileUtils");
        Intrinsics.checkNotNullParameter((Object)toolRunningStatusChecker, (String)"toolRunningStatusChecker");
        this.fileSystem = fileSystem;
        this.fileUtils = fileUtils;
        this.toolRunningStatusChecker = toolRunningStatusChecker;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object uninstall(@NotNull ToolInstance toolInstance, @Nullable Path backupTo, @NotNull Continuation<? super UninstallResult> $completion) {
        if (!($completion instanceof uninstall.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ LinuxToolUninstaller this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.uninstall(null, null, (Continuation<? super UninstallResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = toolInstance;
                $continuation.L$1 = backupTo;
                $continuation.label = 1;
                v0 = this.canUninstall(toolInstance, (Continuation<? super UninstallResult>)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                backupTo = (Path)$continuation.L$1;
                toolInstance = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if (!Intrinsics.areEqual((Object)(canUninstall = (UninstallResult)v0), (Object)UninstallResult.Success.INSTANCE)) {
                    return canUninstall;
                }
                installDir = toolInstance.getChannel().getInstallationDirectory();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)toolInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)backupTo);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)canUninstall);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)installDir);
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super UninstallResult>, Object>(this, installDir, backupTo, null){
                    int label;
                    final /* synthetic */ LinuxToolUninstaller this$0;
                    final /* synthetic */ Path $installDir;
                    final /* synthetic */ Path $backupTo;
                    {
                        this.this$0 = $receiver;
                        this.$installDir = $installDir;
                        this.$backupTo = $backupTo;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                return RemoveInstallDirKt.removeInstallDir(LinuxToolUninstaller.access$getFileSystem$p(this.this$0), this.$installDir, this.$backupTo, LinuxToolUninstaller.access$getFileUtils$p(this.this$0));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super UninstallResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl43
            }
            case 2: {
                installDir = (Path)$continuation.L$3;
                canUninstall = (UninstallResult)$continuation.L$2;
                backupTo = (Path)$continuation.L$1;
                toolInstance = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object canUninstall(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super UninstallResult> $completion) {
        UninstallResult uninstallResult;
        if (!ChannelUtilsKt.canOverwriteInstallationDirectory(toolInstance.getChannel(), this.fileSystem)) {
            return UninstallResult.DirectoryIsNotWritable.INSTANCE;
        }
        Path directory = toolInstance.getChannel().getInstallationDirectory();
        Long pid = this.toolRunningStatusChecker.getRunningProcessPid(toolInstance);
        if (pid != null) {
            Logger.INSTANCE.info("Detected running process " + pid + " with directory '" + directory + "'");
            uninstallResult = new UninstallResult.Running(Pid.constructor-impl(pid), null);
        } else {
            uninstallResult = UninstallResult.Success.INSTANCE;
        }
        return uninstallResult;
    }

    public static final /* synthetic */ FileSystem access$getFileSystem$p(LinuxToolUninstaller $this) {
        return $this.fileSystem;
    }

    public static final /* synthetic */ FileUtils access$getFileUtils$p(LinuxToolUninstaller $this) {
        return $this.fileUtils;
    }
}

