/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.runningStatusChecker;

import com.jetbrains.toolbox.common.io.PathExtensionsKt;
import com.jetbrains.toolbox.interop.Pid;
import com.jetbrains.toolbox.interop.Win32Integration;
import com.jetbrains.toolbox.interop.Win32Processes;
import com.jetbrains.toolbox.tools.ToolRunningStatusChecker;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nWindowsToolRunningStatusChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsToolRunningStatusChecker.kt\ncom/jetbrains/toolbox/tools/runningStatusChecker/WindowsToolRunningStatusChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,25:1\n774#2:26\n865#2,2:27\n*S KotlinDebug\n*F\n+ 1 WindowsToolRunningStatusChecker.kt\ncom/jetbrains/toolbox/tools/runningStatusChecker/WindowsToolRunningStatusChecker\n*L\n22#1:26\n22#1:27,2\n*E\n"})
public final class WindowsToolRunningStatusChecker
implements ToolRunningStatusChecker {
    @NotNull
    private final Win32Processes win32Processes;

    public WindowsToolRunningStatusChecker(@NotNull Win32Processes win32Processes) {
        Intrinsics.checkNotNullParameter((Object)win32Processes, (String)"win32Processes");
        this.win32Processes = win32Processes;
    }

    public /* synthetic */ WindowsToolRunningStatusChecker(Win32Processes win32Processes, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            win32Processes = Win32Integration.INSTANCE;
        }
        this(win32Processes);
    }

    @Override
    public boolean isRunning(@NotNull ToolInstance toolInstance) {
        Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
        return !((Collection)this.getRunningProcesses(toolInstance)).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Pid, Path>> getRunningProcesses(@NotNull ToolInstance toolInstance) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
        Path installDir = toolInstance.getChannel().getInstallationDirectory();
        Iterable $this$filter$iv = this.win32Processes.listProcesses();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            Path path2 = (Path)pair.component2();
            if (!PathExtensionsKt.contains(installDir, path2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public WindowsToolRunningStatusChecker() {
        this(null, 1, null);
    }
}

