/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.recovery;

import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.common.io.DeleteKt;
import com.jetbrains.toolbox.tools.recovery.InstallationProgressTracker;
import com.jetbrains.toolbox.tools.recovery.State;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.okio.OkioStreamsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nInstallationProgressTrackerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallationProgressTrackerImpl.kt\ncom/jetbrains/toolbox/tools/recovery/InstallationProgressTrackerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 Okio.kt\nokio/Okio__OkioKt\n+ 5 OkioStreams.kt\nkotlinx/serialization/json/okio/OkioStreamsKt\n*L\n1#1,59:1\n1#2:60\n80#3:61\n165#3:62\n81#3:63\n82#3:68\n52#4,4:64\n60#4,10:70\n56#4,18:80\n46#5:69\n*S KotlinDebug\n*F\n+ 1 InstallationProgressTrackerImpl.kt\ncom/jetbrains/toolbox/tools/recovery/InstallationProgressTrackerImpl\n*L\n51#1:61\n51#1:62\n51#1:63\n51#1:68\n51#1:64,4\n51#1:70,10\n51#1:80,18\n51#1:69\n*E\n"})
public final class InstallationProgressTrackerImpl
implements InstallationProgressTracker {
    @NotNull
    private final Path targetPath;
    @NotNull
    private final Path stateFile;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final AtomicReference<State> state;

    public InstallationProgressTrackerImpl(@NotNull Path targetPath, @NotNull Path stateFile, @NotNull State initialState, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        Intrinsics.checkNotNullParameter((Object)stateFile, (String)"stateFile");
        Intrinsics.checkNotNullParameter((Object)initialState, (String)"initialState");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.targetPath = targetPath;
        this.stateFile = stateFile;
        this.fileSystem = fileSystem;
        this.state = new AtomicReference<State>(initialState);
    }

    @Override
    @Nullable
    public Object backupStarted(@Nullable Path target, @NotNull Continuation<? super Unit> $completion) {
        this.updateState((Function1<? super State, State>)((Function1)arg_0 -> InstallationProgressTrackerImpl.backupStarted$lambda$0(target, arg_0)));
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object backupFinished(@NotNull Continuation<? super Unit> $completion) {
        this.updateState((Function1<? super State, State>)((Function1)InstallationProgressTrackerImpl::backupFinished$lambda$1));
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object moveStarted(@NotNull Path target, @NotNull Continuation<? super Unit> $completion) {
        this.updateState((Function1<? super State, State>)((Function1)arg_0 -> InstallationProgressTrackerImpl.moveStarted$lambda$2(target, arg_0)));
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object moveFinished(@NotNull Continuation<? super Unit> $completion) {
        this.updateState((Function1<? super State, State>)((Function1)InstallationProgressTrackerImpl::moveFinished$lambda$3));
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object installationFinished(@NotNull Continuation<? super Unit> $completion) {
        this.updateState((Function1<? super State, State>)((Function1)InstallationProgressTrackerImpl::installationFinished$lambda$4));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void updateState(@NotNull Function1<? super State, State> transform2) {
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        try {
            Unit unit;
            Throwable thrown$iv$iv;
            block18: {
                void $this$iv;
                State newState;
                State state2 = newState = this.state.updateAndGet(arg_0 -> InstallationProgressTrackerImpl.updateState$lambda$5(transform2, arg_0));
                Logger.INSTANCE.debug("Tool '" + this.targetPath + "' is in '" + (state2 != null ? state2.getPhase() : null) + "' state");
                if (newState == null) {
                    DeleteKt.forceDeleteRecursively(this.fileSystem, this.stateFile);
                    return;
                }
                Path path2 = this.stateFile.parent();
                if (path2 != null) {
                    Path path3 = path2;
                    FileSystem fileSystem = this.fileSystem;
                    Path p0 = path3;
                    boolean bl = false;
                    fileSystem.createDirectories(p0);
                }
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = this.stateFile;
                boolean mustCreate$iv = false;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    void value$iv;
                    void $this$encodeToBufferedSink$iv;
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSink $this$updateState_u24lambda_u246 = it$iv;
                    boolean bl3 = false;
                    Json json2 = JsonKt.getJsonx();
                    State state3 = newState;
                    BufferedSink sink$iv = $this$updateState_u24lambda_u246;
                    boolean $i$f$encodeToBufferedSink = false;
                    $this$encodeToBufferedSink$iv.getSerializersModule();
                    OkioStreamsKt.encodeToBufferedSink((Json)$this$encodeToBufferedSink$iv, (SerializationStrategy)((SerializationStrategy)State.Companion.serializer()), (Object)value$iv, (BufferedSink)sink$iv);
                    unit = Unit.INSTANCE;
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        unit = null;
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block19: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block19;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            Unit result$iv$iv = unit;
            Throwable throwable = thrown$iv$iv;
            if (throwable == null) return;
            throw throwable;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Failed to update the installation state.");
        }
    }

    private static final State backupStarted$lambda$0(Path $target, State it) {
        return it != null ? State.copy$default(it, State.Phase.BackupStarted, null, null, $target, null, 22, null) : null;
    }

    private static final State backupFinished$lambda$1(State it) {
        State state2 = it;
        return state2 != null ? State.copy$default(state2, State.Phase.BackupFinished, null, null, null, null, 30, null) : null;
    }

    private static final State moveStarted$lambda$2(Path $target, State it) {
        return it != null ? State.copy$default(it, State.Phase.MoveStarted, $target, null, null, null, 28, null) : null;
    }

    private static final State moveFinished$lambda$3(State it) {
        State state2 = it;
        return state2 != null ? State.copy$default(state2, State.Phase.MoveFinished, null, null, null, null, 30, null) : null;
    }

    private static final State installationFinished$lambda$4(State it) {
        return null;
    }

    private static final State updateState$lambda$5(Function1 $tmp0, State p0) {
        return (State)$tmp0.invoke((Object)p0);
    }
}

