/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.provider;

import com.jetbrains.toolbox.common.io.PathExtensionsKt;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.PreinstalledChannel;
import com.jetbrains.toolbox.tools.provider.PreinstalledChannelFileHelper;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.okio.OkioStreamsKt;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nPreinstalledChannelFileHelperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreinstalledChannelFileHelperImpl.kt\ncom/jetbrains/toolbox/tools/provider/PreinstalledChannelFileHelperImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Okio.kt\nokio/Okio__OkioKt\n+ 5 FileSystem.kt\nokio/FileSystem\n*L\n1#1,55:1\n1617#2,9:56\n1869#2:65\n1870#2:68\n1626#2:69\n1#3:66\n1#3:67\n66#4:70\n52#4,4:72\n60#4,10:77\n56#4,3:87\n71#4,3:90\n67#5:71\n68#5:76\n*S KotlinDebug\n*F\n+ 1 PreinstalledChannelFileHelperImpl.kt\ncom/jetbrains/toolbox/tools/provider/PreinstalledChannelFileHelperImpl\n*L\n23#1:56,9\n23#1:65\n23#1:68\n23#1:69\n23#1:67\n44#1:70\n44#1:72,4\n44#1:77,10\n44#1:87,3\n44#1:90,3\n44#1:71\n44#1:76\n*E\n"})
public final class PreinstalledChannelFileHelperImpl
implements PreinstalledChannelFileHelper {
    @NotNull
    private final Path preinstalledChannelDirectory;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Json parser;
    @NotNull
    private final String channelPrefix;

    public PreinstalledChannelFileHelperImpl(@NotNull Path preinstalledChannelDirectory, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)preinstalledChannelDirectory, (String)"preinstalledChannelDirectory");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.preinstalledChannelDirectory = preinstalledChannelDirectory;
        this.fileSystem = fileSystem;
        this.parser = JsonKt.Json$default(null, PreinstalledChannelFileHelperImpl::parser$lambda$3, (int)1, null);
        this.channelPrefix = "preinstalled-";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<ChannelId, PreinstalledChannel> getAll() {
        void $this$mapNotNullTo$iv$iv;
        List list2 = this.fileSystem.listOrNull(this.preinstalledChannelDirectory);
        if (list2 == null) {
            PreinstalledChannelFileHelperImpl $this$getAll_u24lambda_u240 = this;
            boolean bl = false;
            Logger.INSTANCE.debug("Preinstalled channel directory is absent, expected at: " + $this$getAll_u24lambda_u240.preinstalledChannelDirectory);
            return MapsKt.emptyMap();
        }
        List channelFiles = list2;
        Iterable $this$mapNotNull$iv = channelFiles;
        boolean $i$f$mapNotNull = false;
        Iterable $this$getAll_u24lambda_u240 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Path channelPath = (Path)element$iv$iv;
            boolean bl2 = false;
            if (this.readChannel(channelPath) != null) {
                PreinstalledChannel it;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)ChannelId.box-impl(this.channelPathToId-K2rgjsw(channelPath)), (Object)it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final String channelPathToId-K2rgjsw(Path channelPath) {
        return ChannelId.constructor-impl(this.channelPrefix + PathExtensionsKt.getNameWithoutExtension(channelPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PreinstalledChannel readChannel(Path channelPath) {
        try {
            PreinstalledChannel preinstalledChannel;
            Throwable thrown$iv$iv;
            block16: {
                void this_$iv;
                Object object = this.fileSystem;
                Path file$iv = channelPath;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSource $this$readChannel_u24lambda_u244 = it$iv;
                    boolean bl3 = false;
                    preinstalledChannel = (PreinstalledChannel)OkioStreamsKt.decodeFromBufferedSource((Json)this.parser, (DeserializationStrategy)((DeserializationStrategy)PreinstalledChannel.Companion.serializer()), (BufferedSource)$this$readChannel_u24lambda_u244);
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        preinstalledChannel = null;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block17: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block17;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            PreinstalledChannel result$iv$iv = preinstalledChannel;
            Throwable throwable = thrown$iv$iv;
            if (throwable == null) return result$iv$iv;
            throw throwable;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Couldn't parse " + channelPath);
            return null;
        }
    }

    private static final Unit parser$lambda$3(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setEncodeDefaults(false);
        $this$Json.setCoerceInputValues(true);
        $this$Json.setExplicitNulls(false);
        $this$Json.setLenient(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }
}

