/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.provider;

import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.ParseDesktopFileKt;
import com.jetbrains.toolbox.tools.provider.LocalToolPathProvider;
import com.jetbrains.toolbox.tools.provider.PathToScan;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nLinuxDesktopFileScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinuxDesktopFileScanner.kt\ncom/jetbrains/toolbox/tools/provider/LinuxDesktopFileScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1869#2,2:118\n1#3:120\n*S KotlinDebug\n*F\n+ 1 LinuxDesktopFileScanner.kt\ncom/jetbrains/toolbox/tools/provider/LinuxDesktopFileScanner\n*L\n19#1:118,2\n*E\n"})
public final class LinuxDesktopFileScanner
implements LocalToolPathProvider {
    @NotNull
    private final FileSystem fileSystem;

    public LinuxDesktopFileScanner(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    @Override
    @NotNull
    public List<PathToScan> getPathsToScan() {
        List list2;
        List $this$_get_pathsToScan__u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Path desktopFileParentPath : this.getDesktopFileParentPaths()) {
            Logger.INSTANCE.debug("Looking for .desktop files in '" + desktopFileParentPath + "'");
            List list3 = this.fileSystem.listOrNull(desktopFileParentPath);
            if (list3 == null) continue;
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path desktopFilePath = (Path)element$iv;
                boolean bl2 = false;
                if (!StringsKt.endsWith$default((String)desktopFilePath.name(), (String)".desktop", (boolean)false, (int)2, null)) continue;
                Logger.INSTANCE.trace("Parsing .desktop file '" + desktopFilePath + "'");
                try {
                    Path folderPath;
                    String startupWMClass;
                    Map<String, String> desktopFileProperties = ParseDesktopFileKt.parseDesktopFile(this.fileSystem, desktopFilePath);
                    String string = startupWMClass = desktopFileProperties.get("StartupWMClass");
                    boolean bl3 = string != null ? StringsKt.startsWith$default((String)string, (String)"jetbrains-", (boolean)false, (int)2, null) : false;
                    if (!bl3 || this.guessInstallationPath(desktopFileProperties) == null) continue;
                    Logger.INSTANCE.debug("Found installation path '" + folderPath + "' in .desktop file '" + desktopFilePath + "'");
                    $this$_get_pathsToScan__u24lambda_u241.add(new PathToScan(folderPath, 0));
                }
                catch (IOException e) {
                    Logger.INSTANCE.warn("Couldn't parse .desktop file '" + desktopFilePath + "': " + e.getMessage());
                }
                catch (Exception e) {
                    Logger.INSTANCE.error((Throwable)e, "Couldn't parse .desktop file '" + desktopFilePath + "'");
                }
            }
        }
        return CollectionsKt.build((List)list2);
    }

    private final Set<Path> getDesktopFileParentPaths() {
        Set set2;
        Set $this$getDesktopFileParentPaths_u24lambda_u242 = set2 = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$getDesktopFileParentPaths_u24lambda_u242.addAll((Collection)StandardPaths.INSTANCE.getApplicationDirs());
        Path gnomeApps = StandardPaths.INSTANCE.getHome().resolve(".gnome/apps");
        if (this.fileSystem.exists(gnomeApps)) {
            $this$getDesktopFileParentPaths_u24lambda_u242.add(gnomeApps);
        }
        return SetsKt.build((Set)set2);
    }

    /*
     * Unable to fully structure code
     */
    private final Path guessInstallationPath(Map<String, String> desktopFileProperties) {
        v0 = desktopFileProperties.get("Exec");
        if (v0 == null) ** GOTO lbl-1000
        it = var5_2 = v0;
        $i$a$-takeIf-LinuxDesktopFileScanner$guessInstallationPath$execString$1 = false;
        v0 = StringsKt.startsWith$default((String)it, (String)"env BAMF_DESKTOP_FILE_HINT=", (boolean)false, (int)2, null) == false != false ? var5_2 : null;
        if (v0 != null) {
            v1 = StringsKt.trim((CharSequence)v0).toString();
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        v2 = execString = v1;
        if (v2 != null) {
            it = v2;
            $i$a$-let-LinuxDesktopFileScanner$guessInstallationPath$execPath$1 = false;
            v3 = this.extractPathFromExec(this.unescapeDesktopEntry(it));
        } else {
            v3 = null;
        }
        execPath = v3;
        v4 = desktopFileProperties.get("Icon");
        if (v4 != null) {
            it = v4;
            $i$a$-let-LinuxDesktopFileScanner$guessInstallationPath$iconPath$1 = false;
            v5 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)this.unescapeDesktopEntry(it), (boolean)false, (int)1, null);
        } else {
            v5 = iconPath = null;
        }
        if ((v6 = execPath) == null && (v6 = iconPath) == null) {
            return null;
        }
        filePath = v6;
        v7 = filePath.parent();
        if (v7 == null) {
            return null;
        }
        folderPath = v7;
        return Intrinsics.areEqual((Object)folderPath.name(), (Object)"bin") != false ? folderPath.parent() : folderPath;
    }

    private final String unescapeDesktopEntry(String entry) {
        StringBuilder stringBuilder;
        StringBuilder $this$unescapeDesktopEntry_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean escaped = false;
        int n = entry.length();
        for (int j = 0; j < n; ++j) {
            char c = entry.charAt(j);
            if (escaped) {
                switch (c) {
                    case 's': {
                        Object object = $this$unescapeDesktopEntry_u24lambda_u246.append(' ');
                        break;
                    }
                    case 'n': {
                        Object object = $this$unescapeDesktopEntry_u24lambda_u246.append('\n');
                        break;
                    }
                    case 't': {
                        Object object = $this$unescapeDesktopEntry_u24lambda_u246.append('\t');
                        break;
                    }
                    case 'r': {
                        Object object = $this$unescapeDesktopEntry_u24lambda_u246.append('\r');
                        break;
                    }
                    case '\\': {
                        Object object = $this$unescapeDesktopEntry_u24lambda_u246.append('\\');
                        break;
                    }
                    default: {
                        Object object = Unit.INSTANCE;
                    }
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            $this$unescapeDesktopEntry_u24lambda_u246.append(c);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final Path extractPathFromExec(String unescapedExecString) {
        String string;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        Path.Companion companion = Path.Companion;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)unescapedExecString)) {
            return null;
        }
        boolean quoted = unescapedExecString.charAt(0) == '\"';
        boolean escaped = false;
        if (quoted) {
            String string2 = unescapedExecString.substring(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = unescapedExecString;
        }
        String string3 = string;
        int n = string3.length();
        for (int j = 0; j < n; ++j) {
            void $this$extractPathFromExec_u24lambda_u247;
            char c = string3.charAt(j);
            if (escaped) {
                escaped = false;
                $this$extractPathFromExec_u24lambda_u247.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (quoted && c == '\"' || !quoted && c == ' ') break;
            $this$extractPathFromExec_u24lambda_u247.append(c);
        }
        return Path.Companion.get$default((Path.Companion)companion, (String)stringBuilder.toString(), (boolean)false, (int)1, null);
    }
}

