/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.process.workers;

import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.fleet.FleetStatusManager;
import com.jetbrains.toolbox.intellij.IntelliJDiscoveryStatusManager;
import com.jetbrains.toolbox.intellij.IntelliJStatusManager;
import com.jetbrains.toolbox.interop.Pid;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.tools.ToolProcessStateWorker;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import com.jetbrains.toolbox.tools.launcher.ProcessLauncher;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.ToolProcessEvent;
import com.jetbrains.toolbox.tools.model.ToolProcessState;
import com.jetbrains.toolbox.tools.model.ToolProcessStateKt;
import com.jetbrains.toolbox.tools.process.workers.ExitingStateWorker;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class ExitingStateWorker
implements ToolProcessStateWorker<ToolProcessState.Exiting> {
    @NotNull
    private final ToolManager toolManager;
    @NotNull
    private final IntelliJDiscoveryStatusManager intelliJDiscoveryStatusManager;
    @NotNull
    private final IntelliJStatusManager intelliJStatusManager;
    @NotNull
    private final FleetStatusManager fleetStatusManager;
    @NotNull
    private final ProcessLauncher processLauncher;

    public ExitingStateWorker(@NotNull ToolManager toolManager, @NotNull IntelliJDiscoveryStatusManager intelliJDiscoveryStatusManager, @NotNull IntelliJStatusManager intelliJStatusManager, @NotNull FleetStatusManager fleetStatusManager, @NotNull ProcessLauncher processLauncher) {
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter((Object)intelliJDiscoveryStatusManager, (String)"intelliJDiscoveryStatusManager");
        Intrinsics.checkNotNullParameter((Object)intelliJStatusManager, (String)"intelliJStatusManager");
        Intrinsics.checkNotNullParameter((Object)fleetStatusManager, (String)"fleetStatusManager");
        Intrinsics.checkNotNullParameter((Object)processLauncher, (String)"processLauncher");
        this.toolManager = toolManager;
        this.intelliJDiscoveryStatusManager = intelliJDiscoveryStatusManager;
        this.intelliJStatusManager = intelliJStatusManager;
        this.fleetStatusManager = fleetStatusManager;
        this.processLauncher = processLauncher;
    }

    @Override
    @NotNull
    public KClass<ToolProcessState.Exiting> getState() {
        return Reflection.getOrCreateKotlinClass(ToolProcessState.Exiting.class);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object handle(@NotNull ToolProcessState.Exiting state, @NotNull Continuation<? super ToolProcessEvent> $completion) {
        if (!($completion instanceof handle.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ExitingStateWorker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handle((ToolProcessState.Exiting)null, (Continuation<? super ToolProcessEvent>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.processLauncher.attach(state.getPid-MOBmICs());
                if (v0 == null) {
                    throw new NoSuchElementException("Process not found");
                }
                handle = v0;
                if (!state.getForced()) ** GOTO lbl21
                v1 = handle.destroyForcibly();
                ** GOTO lbl36
lbl21:
                // 1 sources

                $continuation.L$0 = state;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)handle);
                $continuation.label = 1;
                v2 = this.gracefulShutdown(state, (Continuation<? super Boolean>)$continuation);
                ** if (v2 != var7_5) goto lbl27
lbl26:
                // 1 sources

                return var7_5;
lbl27:
                // 1 sources

                ** GOTO lbl35
            }
            case 1: {
                handle = (ProcessHandle)$continuation.L$1;
                state = (ToolProcessState.Exiting)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl35:
                    // 2 sources

                    v1 = success = ((Boolean)v2).booleanValue();
lbl36:
                    // 2 sources

                    if (!success) {
                        Logger.INSTANCE.warn("Termination of the process " + Pid.toString-impl(state.getPid-MOBmICs()) + " wasn't successful");
                        return new ToolProcessEvent.Failure(new IllegalStateException("Termination of the process " + Pid.toString-impl(state.getPid-MOBmICs()) + " wasn't successful"));
                    }
                }
                catch (Throwable e) {
                    Logger.INSTANCE.warn(e, "Error during process " + Pid.toString-impl(state.getPid-MOBmICs()) + " termination");
                    return new ToolProcessEvent.Failure(e);
                }
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object gracefulShutdown(ToolProcessState.Exiting state2, Continuation<? super Boolean> $completion) {
        String channelId = ToolProcessStateKt.getChannelIdOrNull(state2);
        String string = channelId;
        ChannelState channelState = (ChannelState)((Map)this.toolManager.getModel().getValue()).get(string != null ? ChannelId.box-impl(string) : null);
        Object object = channelState;
        String string2 = object != null && (object = object.getTool()) != null ? object.getToolId-UtVBrGo() : null;
        String string3 = WellKnownApplications.INSTANCE.getFleet-UtVBrGo();
        String string4 = string2;
        boolean isFleet = string4 == null ? false : ApplicationType.equals-impl0(string4, string3);
        boolean supportDiscovery = ((Map)this.intelliJDiscoveryStatusManager.getStatus().getValue()).containsKey(Pid.box-impl(state2.getPid-MOBmICs()));
        if (channelId != null && isFleet) {
            Logger.INSTANCE.debug("Shutting down Fleet (" + Pid.toString-impl(state2.getPid-MOBmICs()) + ")");
            return this.fleetStatusManager.shutdown(ChannelId.box-impl(channelId), $completion);
        }
        if (supportDiscovery) {
            Logger.INSTANCE.debug("Shutting down IDE (" + Pid.toString-impl(state2.getPid-MOBmICs()) + ")");
            return this.intelliJDiscoveryStatusManager.shutdown(Pid.box-impl(state2.getPid-MOBmICs()), $completion);
        }
        if (channelId != null) {
            Logger.INSTANCE.debug("Shutting down IDE (" + Pid.toString-impl(state2.getPid-MOBmICs()) + ") via built in server");
            return this.intelliJStatusManager.shutdown(ChannelId.box-impl(channelId), $completion);
        }
        Logger.INSTANCE.warn("No channel id found for pid " + Pid.toString-impl(state2.getPid-MOBmICs()) + ", falling back to discovery");
        return this.intelliJDiscoveryStatusManager.shutdown(Pid.box-impl(state2.getPid-MOBmICs()), $completion);
    }
}

