/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.model.licensing;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.feed.RemoteFeedItemLicensing;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.licensing.JBAFallbackLicenseInfo;
import com.jetbrains.toolbox.tools.model.licensing.JBAFallbackLicenseInfo$;
import com.jetbrains.toolbox.tools.model.licensing.JBALicenseInfo;
import com.jetbrains.toolbox.tools.model.licensing.JBALicenseInfo$;
import com.jetbrains.toolbox.tools.model.licensing.LicenseInfoKt;
import com.jetbrains.toolbox.tools.model.licensing.LicenseType;
import com.jetbrains.toolbox.tools.model.licensing.NCLicenseInfo;
import com.jetbrains.toolbox.tools.model.licensing.NCLicenseInfo$;
import com.jetbrains.toolbox.tools.model.licensing.ProductId;
import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.datetime.Instant;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SealedClassSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;

@Serializable
public sealed interface LicenseInfo
permits JBAFallbackLicenseInfo, JBALicenseInfo, NCLicenseInfo {
    @NotNull
    public static final Companion Companion = com.jetbrains.toolbox.tools.model.licensing.LicenseInfo$Companion.$$INSTANCE;

    @NotNull
    public LicenseType getType();

    @NotNull
    public LocalizableString getDisplayName();

    @NotNull
    public Instant getValidUntil();

    public boolean getActive();

    @NotNull
    public List<ProductId> getProducts();

    default public boolean validFor(@NotNull InstalledTool tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        return LicenseInfoKt.validForApplicationType-YMaXqMg(this, tool.getToolId-UtVBrGo()) || LicenseInfoKt.validForSalesCode(this, tool.getSalesCode());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean validFor(@NotNull ToolBuild toolBuild) {
        Intrinsics.checkNotNullParameter((Object)toolBuild, (String)"toolBuild");
        if (LicenseInfoKt.validForApplicationType-YMaXqMg(this, toolBuild.getTool().getApplicationType-UtVBrGo())) return true;
        RemoteFeedItemLicensing remoteFeedItemLicensing = toolBuild.getVersion().getLicensing();
        if (!LicenseInfoKt.validForSalesCode(this, remoteFeedItemLicensing != null ? remoteFeedItemLicensing.getSalesCode() : null)) return false;
        return true;
    }

    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final KSerializer<LicenseInfo> serializer() {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(JBAFallbackLicenseInfo.class), Reflection.getOrCreateKotlinClass(JBALicenseInfo.class), Reflection.getOrCreateKotlinClass(NCLicenseInfo.class)};
            KClass[] kClassArray2 = kClassArray;
            kClassArray = new KSerializer[]{JBAFallbackLicenseInfo$.serializer.INSTANCE, JBALicenseInfo$.serializer.INSTANCE, NCLicenseInfo$.serializer.INSTANCE};
            return (KSerializer)new SealedClassSerializer("com.jetbrains.toolbox.tools.model.licensing.LicenseInfo", Reflection.getOrCreateKotlinClass(LicenseInfo.class), kClassArray2, (KSerializer[])kClassArray, new Annotation[0]);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    public static final class DefaultImpls {
        @Deprecated
        public static boolean validFor(@NotNull LicenseInfo $this, @NotNull InstalledTool tool) {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            return $this.validFor(tool);
        }

        @Deprecated
        public static boolean validFor(@NotNull LicenseInfo $this, @NotNull ToolBuild toolBuild) {
            Intrinsics.checkNotNullParameter((Object)toolBuild, (String)"toolBuild");
            return $this.validFor(toolBuild);
        }
    }
}

