/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.model.licensing;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.licensing.JBALicenseInfo$;
import com.jetbrains.toolbox.tools.model.licensing.LicenseInfo;
import com.jetbrains.toolbox.tools.model.licensing.LicenseType;
import com.jetbrains.toolbox.tools.model.licensing.SalesCode;
import com.jetbrains.toolbox.tools.model.licensing.SalesCode$;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.serializers.InstantIso8601Serializer;
import kotlinx.datetime.serializers.LocalDateIso8601Serializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
public final class JBALicenseInfo
implements LicenseInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final boolean active;
    @NotNull
    private final Instant validUntil;
    @NotNull
    private final List<SalesCode> products;
    @NotNull
    private final String licenseId;
    @NotNull
    private final Map<SalesCode, LocalDate> fallbackDates;
    @NotNull
    private final LocalizableString displayName;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public JBALicenseInfo(@NotNull String name2, boolean active2, @NotNull Instant validUntil, @NotNull List<SalesCode> products, @NotNull String licenseId, @NotNull Map<SalesCode, LocalDate> fallbackDates) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)validUntil, (String)"validUntil");
        Intrinsics.checkNotNullParameter(products, (String)"products");
        Intrinsics.checkNotNullParameter((Object)licenseId, (String)"licenseId");
        Intrinsics.checkNotNullParameter(fallbackDates, (String)"fallbackDates");
        this.name = name2;
        this.active = active2;
        this.validUntil = validUntil;
        this.products = products;
        this.licenseId = licenseId;
        this.fallbackDates = fallbackDates;
        this.displayName = LocalizableStringExKt.notr(this.name);
    }

    public /* synthetic */ JBALicenseInfo(String string, boolean bl, Instant instant, List list2, String string2, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(string, bl, instant, list2, string2, map2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    @NotNull
    public Instant getValidUntil() {
        return this.validUntil;
    }

    @NotNull
    public List<SalesCode> getProducts() {
        return this.products;
    }

    @NotNull
    public final String getLicenseId() {
        return this.licenseId;
    }

    @NotNull
    public final Map<SalesCode, LocalDate> getFallbackDates() {
        return this.fallbackDates;
    }

    @Override
    @NotNull
    public LocalizableString getDisplayName() {
        return this.displayName;
    }

    @Override
    @NotNull
    public LicenseType getType() {
        return LicenseType.GENERAL;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final boolean component2() {
        return this.active;
    }

    @NotNull
    public final Instant component3() {
        return this.validUntil;
    }

    @NotNull
    public final List<SalesCode> component4() {
        return this.products;
    }

    @NotNull
    public final String component5() {
        return this.licenseId;
    }

    @NotNull
    public final Map<SalesCode, LocalDate> component6() {
        return this.fallbackDates;
    }

    @NotNull
    public final JBALicenseInfo copy(@NotNull String name2, boolean active2, @NotNull Instant validUntil, @NotNull List<SalesCode> products, @NotNull String licenseId, @NotNull Map<SalesCode, LocalDate> fallbackDates) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)validUntil, (String)"validUntil");
        Intrinsics.checkNotNullParameter(products, (String)"products");
        Intrinsics.checkNotNullParameter((Object)licenseId, (String)"licenseId");
        Intrinsics.checkNotNullParameter(fallbackDates, (String)"fallbackDates");
        return new JBALicenseInfo(name2, active2, validUntil, products, licenseId, fallbackDates);
    }

    public static /* synthetic */ JBALicenseInfo copy$default(JBALicenseInfo jBALicenseInfo, String string, boolean bl, Instant instant, List list2, String string2, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            string = jBALicenseInfo.name;
        }
        if ((n & 2) != 0) {
            bl = jBALicenseInfo.active;
        }
        if ((n & 4) != 0) {
            instant = jBALicenseInfo.validUntil;
        }
        if ((n & 8) != 0) {
            list2 = jBALicenseInfo.products;
        }
        if ((n & 0x10) != 0) {
            string2 = jBALicenseInfo.licenseId;
        }
        if ((n & 0x20) != 0) {
            map2 = jBALicenseInfo.fallbackDates;
        }
        return jBALicenseInfo.copy(string, bl, instant, list2, string2, map2);
    }

    @NotNull
    public String toString() {
        return "JBALicenseInfo(name=" + this.name + ", active=" + this.active + ", validUntil=" + this.validUntil + ", products=" + this.products + ", licenseId=" + this.licenseId + ", fallbackDates=" + this.fallbackDates + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.active);
        result2 = result2 * 31 + this.validUntil.hashCode();
        result2 = result2 * 31 + ((Object)this.products).hashCode();
        result2 = result2 * 31 + this.licenseId.hashCode();
        result2 = result2 * 31 + ((Object)this.fallbackDates).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JBALicenseInfo)) {
            return false;
        }
        JBALicenseInfo jBALicenseInfo = (JBALicenseInfo)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)jBALicenseInfo.name)) {
            return false;
        }
        if (this.active != jBALicenseInfo.active) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.validUntil, (Object)jBALicenseInfo.validUntil)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.products, jBALicenseInfo.products)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.licenseId, (Object)jBALicenseInfo.licenseId)) {
            return false;
        }
        return Intrinsics.areEqual(this.fallbackDates, jBALicenseInfo.fallbackDates);
    }

    @Override
    public boolean validFor(@NotNull InstalledTool tool) {
        return LicenseInfo.super.validFor(tool);
    }

    @Override
    public boolean validFor(@NotNull ToolBuild toolBuild) {
        return LicenseInfo.super.validFor(toolBuild);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$tools_api(JBALicenseInfo self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output2.encodeStringElement(serialDesc, 0, self.name);
        output2.encodeBooleanElement(serialDesc, 1, self.getActive());
        output2.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)InstantIso8601Serializer.INSTANCE, (Object)self.getValidUntil());
        output2.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)lazyArray[3].getValue(), self.getProducts());
        output2.encodeStringElement(serialDesc, 4, self.licenseId);
        if (output2.shouldEncodeElementDefault(serialDesc, 5) ? true : !Intrinsics.areEqual(self.fallbackDates, (Object)MapsKt.emptyMap())) {
            output2.encodeSerializableElement(serialDesc, 5, (SerializationStrategy)lazyArray[5].getValue(), self.fallbackDates);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 6) ? true : !Intrinsics.areEqual((Object)self.getDisplayName(), (Object)LocalizableStringExKt.notr(self.name))) {
            output2.encodeSerializableElement(serialDesc, 6, (SerializationStrategy)lazyArray[6].getValue(), (Object)self.getDisplayName());
        }
    }

    public /* synthetic */ JBALicenseInfo(int seen0, String name2, boolean active2, Instant validUntil, List products, String licenseId, Map fallbackDates, LocalizableString displayName, SerializationConstructorMarker serializationConstructorMarker) {
        if (31 != (0x1F & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)31, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.name = name2;
        this.active = active2;
        this.validUntil = validUntil;
        this.products = products;
        this.licenseId = licenseId;
        this.fallbackDates = (seen0 & 0x20) == 0 ? MapsKt.emptyMap() : fallbackDates;
        this.displayName = (seen0 & 0x40) == 0 ? (LocalizableString)LocalizableStringExKt.notr(this.name) : displayName;
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)SalesCode$.serializer.INSTANCE)), null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashMapSerializer((KSerializer)SalesCode$.serializer.INSTANCE, (KSerializer)LocalDateIso8601Serializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new PolymorphicSerializer(Reflection.getOrCreateKotlinClass(LocalizableString.class), new Annotation[0]))};
        $childSerializers = lazyArray;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<JBALicenseInfo> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

