/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.model;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import com.jetbrains.toolbox.feed.AdditionalInstallAction;
import com.jetbrains.toolbox.feed.ApplicationMajorVersion;
import com.jetbrains.toolbox.feed.ApplicationPackage;
import com.jetbrains.toolbox.feed.ApplicationPackageType;
import com.jetbrains.toolbox.feed.ApplicationQuality;
import com.jetbrains.toolbox.feed.Authenticator;
import com.jetbrains.toolbox.feed.FileAssociationsSupport;
import com.jetbrains.toolbox.feed.Flavor;
import com.jetbrains.toolbox.feed.IntelliJBuildProperties;
import com.jetbrains.toolbox.feed.IntelliJConfiguration;
import com.jetbrains.toolbox.feed.IntelliJPlatformData;
import com.jetbrains.toolbox.feed.IntelliJToolProperties;
import com.jetbrains.toolbox.feed.ReSharperData;
import com.jetbrains.toolbox.feed.RemoteChecksum;
import com.jetbrains.toolbox.feed.RemoteDevelopment;
import com.jetbrains.toolbox.feed.RemoteFeedItem;
import com.jetbrains.toolbox.feed.WhatsNew;
import com.jetbrains.toolbox.tools.model.AvailableBuild;
import com.jetbrains.toolbox.tools.model.AvailableBuild$;
import com.jetbrains.toolbox.tools.model.AvailableTool;
import com.jetbrains.toolbox.tools.model.AvailableTool$;
import com.jetbrains.toolbox.tools.model.AvailableVersion;
import com.jetbrains.toolbox.tools.model.AvailableVersion$;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.ToolBuild$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.LocalDateTime;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
public final class ToolBuild
implements Comparable<ToolBuild> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AvailableTool tool;
    @NotNull
    private final AvailableVersion version;
    @NotNull
    private final AvailableBuild build;
    private static final Comparator<ToolBuild> COMPARATOR;

    public ToolBuild(@NotNull AvailableTool tool, @NotNull AvailableVersion version, @NotNull AvailableBuild build2) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        this.tool = tool;
        this.version = version;
        this.build = build2;
    }

    @NotNull
    public final AvailableTool getTool() {
        return this.tool;
    }

    @NotNull
    public final AvailableVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final AvailableBuild getBuild() {
        return this.build;
    }

    @NotNull
    public final String getDisplayName() {
        return this.tool.getName() + " " + this.version.getName() + " (" + BuildNumber.toString-impl(this.build.getId-Y_E1uuk()) + ")";
    }

    @Override
    public int compareTo(@NotNull ToolBuild other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return COMPARATOR.compare(this, other);
    }

    @NotNull
    public final AvailableTool component1() {
        return this.tool;
    }

    @NotNull
    public final AvailableVersion component2() {
        return this.version;
    }

    @NotNull
    public final AvailableBuild component3() {
        return this.build;
    }

    @NotNull
    public final ToolBuild copy(@NotNull AvailableTool tool, @NotNull AvailableVersion version, @NotNull AvailableBuild build2) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        return new ToolBuild(tool, version, build2);
    }

    public static /* synthetic */ ToolBuild copy$default(ToolBuild toolBuild, AvailableTool availableTool2, AvailableVersion availableVersion, AvailableBuild availableBuild, int n, Object object) {
        if ((n & 1) != 0) {
            availableTool2 = toolBuild.tool;
        }
        if ((n & 2) != 0) {
            availableVersion = toolBuild.version;
        }
        if ((n & 4) != 0) {
            availableBuild = toolBuild.build;
        }
        return toolBuild.copy(availableTool2, availableVersion, availableBuild);
    }

    @NotNull
    public String toString() {
        return "ToolBuild(tool=" + this.tool + ", version=" + this.version + ", build=" + this.build + ")";
    }

    public int hashCode() {
        int result2 = this.tool.hashCode();
        result2 = result2 * 31 + this.version.hashCode();
        result2 = result2 * 31 + this.build.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ToolBuild)) {
            return false;
        }
        ToolBuild toolBuild = (ToolBuild)other;
        if (!Intrinsics.areEqual((Object)this.tool, (Object)toolBuild.tool)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)toolBuild.version)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.build, (Object)toolBuild.build);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$tools_api(ToolBuild self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        output2.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)AvailableTool$.serializer.INSTANCE, (Object)self.tool);
        output2.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)AvailableVersion$.serializer.INSTANCE, (Object)self.version);
        output2.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)AvailableBuild$.serializer.INSTANCE, (Object)self.build);
    }

    public /* synthetic */ ToolBuild(int seen0, AvailableTool tool, AvailableVersion version, AvailableBuild build2, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.tool = tool;
        this.version = version;
        this.build = build2;
    }

    private static final int COMPARATOR$lambda$0(ToolBuild it) {
        return it.version.getMajorVersion().getOrder();
    }

    private static final int COMPARATOR$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    static {
        Function1 function1 = Companion.COMPARATOR.2.INSTANCE;
        COMPARATOR = Comparator.comparingInt(arg_0 -> ToolBuild.COMPARATOR$lambda$1(ToolBuild::COMPARATOR$lambda$0, arg_0)).thenComparing(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @SourceDebugExtension(value={"SMAP\nToolBuild.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolBuild.kt\ncom/jetbrains/toolbox/tools/model/ToolBuild$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n463#2:121\n413#2:122\n1252#3,4:123\n1563#3:127\n1634#3,3:128\n*S KotlinDebug\n*F\n+ 1 ToolBuild.kt\ncom/jetbrains/toolbox/tools/model/ToolBuild$Companion\n*L\n86#1:121\n86#1:122\n86#1:123,4\n105#1:127\n105#1:128,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ToolBuild of-QT3uPOY(@NotNull RemoteFeedItem remoteFeedItem, @Nullable String icon2, @NotNull ApplicationQuality fallbackQuality, @NotNull ApplicationMajorVersion fallbackMajorVersion) {
            AdditionalInstallAction additionalInstallAction;
            AdditionalInstallAction additionalInstallAction2;
            Map.Entry entry;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            AvailableBuild.EmbeddedClient embeddedClient;
            Object object;
            AvailableTool availableTool2;
            AvailableVersion availableVersion;
            Object object2;
            ApplicationMajorVersion applicationMajorVersion;
            Intrinsics.checkNotNullParameter((Object)remoteFeedItem, (String)"remoteFeedItem");
            Intrinsics.checkNotNullParameter((Object)fallbackQuality, (String)"fallbackQuality");
            Intrinsics.checkNotNullParameter((Object)fallbackMajorVersion, (String)"fallbackMajorVersion");
            ApplicationPackage applicationPackage = remoteFeedItem.getPackage();
            IntelliJPlatformData intelliJPlatformData = remoteFeedItem.getIntelliJPlatform();
            AvailableTool availableTool3 = new AvailableTool(remoteFeedItem.getApplicationType-UtVBrGo(), remoteFeedItem.getName(), remoteFeedItem.getSupersedes(), remoteFeedItem.getVendor(), remoteFeedItem.getDescription(), remoteFeedItem.getOrderValue(), remoteFeedItem.getLaunched(), remoteFeedItem.getHomeUrl(), remoteFeedItem.getActivation(), remoteFeedItem.getLanguages(), remoteFeedItem.getLicenseAgreement(), remoteFeedItem.getFreeForNonCommercialUse(), remoteFeedItem.getProductOverview(), intelliJPlatformData != null ? this.toToolProperties(intelliJPlatformData) : null, remoteFeedItem.getUninstall(), remoteFeedItem.getDeprecated(), null);
            String string = remoteFeedItem.getVersion();
            ApplicationQuality applicationQuality = remoteFeedItem.getQuality();
            if (applicationQuality == null) {
                applicationQuality = fallbackQuality;
            }
            if ((applicationMajorVersion = remoteFeedItem.getMajorVersion()) == null) {
                applicationMajorVersion = fallbackMajorVersion;
            }
            AvailableVersion availableVersion2 = new AvailableVersion(string, applicationQuality, applicationMajorVersion, icon2, remoteFeedItem.getWhatsNew(), remoteFeedItem.getLicensing(), null);
            String string2 = remoteFeedItem.getBuild-Y_E1uuk();
            WhatsNew whatsNew2 = remoteFeedItem.getWhatsNew();
            ApplicationPackageType applicationPackageType = applicationPackage.getType();
            int n = applicationPackage.getStripDirectories();
            String string3 = StringExtensionsKt.getNullIfEmpty(applicationPackage.getCommand());
            Path path2 = string3 != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)string3, (boolean)false, (int)1, null) : null;
            Object object3 = remoteFeedItem.getRemoteDevelopment();
            if (object3 != null && (object3 = ((RemoteDevelopment)object3).getEmbeddedClient()) != null) {
                void it;
                object2 = object3;
                availableVersion = availableVersion2;
                availableTool2 = availableTool3;
                boolean bl = false;
                String string4 = it.getCommand();
                object = new AvailableBuild.EmbeddedClient(string4 != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)string4, (boolean)false, (int)1, null) : null);
                availableTool3 = availableTool2;
                availableVersion2 = availableVersion;
                embeddedClient = object;
            } else {
                embeddedClient = null;
            }
            AvailableBuild.EmbeddedClient embeddedClient2 = embeddedClient;
            String string5 = applicationPackage.getUrl();
            long l = applicationPackage.getSize();
            object2 = applicationPackage.getAuth();
            List<RemoteChecksum> list2 = applicationPackage.getChecksums();
            List<String> list3 = applicationPackage.getArguments();
            Map<String, String> map2 = (Map<String, String>)applicationPackage.getRequirements();
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map<String, String> map3 = map2;
            availableVersion = availableVersion2;
            availableTool2 = availableTool3;
            boolean $i$f$mapValues = false;
            FileAssociationsSupport fileAssociationsSupport = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$mapValuesTo$iv$iv2;
                void it$iv$iv;
                entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = map4;
                boolean bl2 = false;
                JsonElement v = (JsonElement)entry2.getValue();
                Map $this$mapValues$iv2 = (Map)JsonElementKt.getJsonObject((JsonElement)v);
                boolean $i$f$mapValues2 = false;
                Map map5 = $this$mapValues$iv2;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
                boolean $i$f$mapValuesTo2 = false;
                Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv2.entrySet();
                boolean $i$f$associateByTo2 = false;
                for (Object element$iv$iv$iv2 : $this$associateByTo$iv$iv$iv2) {
                    void it$iv$iv2;
                    Map.Entry entry3 = (Map.Entry)element$iv$iv$iv2;
                    Map map6 = destination$iv$iv2;
                    $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
                    Map.Entry entry4 = (Map.Entry)element$iv$iv$iv2;
                    Object k2 = it$iv$iv2.getKey();
                    Map map7 = map6;
                    boolean bl3 = false;
                    JsonElement e = (JsonElement)entry4.getValue();
                    if (!JsonElementKt.getJsonPrimitive((JsonElement)e).isString()) {
                        String string6 = "Failed requirement.";
                        throw new IllegalArgumentException(string6.toString());
                    }
                    String string7 = JsonElementKt.getJsonPrimitive((JsonElement)e).getContent();
                    map7.put(k2, string7);
                }
                Map map8 = destination$iv$iv2;
                object.put(k, map8);
            }
            Object object4 = object = destination$iv$iv;
            map3 = applicationPackage.getDotDesktopExtraEntries();
            RemoteDevelopment remoteDevelopment = remoteFeedItem.getRemoteDevelopment();
            boolean bl = remoteDevelopment != null ? remoteDevelopment.getCanActAsRemoteHost() : false;
            fileAssociationsSupport = new FileAssociationsSupport(SetsKt.emptySet(), null, 2, null);
            AdditionalInstallAction additionalInstallAction3 = remoteFeedItem.getAfterInstall();
            if (additionalInstallAction3 == null) {
                additionalInstallAction3 = additionalInstallAction2 = new AdditionalInstallAction(null, 1, null);
            }
            if ((additionalInstallAction = remoteFeedItem.getBeforeUninstall()) == null) {
                additionalInstallAction = new AdditionalInstallAction(null, 1, null);
            }
            AdditionalInstallAction additionalInstallAction4 = additionalInstallAction;
            LocalDateTime localDateTime = remoteFeedItem.getReleased();
            LocalDateTime localDateTime2 = remoteFeedItem.getExpires();
            IntelliJPlatformData intelliJPlatformData2 = remoteFeedItem.getIntelliJPlatform();
            IntelliJBuildProperties intelliJBuildProperties = intelliJPlatformData2 != null ? this.toBuildProperties(intelliJPlatformData2) : null;
            ReSharperData reSharperData = remoteFeedItem.getResharper();
            String string8 = applicationPackage.getIconPath();
            entry = string8 != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)string8, (boolean)false, (int)1, null) : null;
            AvailableBuild availableBuild = new AvailableBuild(string2, whatsNew2, applicationPackageType, n, path2, embeddedClient2, string5, l, (Authenticator)object2, list2, list3, (Map)object4, map3, bl, fileAssociationsSupport, null, additionalInstallAction2, additionalInstallAction4, (Path)entry, localDateTime, localDateTime2, intelliJBuildProperties, reSharperData, 32768, null);
            AvailableVersion availableVersion3 = availableVersion;
            AvailableTool availableTool4 = availableTool2;
            return new ToolBuild(availableTool4, availableVersion3, availableBuild);
        }

        /*
         * WARNING - void declaration
         */
        private final IntelliJToolProperties toToolProperties(IntelliJPlatformData $this$toToolProperties) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = $this$toToolProperties.getConfig();
            Set set2 = CollectionsKt.toSet((Iterable)$this$toToolProperties.getDirectoryPatterns());
            String string = $this$toToolProperties.getShellScriptName();
            String string2 = $this$toToolProperties.getProductCode-fnix534();
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IntelliJConfiguration intelliJConfiguration = (IntelliJConfiguration)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getRecentProjectsFilename());
            }
            collection = (List)destination$iv$iv;
            IntelliJConfiguration intelliJConfiguration = (IntelliJConfiguration)CollectionsKt.firstOrNull($this$toToolProperties.getConfig());
            DefaultConstructorMarker defaultConstructorMarker = null;
            Collection<Flavor> collection2 = $this$toToolProperties.getFlavors();
            boolean bl = intelliJConfiguration != null ? intelliJConfiguration.getShowSingleProject() : true;
            Set set3 = CollectionsKt.toSet((Iterable)collection);
            Set set4 = set2;
            String string3 = string;
            String string4 = string2;
            return new IntelliJToolProperties(string4, string3, set4, set3, bl, collection2, defaultConstructorMarker);
        }

        private final IntelliJBuildProperties toBuildProperties(IntelliJPlatformData $this$toBuildProperties) {
            return new IntelliJBuildProperties($this$toBuildProperties.getUserVmOptions(), CollectionsKt.toSet((Iterable)$this$toBuildProperties.getIncompatibleVmoptions()), $this$toBuildProperties.getDefaultConfigDirectories(), $this$toBuildProperties.getLocalizationPlugins());
        }

        @NotNull
        public final KSerializer<ToolBuild> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Factory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }
    }
}

