/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.model;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.BuildNumber$;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.common.formatting.HumanMemorySizeKt;
import com.jetbrains.toolbox.common.serialization.InstantAsEpochSecondsSerializer;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.tools.model.FailedUpdate$;
import com.jetbrains.toolbox.tools.model.FailedUpdate$Reason$Failed$CannotMoveFiles$;
import com.jetbrains.toolbox.tools.model.FailedUpdate$Reason$Failed$FailedToCreateTempDirectory$;
import com.jetbrains.toolbox.tools.model.FailedUpdate$Reason$Failed$FailedToInstall$;
import com.jetbrains.toolbox.tools.model.FailedUpdate$Reason$Failed$FailedToLaunch$;
import com.jetbrains.toolbox.tools.model.FailedUpdate$Reason$Failed$FailedToRemoveFiles$;
import com.jetbrains.toolbox.tools.model.FailedUpdate$Reason$Failed$NotEnoughDiskSpace$;
import com.jetbrains.toolbox.tools.model.FailedUpdate$Reason$Failed$Other$;
import com.jetbrains.toolbox.tools.model.FailedUpdate$Reason$Failed$ServerError$;
import java.lang.annotation.Annotation;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.datetime.Instant;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SealedClassSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ObjectSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Serializable
public final class FailedUpdate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String buildNumber;
    @Nullable
    private final Instant shouldPostponeUntil;
    @NotNull
    private final Reason reason;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    private FailedUpdate(String buildNumber, Instant shouldPostponeUntil, Reason reason) {
        Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.buildNumber = buildNumber;
        this.shouldPostponeUntil = shouldPostponeUntil;
        this.reason = reason;
    }

    @NotNull
    public final String getBuildNumber-Y_E1uuk() {
        return this.buildNumber;
    }

    @SerialName(value="build_number")
    public static /* synthetic */ void getBuildNumber-Y_E1uuk$annotations() {
    }

    @Nullable
    public final Instant getShouldPostponeUntil() {
        return this.shouldPostponeUntil;
    }

    @Serializable(with=InstantAsEpochSecondsSerializer.class)
    @SerialName(value="should_postpone_until")
    public static /* synthetic */ void getShouldPostponeUntil$annotations() {
    }

    @NotNull
    public final Reason getReason() {
        return this.reason;
    }

    @NotNull
    public final String component1-Y_E1uuk() {
        return this.buildNumber;
    }

    @Nullable
    public final Instant component2() {
        return this.shouldPostponeUntil;
    }

    @NotNull
    public final Reason component3() {
        return this.reason;
    }

    @NotNull
    public final FailedUpdate copy-zjpk8aY(@NotNull String buildNumber, @Nullable Instant shouldPostponeUntil, @NotNull Reason reason) {
        Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return new FailedUpdate(buildNumber, shouldPostponeUntil, reason, null);
    }

    public static /* synthetic */ FailedUpdate copy-zjpk8aY$default(FailedUpdate failedUpdate, String string, Instant instant, Reason reason, int n, Object object) {
        if ((n & 1) != 0) {
            string = failedUpdate.buildNumber;
        }
        if ((n & 2) != 0) {
            instant = failedUpdate.shouldPostponeUntil;
        }
        if ((n & 4) != 0) {
            reason = failedUpdate.reason;
        }
        return failedUpdate.copy-zjpk8aY(string, instant, reason);
    }

    @NotNull
    public String toString() {
        return "FailedUpdate(buildNumber=" + BuildNumber.toString-impl(this.buildNumber) + ", shouldPostponeUntil=" + this.shouldPostponeUntil + ", reason=" + this.reason + ")";
    }

    public int hashCode() {
        int result2 = BuildNumber.hashCode-impl(this.buildNumber);
        result2 = result2 * 31 + (this.shouldPostponeUntil == null ? 0 : this.shouldPostponeUntil.hashCode());
        result2 = result2 * 31 + this.reason.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FailedUpdate)) {
            return false;
        }
        FailedUpdate failedUpdate = (FailedUpdate)other;
        if (!BuildNumber.equals-impl0(this.buildNumber, failedUpdate.buildNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shouldPostponeUntil, (Object)failedUpdate.shouldPostponeUntil)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.reason, (Object)failedUpdate.reason);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$tools_api(FailedUpdate self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output2.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)BuildNumber$.serializer.INSTANCE, (Object)BuildNumber.box-impl(self.buildNumber));
        output2.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)InstantAsEpochSecondsSerializer.INSTANCE, (Object)self.shouldPostponeUntil);
        output2.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), (Object)self.reason);
    }

    private /* synthetic */ FailedUpdate(int seen0, String buildNumber, Instant shouldPostponeUntil, Reason reason, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.buildNumber = buildNumber;
        this.shouldPostponeUntil = shouldPostponeUntil;
        this.reason = reason;
    }

    public /* synthetic */ FailedUpdate(String buildNumber, Instant shouldPostponeUntil, Reason reason, DefaultConstructorMarker $constructor_marker) {
        this(buildNumber, shouldPostponeUntil, reason);
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    public /* synthetic */ FailedUpdate(int seen0, String buildNumber, Instant shouldPostponeUntil, Reason reason, SerializationConstructorMarker serializationConstructorMarker, DefaultConstructorMarker $constructor_marker) {
        this(seen0, buildNumber, shouldPostponeUntil, reason, serializationConstructorMarker);
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> Reason.Companion.serializer())};
        $childSerializers = lazyArray;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<FailedUpdate> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    public static sealed interface Reason {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public LocalizableString getExplanation();

        @Serializable
        public static final class Cancelled
        implements Reason {
            @NotNull
            public static final Cancelled INSTANCE = new Cancelled();
            private static final /* synthetic */ Lazy<KSerializer<Object>> $cachedSerializer$delegate;

            private Cancelled() {
            }

            @Override
            @NotNull
            public LocalizableString getExplanation() {
                return LocalizableStringExKt.trl("Canceled by user");
            }

            @NotNull
            public final KSerializer<Cancelled> serializer() {
                return this.get$cachedSerializer();
            }

            @NotNull
            public String toString() {
                return "Cancelled";
            }

            public int hashCode() {
                return -967690441;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Cancelled)) {
                    return false;
                }
                Cancelled cfr_ignored_0 = (Cancelled)other;
                return true;
            }

            private final /* synthetic */ KSerializer get$cachedSerializer() {
                return (KSerializer)$cachedSerializer$delegate.getValue();
            }

            static {
                $cachedSerializer$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ObjectSerializer("com.jetbrains.toolbox.tools.model.FailedUpdate.Reason.Cancelled", (Object)INSTANCE, new Annotation[0]));
            }
        }

        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final KSerializer<Reason> serializer() {
                KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Cancelled.class), Reflection.getOrCreateKotlinClass(Failed.CannotMoveFiles.class), Reflection.getOrCreateKotlinClass(Failed.CannotSelectInstallationDirectory.class), Reflection.getOrCreateKotlinClass(Failed.FailedToCreateTempDirectory.class), Reflection.getOrCreateKotlinClass(Failed.FailedToExtractPackage.class), Reflection.getOrCreateKotlinClass(Failed.FailedToInstall.class), Reflection.getOrCreateKotlinClass(Failed.FailedToLaunch.class), Reflection.getOrCreateKotlinClass(Failed.FailedToRemoveFiles.class), Reflection.getOrCreateKotlinClass(Failed.NotEnoughDiskSpace.class), Reflection.getOrCreateKotlinClass(Failed.Other.class), Reflection.getOrCreateKotlinClass(Failed.ServerError.class), Reflection.getOrCreateKotlinClass(Failed.VerificationFailed.class)};
                KClass[] kClassArray2 = kClassArray;
                kClassArray = new KSerializer[]{new ObjectSerializer("com.jetbrains.toolbox.tools.model.FailedUpdate.Reason.Cancelled", (Object)Cancelled.INSTANCE, new Annotation[0]), Reason$Failed$CannotMoveFiles$$serializer.INSTANCE, new ObjectSerializer("com.jetbrains.toolbox.tools.model.FailedUpdate.Reason.Failed.CannotSelectInstallationDirectory", (Object)Failed.CannotSelectInstallationDirectory.INSTANCE, new Annotation[0]), Reason$Failed$FailedToCreateTempDirectory$$serializer.INSTANCE, new ObjectSerializer("com.jetbrains.toolbox.tools.model.FailedUpdate.Reason.Failed.FailedToExtractPackage", (Object)Failed.FailedToExtractPackage.INSTANCE, new Annotation[0]), Reason$Failed$FailedToInstall$$serializer.INSTANCE, Reason$Failed$FailedToLaunch$$serializer.INSTANCE, Reason$Failed$FailedToRemoveFiles$$serializer.INSTANCE, Reason$Failed$NotEnoughDiskSpace$$serializer.INSTANCE, Reason$Failed$Other$$serializer.INSTANCE, Reason$Failed$ServerError$$serializer.INSTANCE, new ObjectSerializer("com.jetbrains.toolbox.tools.model.FailedUpdate.Reason.Failed.VerificationFailed", (Object)Failed.VerificationFailed.INSTANCE, new Annotation[0])};
                return (KSerializer)new SealedClassSerializer("com.jetbrains.toolbox.tools.model.FailedUpdate.Reason", Reflection.getOrCreateKotlinClass(Reason.class), kClassArray2, (KSerializer[])kClassArray, new Annotation[0]);
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        @Serializable
        public static sealed interface Failed
        extends Reason {
            @NotNull
            public static final Companion Companion = Companion.$$INSTANCE;

            @Serializable
            public static final class CannotMoveFiles
            implements Failed {
                @NotNull
                public static final Companion Companion = new Companion(null);
                @NotNull
                private final String directory;

                public CannotMoveFiles(@NotNull String directory) {
                    Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                    this.directory = directory;
                }

                @NotNull
                public final String getDirectory() {
                    return this.directory;
                }

                @Override
                @NotNull
                public LocalizableString getExplanation() {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"directory", (Object)this.directory)};
                    return LocalizableStringExKt.trl("Cannot move files to {{directory}}", pairArray);
                }

                @NotNull
                public final String component1() {
                    return this.directory;
                }

                @NotNull
                public final CannotMoveFiles copy(@NotNull String directory) {
                    Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                    return new CannotMoveFiles(directory);
                }

                public static /* synthetic */ CannotMoveFiles copy$default(CannotMoveFiles cannotMoveFiles, String string, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = cannotMoveFiles.directory;
                    }
                    return cannotMoveFiles.copy(string);
                }

                @NotNull
                public String toString() {
                    return "CannotMoveFiles(directory=" + this.directory + ")";
                }

                public int hashCode() {
                    return this.directory.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof CannotMoveFiles)) {
                        return false;
                    }
                    CannotMoveFiles cannotMoveFiles = (CannotMoveFiles)other;
                    return Intrinsics.areEqual((Object)this.directory, (Object)cannotMoveFiles.directory);
                }

                @JvmStatic
                public static final /* synthetic */ void write$Self$tools_api(CannotMoveFiles self, CompositeEncoder output2, SerialDescriptor serialDesc) {
                    output2.encodeStringElement(serialDesc, 0, self.directory);
                }

                public /* synthetic */ CannotMoveFiles(int seen0, String directory, SerializationConstructorMarker serializationConstructorMarker) {
                    if (1 != (1 & seen0)) {
                        PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Reason$Failed$CannotMoveFiles$$serializer.INSTANCE.getDescriptor());
                    }
                    this.directory = directory;
                }

                public static final class Companion {
                    private Companion() {
                    }

                    @NotNull
                    public final KSerializer<CannotMoveFiles> serializer() {
                        return (KSerializer)Reason$Failed$CannotMoveFiles$$serializer.INSTANCE;
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Serializable
            public static final class CannotSelectInstallationDirectory
            implements Failed {
                @NotNull
                public static final CannotSelectInstallationDirectory INSTANCE = new CannotSelectInstallationDirectory();
                private static final /* synthetic */ Lazy<KSerializer<Object>> $cachedSerializer$delegate;

                private CannotSelectInstallationDirectory() {
                }

                @Override
                @NotNull
                public LocalizableString getExplanation() {
                    return LocalizableStringExKt.trl("Cannot select installation directory");
                }

                @NotNull
                public final KSerializer<CannotSelectInstallationDirectory> serializer() {
                    return this.get$cachedSerializer();
                }

                @NotNull
                public String toString() {
                    return "CannotSelectInstallationDirectory";
                }

                public int hashCode() {
                    return 1294618237;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof CannotSelectInstallationDirectory)) {
                        return false;
                    }
                    CannotSelectInstallationDirectory cfr_ignored_0 = (CannotSelectInstallationDirectory)other;
                    return true;
                }

                private final /* synthetic */ KSerializer get$cachedSerializer() {
                    return (KSerializer)$cachedSerializer$delegate.getValue();
                }

                static {
                    $cachedSerializer$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ObjectSerializer("com.jetbrains.toolbox.tools.model.FailedUpdate.Reason.Failed.CannotSelectInstallationDirectory", (Object)INSTANCE, new Annotation[0]));
                }
            }

            public static final class Companion {
                static final /* synthetic */ Companion $$INSTANCE;

                private Companion() {
                }

                @NotNull
                public final KSerializer<Failed> serializer() {
                    KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(CannotMoveFiles.class), Reflection.getOrCreateKotlinClass(CannotSelectInstallationDirectory.class), Reflection.getOrCreateKotlinClass(FailedToCreateTempDirectory.class), Reflection.getOrCreateKotlinClass(FailedToExtractPackage.class), Reflection.getOrCreateKotlinClass(FailedToInstall.class), Reflection.getOrCreateKotlinClass(FailedToLaunch.class), Reflection.getOrCreateKotlinClass(FailedToRemoveFiles.class), Reflection.getOrCreateKotlinClass(NotEnoughDiskSpace.class), Reflection.getOrCreateKotlinClass(Other.class), Reflection.getOrCreateKotlinClass(ServerError.class), Reflection.getOrCreateKotlinClass(VerificationFailed.class)};
                    KClass[] kClassArray2 = kClassArray;
                    kClassArray = new KSerializer[]{Reason$Failed$CannotMoveFiles$$serializer.INSTANCE, new ObjectSerializer("com.jetbrains.toolbox.tools.model.FailedUpdate.Reason.Failed.CannotSelectInstallationDirectory", (Object)CannotSelectInstallationDirectory.INSTANCE, new Annotation[0]), Reason$Failed$FailedToCreateTempDirectory$$serializer.INSTANCE, new ObjectSerializer("com.jetbrains.toolbox.tools.model.FailedUpdate.Reason.Failed.FailedToExtractPackage", (Object)FailedToExtractPackage.INSTANCE, new Annotation[0]), Reason$Failed$FailedToInstall$$serializer.INSTANCE, Reason$Failed$FailedToLaunch$$serializer.INSTANCE, Reason$Failed$FailedToRemoveFiles$$serializer.INSTANCE, Reason$Failed$NotEnoughDiskSpace$$serializer.INSTANCE, Reason$Failed$Other$$serializer.INSTANCE, Reason$Failed$ServerError$$serializer.INSTANCE, new ObjectSerializer("com.jetbrains.toolbox.tools.model.FailedUpdate.Reason.Failed.VerificationFailed", (Object)VerificationFailed.INSTANCE, new Annotation[0])};
                    return (KSerializer)new SealedClassSerializer("com.jetbrains.toolbox.tools.model.FailedUpdate.Reason.Failed", Reflection.getOrCreateKotlinClass(Failed.class), kClassArray2, (KSerializer[])kClassArray, new Annotation[0]);
                }

                static {
                    $$INSTANCE = new Companion();
                }
            }

            @Serializable
            public static final class FailedToCreateTempDirectory
            implements Failed {
                @NotNull
                public static final Companion Companion = new Companion(null);
                @Nullable
                private final String error;

                public FailedToCreateTempDirectory(@Nullable String error2) {
                    this.error = error2;
                }

                @Nullable
                public final String getError() {
                    return this.error;
                }

                @Override
                @NotNull
                public LocalizableString getExplanation() {
                    LocalizableString localizableString;
                    if (this.error != null) {
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"error", (Object)this.error)};
                        localizableString = LocalizableStringExKt.trl("Failed to create a temporary directory: {{error}}", pairArray);
                    } else {
                        localizableString = LocalizableStringExKt.trl("Failed to create a temporary directory");
                    }
                    return localizableString;
                }

                @Nullable
                public final String component1() {
                    return this.error;
                }

                @NotNull
                public final FailedToCreateTempDirectory copy(@Nullable String error2) {
                    return new FailedToCreateTempDirectory(error2);
                }

                public static /* synthetic */ FailedToCreateTempDirectory copy$default(FailedToCreateTempDirectory failedToCreateTempDirectory, String string, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = failedToCreateTempDirectory.error;
                    }
                    return failedToCreateTempDirectory.copy(string);
                }

                @NotNull
                public String toString() {
                    return "FailedToCreateTempDirectory(error=" + this.error + ")";
                }

                public int hashCode() {
                    return this.error == null ? 0 : this.error.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof FailedToCreateTempDirectory)) {
                        return false;
                    }
                    FailedToCreateTempDirectory failedToCreateTempDirectory = (FailedToCreateTempDirectory)other;
                    return Intrinsics.areEqual((Object)this.error, (Object)failedToCreateTempDirectory.error);
                }

                @JvmStatic
                public static final /* synthetic */ void write$Self$tools_api(FailedToCreateTempDirectory self, CompositeEncoder output2, SerialDescriptor serialDesc) {
                    output2.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.error);
                }

                public /* synthetic */ FailedToCreateTempDirectory(int seen0, String error2, SerializationConstructorMarker serializationConstructorMarker) {
                    if (1 != (1 & seen0)) {
                        PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Reason$Failed$FailedToCreateTempDirectory$$serializer.INSTANCE.getDescriptor());
                    }
                    this.error = error2;
                }

                public static final class Companion {
                    private Companion() {
                    }

                    @NotNull
                    public final KSerializer<FailedToCreateTempDirectory> serializer() {
                        return (KSerializer)Reason$Failed$FailedToCreateTempDirectory$$serializer.INSTANCE;
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Serializable
            public static final class FailedToExtractPackage
            implements Failed {
                @NotNull
                public static final FailedToExtractPackage INSTANCE = new FailedToExtractPackage();
                private static final /* synthetic */ Lazy<KSerializer<Object>> $cachedSerializer$delegate;

                private FailedToExtractPackage() {
                }

                @Override
                @NotNull
                public LocalizableString getExplanation() {
                    return LocalizableStringExKt.trl("Failed to extract package");
                }

                @NotNull
                public final KSerializer<FailedToExtractPackage> serializer() {
                    return this.get$cachedSerializer();
                }

                @NotNull
                public String toString() {
                    return "FailedToExtractPackage";
                }

                public int hashCode() {
                    return -1811644908;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof FailedToExtractPackage)) {
                        return false;
                    }
                    FailedToExtractPackage cfr_ignored_0 = (FailedToExtractPackage)other;
                    return true;
                }

                private final /* synthetic */ KSerializer get$cachedSerializer() {
                    return (KSerializer)$cachedSerializer$delegate.getValue();
                }

                static {
                    $cachedSerializer$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ObjectSerializer("com.jetbrains.toolbox.tools.model.FailedUpdate.Reason.Failed.FailedToExtractPackage", (Object)INSTANCE, new Annotation[0]));
                }
            }

            @Serializable
            public static final class FailedToInstall
            implements Failed {
                @NotNull
                public static final Companion Companion = new Companion(null);
                @NotNull
                private final String appName;

                public FailedToInstall(@NotNull String appName) {
                    Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
                    this.appName = appName;
                }

                @NotNull
                public final String getAppName() {
                    return this.appName;
                }

                @Override
                @NotNull
                public LocalizableString getExplanation() {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"appName", (Object)this.appName)};
                    return LocalizableStringExKt.trl("Failed to install {{appName}}", pairArray);
                }

                @NotNull
                public final String component1() {
                    return this.appName;
                }

                @NotNull
                public final FailedToInstall copy(@NotNull String appName) {
                    Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
                    return new FailedToInstall(appName);
                }

                public static /* synthetic */ FailedToInstall copy$default(FailedToInstall failedToInstall, String string, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = failedToInstall.appName;
                    }
                    return failedToInstall.copy(string);
                }

                @NotNull
                public String toString() {
                    return "FailedToInstall(appName=" + this.appName + ")";
                }

                public int hashCode() {
                    return this.appName.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof FailedToInstall)) {
                        return false;
                    }
                    FailedToInstall failedToInstall = (FailedToInstall)other;
                    return Intrinsics.areEqual((Object)this.appName, (Object)failedToInstall.appName);
                }

                @JvmStatic
                public static final /* synthetic */ void write$Self$tools_api(FailedToInstall self, CompositeEncoder output2, SerialDescriptor serialDesc) {
                    output2.encodeStringElement(serialDesc, 0, self.appName);
                }

                public /* synthetic */ FailedToInstall(int seen0, String appName, SerializationConstructorMarker serializationConstructorMarker) {
                    if (1 != (1 & seen0)) {
                        PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Reason$Failed$FailedToInstall$$serializer.INSTANCE.getDescriptor());
                    }
                    this.appName = appName;
                }

                public static final class Companion {
                    private Companion() {
                    }

                    @NotNull
                    public final KSerializer<FailedToInstall> serializer() {
                        return (KSerializer)Reason$Failed$FailedToInstall$$serializer.INSTANCE;
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Serializable
            public static final class FailedToLaunch
            implements Failed {
                @NotNull
                public static final Companion Companion = new Companion(null);
                @NotNull
                private final String appName;

                public FailedToLaunch(@NotNull String appName) {
                    Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
                    this.appName = appName;
                }

                @NotNull
                public final String getAppName() {
                    return this.appName;
                }

                @Override
                @NotNull
                public LocalizableString getExplanation() {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"appName", (Object)this.appName)};
                    return LocalizableStringExKt.trl("Failed to launch {{appName}}", pairArray);
                }

                @NotNull
                public final String component1() {
                    return this.appName;
                }

                @NotNull
                public final FailedToLaunch copy(@NotNull String appName) {
                    Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
                    return new FailedToLaunch(appName);
                }

                public static /* synthetic */ FailedToLaunch copy$default(FailedToLaunch failedToLaunch, String string, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = failedToLaunch.appName;
                    }
                    return failedToLaunch.copy(string);
                }

                @NotNull
                public String toString() {
                    return "FailedToLaunch(appName=" + this.appName + ")";
                }

                public int hashCode() {
                    return this.appName.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof FailedToLaunch)) {
                        return false;
                    }
                    FailedToLaunch failedToLaunch = (FailedToLaunch)other;
                    return Intrinsics.areEqual((Object)this.appName, (Object)failedToLaunch.appName);
                }

                @JvmStatic
                public static final /* synthetic */ void write$Self$tools_api(FailedToLaunch self, CompositeEncoder output2, SerialDescriptor serialDesc) {
                    output2.encodeStringElement(serialDesc, 0, self.appName);
                }

                public /* synthetic */ FailedToLaunch(int seen0, String appName, SerializationConstructorMarker serializationConstructorMarker) {
                    if (1 != (1 & seen0)) {
                        PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Reason$Failed$FailedToLaunch$$serializer.INSTANCE.getDescriptor());
                    }
                    this.appName = appName;
                }

                public static final class Companion {
                    private Companion() {
                    }

                    @NotNull
                    public final KSerializer<FailedToLaunch> serializer() {
                        return (KSerializer)Reason$Failed$FailedToLaunch$$serializer.INSTANCE;
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Serializable
            public static final class FailedToRemoveFiles
            implements Failed {
                @NotNull
                public static final Companion Companion = new Companion(null);
                @NotNull
                private final String path;

                public FailedToRemoveFiles(@NotNull String path2) {
                    Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                    this.path = path2;
                }

                @NotNull
                public final String getPath() {
                    return this.path;
                }

                @Override
                @NotNull
                public LocalizableString getExplanation() {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"path", (Object)this.path)};
                    return LocalizableStringExKt.trl("Failed to remove files from {{path}}", pairArray);
                }

                @NotNull
                public final String component1() {
                    return this.path;
                }

                @NotNull
                public final FailedToRemoveFiles copy(@NotNull String path2) {
                    Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                    return new FailedToRemoveFiles(path2);
                }

                public static /* synthetic */ FailedToRemoveFiles copy$default(FailedToRemoveFiles failedToRemoveFiles, String string, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = failedToRemoveFiles.path;
                    }
                    return failedToRemoveFiles.copy(string);
                }

                @NotNull
                public String toString() {
                    return "FailedToRemoveFiles(path=" + this.path + ")";
                }

                public int hashCode() {
                    return this.path.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof FailedToRemoveFiles)) {
                        return false;
                    }
                    FailedToRemoveFiles failedToRemoveFiles = (FailedToRemoveFiles)other;
                    return Intrinsics.areEqual((Object)this.path, (Object)failedToRemoveFiles.path);
                }

                @JvmStatic
                public static final /* synthetic */ void write$Self$tools_api(FailedToRemoveFiles self, CompositeEncoder output2, SerialDescriptor serialDesc) {
                    output2.encodeStringElement(serialDesc, 0, self.path);
                }

                public /* synthetic */ FailedToRemoveFiles(int seen0, String path2, SerializationConstructorMarker serializationConstructorMarker) {
                    if (1 != (1 & seen0)) {
                        PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Reason$Failed$FailedToRemoveFiles$$serializer.INSTANCE.getDescriptor());
                    }
                    this.path = path2;
                }

                public static final class Companion {
                    private Companion() {
                    }

                    @NotNull
                    public final KSerializer<FailedToRemoveFiles> serializer() {
                        return (KSerializer)Reason$Failed$FailedToRemoveFiles$$serializer.INSTANCE;
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Serializable
            public static final class NotEnoughDiskSpace
            implements Failed {
                @NotNull
                public static final Companion Companion = new Companion(null);
                private final long required;
                private final long available;

                public NotEnoughDiskSpace(long required, long available2) {
                    this.required = required;
                    this.available = available2;
                }

                public final long getRequired() {
                    return this.required;
                }

                public final long getAvailable() {
                    return this.available;
                }

                @Override
                @NotNull
                public LocalizableString getExplanation() {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"required", (Object)HumanMemorySizeKt.humanFileSize(this.required, 2)), TuplesKt.to((Object)"available", (Object)HumanMemorySizeKt.humanFileSize(this.available, 2))};
                    return LocalizableStringExKt.trl("Not enough space for tool download, required {{required}}, available {{available}}", pairArray);
                }

                public final long component1() {
                    return this.required;
                }

                public final long component2() {
                    return this.available;
                }

                @NotNull
                public final NotEnoughDiskSpace copy(long required, long available2) {
                    return new NotEnoughDiskSpace(required, available2);
                }

                public static /* synthetic */ NotEnoughDiskSpace copy$default(NotEnoughDiskSpace notEnoughDiskSpace, long l, long l2, int n, Object object) {
                    if ((n & 1) != 0) {
                        l = notEnoughDiskSpace.required;
                    }
                    if ((n & 2) != 0) {
                        l2 = notEnoughDiskSpace.available;
                    }
                    return notEnoughDiskSpace.copy(l, l2);
                }

                @NotNull
                public String toString() {
                    return "NotEnoughDiskSpace(required=" + this.required + ", available=" + this.available + ")";
                }

                public int hashCode() {
                    int result2 = Long.hashCode(this.required);
                    result2 = result2 * 31 + Long.hashCode(this.available);
                    return result2;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof NotEnoughDiskSpace)) {
                        return false;
                    }
                    NotEnoughDiskSpace notEnoughDiskSpace = (NotEnoughDiskSpace)other;
                    if (this.required != notEnoughDiskSpace.required) {
                        return false;
                    }
                    return this.available == notEnoughDiskSpace.available;
                }

                @JvmStatic
                public static final /* synthetic */ void write$Self$tools_api(NotEnoughDiskSpace self, CompositeEncoder output2, SerialDescriptor serialDesc) {
                    output2.encodeLongElement(serialDesc, 0, self.required);
                    output2.encodeLongElement(serialDesc, 1, self.available);
                }

                public /* synthetic */ NotEnoughDiskSpace(int seen0, long required, long available2, SerializationConstructorMarker serializationConstructorMarker) {
                    if (3 != (3 & seen0)) {
                        PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)Reason$Failed$NotEnoughDiskSpace$$serializer.INSTANCE.getDescriptor());
                    }
                    this.required = required;
                    this.available = available2;
                }

                public static final class Companion {
                    private Companion() {
                    }

                    @NotNull
                    public final KSerializer<NotEnoughDiskSpace> serializer() {
                        return (KSerializer)Reason$Failed$NotEnoughDiskSpace$$serializer.INSTANCE;
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Serializable
            public static final class Other
            implements Failed {
                @NotNull
                public static final Companion Companion = new Companion(null);
                @NotNull
                private final String rawError;

                public Other(@NotNull String rawError) {
                    Intrinsics.checkNotNullParameter((Object)rawError, (String)"rawError");
                    this.rawError = rawError;
                }

                @NotNull
                public final String getRawError() {
                    return this.rawError;
                }

                @Override
                @NotNull
                public LocalizableString getExplanation() {
                    return LocalizableStringExKt.notr(this.rawError);
                }

                @NotNull
                public final String component1() {
                    return this.rawError;
                }

                @NotNull
                public final Other copy(@NotNull String rawError) {
                    Intrinsics.checkNotNullParameter((Object)rawError, (String)"rawError");
                    return new Other(rawError);
                }

                public static /* synthetic */ Other copy$default(Other other, String string, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = other.rawError;
                    }
                    return other.copy(string);
                }

                @NotNull
                public String toString() {
                    return "Other(rawError=" + this.rawError + ")";
                }

                public int hashCode() {
                    return this.rawError.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Other)) {
                        return false;
                    }
                    Other other2 = (Other)other;
                    return Intrinsics.areEqual((Object)this.rawError, (Object)other2.rawError);
                }

                @JvmStatic
                public static final /* synthetic */ void write$Self$tools_api(Other self, CompositeEncoder output2, SerialDescriptor serialDesc) {
                    output2.encodeStringElement(serialDesc, 0, self.rawError);
                }

                public /* synthetic */ Other(int seen0, String rawError, SerializationConstructorMarker serializationConstructorMarker) {
                    if (1 != (1 & seen0)) {
                        PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Reason$Failed$Other$$serializer.INSTANCE.getDescriptor());
                    }
                    this.rawError = rawError;
                }

                public static final class Companion {
                    private Companion() {
                    }

                    @NotNull
                    public final KSerializer<Other> serializer() {
                        return (KSerializer)Reason$Failed$Other$$serializer.INSTANCE;
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Serializable
            public static final class ServerError
            implements Failed {
                @NotNull
                public static final Companion Companion = new Companion(null);
                @NotNull
                private final String url;
                @NotNull
                private final String rawError;

                public ServerError(@NotNull String url, @NotNull String rawError) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)rawError, (String)"rawError");
                    this.url = url;
                    this.rawError = rawError;
                }

                @NotNull
                public final String getUrl() {
                    return this.url;
                }

                @NotNull
                public final String getRawError() {
                    return this.rawError;
                }

                @Override
                @NotNull
                public LocalizableString getExplanation() {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"url", (Object)this.url), TuplesKt.to((Object)"reason", (Object)this.rawError)};
                    return LocalizableStringExKt.trl("Downloading from {{url}} failed: {{reason}}", pairArray);
                }

                @NotNull
                public final String component1() {
                    return this.url;
                }

                @NotNull
                public final String component2() {
                    return this.rawError;
                }

                @NotNull
                public final ServerError copy(@NotNull String url, @NotNull String rawError) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)rawError, (String)"rawError");
                    return new ServerError(url, rawError);
                }

                public static /* synthetic */ ServerError copy$default(ServerError serverError, String string, String string2, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = serverError.url;
                    }
                    if ((n & 2) != 0) {
                        string2 = serverError.rawError;
                    }
                    return serverError.copy(string, string2);
                }

                @NotNull
                public String toString() {
                    return "ServerError(url=" + this.url + ", rawError=" + this.rawError + ")";
                }

                public int hashCode() {
                    int result2 = this.url.hashCode();
                    result2 = result2 * 31 + this.rawError.hashCode();
                    return result2;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof ServerError)) {
                        return false;
                    }
                    ServerError serverError = (ServerError)other;
                    if (!Intrinsics.areEqual((Object)this.url, (Object)serverError.url)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.rawError, (Object)serverError.rawError);
                }

                @JvmStatic
                public static final /* synthetic */ void write$Self$tools_api(ServerError self, CompositeEncoder output2, SerialDescriptor serialDesc) {
                    output2.encodeStringElement(serialDesc, 0, self.url);
                    output2.encodeStringElement(serialDesc, 1, self.rawError);
                }

                public /* synthetic */ ServerError(int seen0, String url, String rawError, SerializationConstructorMarker serializationConstructorMarker) {
                    if (3 != (3 & seen0)) {
                        PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)Reason$Failed$ServerError$$serializer.INSTANCE.getDescriptor());
                    }
                    this.url = url;
                    this.rawError = rawError;
                }

                public static final class Companion {
                    private Companion() {
                    }

                    @NotNull
                    public final KSerializer<ServerError> serializer() {
                        return (KSerializer)Reason$Failed$ServerError$$serializer.INSTANCE;
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Serializable
            public static final class VerificationFailed
            implements Failed {
                @NotNull
                public static final VerificationFailed INSTANCE = new VerificationFailed();
                private static final /* synthetic */ Lazy<KSerializer<Object>> $cachedSerializer$delegate;

                private VerificationFailed() {
                }

                @Override
                @NotNull
                public LocalizableString getExplanation() {
                    return LocalizableStringExKt.trl("Verification failed");
                }

                @NotNull
                public final KSerializer<VerificationFailed> serializer() {
                    return this.get$cachedSerializer();
                }

                @NotNull
                public String toString() {
                    return "VerificationFailed";
                }

                public int hashCode() {
                    return -1847007857;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof VerificationFailed)) {
                        return false;
                    }
                    VerificationFailed cfr_ignored_0 = (VerificationFailed)other;
                    return true;
                }

                private final /* synthetic */ KSerializer get$cachedSerializer() {
                    return (KSerializer)$cachedSerializer$delegate.getValue();
                }

                static {
                    $cachedSerializer$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ObjectSerializer("com.jetbrains.toolbox.tools.model.FailedUpdate.Reason.Failed.VerificationFailed", (Object)INSTANCE, new Annotation[0]));
                }
            }
        }
    }
}

