/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.model;

import com.jetbrains.toolbox.tools.model.ProductInfo;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DetectedToolInstance {
    @NotNull
    private final Path installationDirectory;
    @NotNull
    private final ProductInfo productInfo;
    @Nullable
    private final Path iconPath;

    public DetectedToolInstance(@NotNull Path installationDirectory, @NotNull ProductInfo productInfo, @Nullable Path iconPath) {
        Intrinsics.checkNotNullParameter((Object)installationDirectory, (String)"installationDirectory");
        Intrinsics.checkNotNullParameter((Object)productInfo, (String)"productInfo");
        this.installationDirectory = installationDirectory;
        this.productInfo = productInfo;
        this.iconPath = iconPath;
    }

    @NotNull
    public final Path getInstallationDirectory() {
        return this.installationDirectory;
    }

    @NotNull
    public final ProductInfo getProductInfo() {
        return this.productInfo;
    }

    @Nullable
    public final Path getIconPath() {
        return this.iconPath;
    }

    @NotNull
    public final Path component1() {
        return this.installationDirectory;
    }

    @NotNull
    public final ProductInfo component2() {
        return this.productInfo;
    }

    @Nullable
    public final Path component3() {
        return this.iconPath;
    }

    @NotNull
    public final DetectedToolInstance copy(@NotNull Path installationDirectory, @NotNull ProductInfo productInfo, @Nullable Path iconPath) {
        Intrinsics.checkNotNullParameter((Object)installationDirectory, (String)"installationDirectory");
        Intrinsics.checkNotNullParameter((Object)productInfo, (String)"productInfo");
        return new DetectedToolInstance(installationDirectory, productInfo, iconPath);
    }

    public static /* synthetic */ DetectedToolInstance copy$default(DetectedToolInstance detectedToolInstance, Path path2, ProductInfo productInfo, Path path3, int n, Object object) {
        if ((n & 1) != 0) {
            path2 = detectedToolInstance.installationDirectory;
        }
        if ((n & 2) != 0) {
            productInfo = detectedToolInstance.productInfo;
        }
        if ((n & 4) != 0) {
            path3 = detectedToolInstance.iconPath;
        }
        return detectedToolInstance.copy(path2, productInfo, path3);
    }

    @NotNull
    public String toString() {
        return "DetectedToolInstance(installationDirectory=" + this.installationDirectory + ", productInfo=" + this.productInfo + ", iconPath=" + this.iconPath + ")";
    }

    public int hashCode() {
        int result2 = this.installationDirectory.hashCode();
        result2 = result2 * 31 + this.productInfo.hashCode();
        result2 = result2 * 31 + (this.iconPath == null ? 0 : this.iconPath.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DetectedToolInstance)) {
            return false;
        }
        DetectedToolInstance detectedToolInstance = (DetectedToolInstance)other;
        if (!Intrinsics.areEqual((Object)this.installationDirectory, (Object)detectedToolInstance.installationDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.productInfo, (Object)detectedToolInstance.productInfo)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.iconPath, (Object)detectedToolInstance.iconPath);
    }

    public static final class Factory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }
    }
}

