/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.launcher;

import com.jetbrains.toolbox.ErrorsHelperKt;
import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.tools.launcher.ProcessLauncher;
import com.jetbrains.toolbox.tools.launcher.ProcessParameters;
import com.jetbrains.toolbox.tools.launcher.ToolParameters;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.tinylog.kotlin.Logger;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nWindowsProcessLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsProcessLauncher.kt\ncom/jetbrains/toolbox/tools/launcher/WindowsProcessLauncher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n774#2:44\n865#2,2:45\n*S KotlinDebug\n*F\n+ 1 WindowsProcessLauncher.kt\ncom/jetbrains/toolbox/tools/launcher/WindowsProcessLauncher\n*L\n30#1:44\n30#1:45,2\n*E\n"})
public final class WindowsProcessLauncher
extends ProcessLauncher {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final ProcessRunner processes;

    public WindowsProcessLauncher(@NotNull FileSystem fileSystem, @NotNull ProcessRunner processes) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)processes, (String)"processes");
        this.fileSystem = fileSystem;
        this.processes = processes;
    }

    @Override
    @NotNull
    public ProcessRunner getProcesses() {
        return this.processes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ProcessHandle launch(@NotNull ToolParameters toolParameters, @NotNull ProcessParameters processParameters) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)toolParameters, (String)"toolParameters");
        Intrinsics.checkNotNullParameter((Object)processParameters, (String)"processParameters");
        ThreadGuardKt.assertNotMainThread("java.io.File.canonicalPath");
        Path command2 = toolParameters.getCommand();
        if (command2 != null) {
            return ProcessLauncher.executeProcess$default(this, new File(command2.toFile().getCanonicalPath()), ProcessParameters.copy$default(processParameters, CollectionsKt.plus((Collection)toolParameters.getArguments(), (Iterable)processParameters.getArguments()), false, false, null, null, null, null, 126, null), null, 4, null);
        }
        Path installationFolder = toolParameters.getInstallationDirectory();
        if (!this.fileSystem.exists(installationFolder)) {
            ErrorsHelperKt.errorResult$default("Application directory not found: " + installationFolder, null, 2, null);
            throw new KotlinNothingValueException();
        }
        Iterable $this$filter$iv = this.fileSystem.list(installationFolder);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path path2 = (Path)element$iv$iv;
            boolean bl = false;
            String string = path2.toFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".exe", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List contents = (List)destination$iv$iv;
        if (contents.size() != 1) {
            String error2 = "Too many .exe files: " + CollectionsKt.joinToString$default((Iterable)contents, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            Logger.INSTANCE.debug(error2);
            ErrorsHelperKt.errorResult$default(error2, null, 2, null);
            throw new KotlinNothingValueException();
        }
        Path executablePath = (Path)CollectionsKt.first((List)contents);
        Logger.INSTANCE.debug("Found executable: " + executablePath);
        return ProcessLauncher.executeProcess$default(this, executablePath.toFile(), ProcessParameters.copy$default(processParameters, CollectionsKt.plus((Collection)toolParameters.getArguments(), (Iterable)processParameters.getArguments()), false, false, null, null, null, null, 126, null), null, 4, null);
    }
}

