/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.launcher;

import com.jetbrains.toolbox.ErrorsHelperKt;
import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.interop.PlistResolver;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.tools.launcher.ProcessLauncher;
import com.jetbrains.toolbox.tools.launcher.ProcessParameters;
import com.jetbrains.toolbox.tools.launcher.ToolParameters;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class MacOSProcessLauncher
extends ProcessLauncher {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final PlistResolver pListHelper;
    @NotNull
    private final ProcessRunner processes;

    public MacOSProcessLauncher(@NotNull FileSystem fileSystem, @NotNull PlistResolver pListHelper, @NotNull ProcessRunner processes) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)pListHelper, (String)"pListHelper");
        Intrinsics.checkNotNullParameter((Object)processes, (String)"processes");
        this.fileSystem = fileSystem;
        this.pListHelper = pListHelper;
        this.processes = processes;
    }

    @Override
    @NotNull
    public ProcessRunner getProcesses() {
        return this.processes;
    }

    @Override
    @Nullable
    public ProcessHandle launch(@NotNull ToolParameters toolParameters, @NotNull ProcessParameters processParameters) {
        Path command2;
        Path executable;
        Intrinsics.checkNotNullParameter((Object)toolParameters, (String)"toolParameters");
        Intrinsics.checkNotNullParameter((Object)processParameters, (String)"processParameters");
        Path installationFolder = toolParameters.getInstallationDirectory();
        if (!this.fileSystem.exists(installationFolder)) {
            ErrorsHelperKt.errorResult$default("Application directory not found: " + installationFolder, null, 2, null);
            throw new KotlinNothingValueException();
        }
        List<String> toolArguments = toolParameters.getArguments();
        List<String> processArguments = processParameters.getArguments();
        if (processParameters.getBackground() && (executable = this.pListHelper.resolveExecutablePath(installationFolder)) != null) {
            List allArguments = !((Collection)processArguments).isEmpty() ? CollectionsKt.plus((Collection)toolArguments, (Iterable)processArguments) : CollectionsKt.emptyList();
            return ProcessLauncher.executeProcess$default(this, executable.toFile(), ProcessParameters.copy$default(processParameters, allArguments, false, false, null, null, null, null, 126, null), null, 4, null);
        }
        if (!Intrinsics.areEqual((Object)FileSystemExtKt.getMacAppUnderDirectory(this.fileSystem, installationFolder), (Object)installationFolder) && (command2 = toolParameters.getCommand()) != null) {
            File executable2 = this.getExecutable(command2, installationFolder);
            return ProcessLauncher.executeProcess$default(this, executable2, ProcessParameters.copy$default(processParameters, CollectionsKt.plus((Collection)toolArguments, (Iterable)processArguments), false, false, null, null, null, null, 126, null), null, 4, null);
        }
        return ProcessLauncher.executeProcess$default(this, new File("/usr/bin/open"), ProcessParameters.copy$default(processParameters, this.arguments(installationFolder.toFile(), processArguments, toolArguments), false, false, null, null, null, null, 126, null), null, 4, null);
    }

    private final File getExecutable(Path commandPath, Path installPath) {
        File file;
        File file2;
        if (this.fileSystem.exists(commandPath)) {
            file2 = commandPath.toFile();
        } else {
            Path path2 = this.pListHelper.resolveExecutablePath(installPath);
            file2 = file = path2 != null ? path2.toFile() : null;
        }
        if (file2 == null) {
            file = commandPath.toFile();
        }
        return file;
    }

    private final List<String> arguments(File appDirectory, List<String> processArguments, List<String> toolArguments) {
        ThreadGuardKt.assertNotMainThread("java.io.File.canonicalPath");
        Object[] objectArray = new String[]{"-n", appDirectory.getCanonicalPath()};
        List allArguments = CollectionsKt.mutableListOf((Object[])objectArray);
        if (!((Collection)processArguments).isEmpty() || !((Collection)toolArguments).isEmpty()) {
            ((Collection)allArguments).add("--args");
            allArguments.addAll((Collection)toolArguments);
            allArguments.addAll((Collection)processArguments);
        }
        return allArguments;
    }
}

