/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools;

import com.jetbrains.toolbox.tools.HasCustomName;
import com.jetbrains.toolbox.tools.InstallLocation;
import com.jetbrains.toolbox.tools.IntelliJOptions;
import com.jetbrains.toolbox.tools.LockableValue;
import com.jetbrains.toolbox.tools.ShellScript;
import com.jetbrains.toolbox.tools.UpdateOption;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolSettings
implements HasCustomName {
    @NotNull
    private final String title;
    @NotNull
    private final LockableValue<Boolean> installUpdateAutomatically;
    @Nullable
    private final String customName;
    @NotNull
    private final List<UpdateOption> updateToOptions;
    private final int selectedUpdateToOption;
    private final boolean keepUsingVersionToggle;
    @Nullable
    private final String keepUsingVersionName;
    @NotNull
    private final InstallLocation installLocation;
    @Nullable
    private final Boolean runInSplitMode;
    @Nullable
    private final IntelliJOptions intelliJOptions;
    @Nullable
    private final ShellScript shellLauncher;

    public ToolSettings(@NotNull String title2, @NotNull LockableValue<Boolean> installUpdateAutomatically, @Nullable String customName, @NotNull List<UpdateOption> updateToOptions, int selectedUpdateToOption, boolean keepUsingVersionToggle, @Nullable String keepUsingVersionName, @NotNull InstallLocation installLocation, @Nullable Boolean runInSplitMode, @Nullable IntelliJOptions intelliJOptions, @Nullable ShellScript shellLauncher) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter(installUpdateAutomatically, (String)"installUpdateAutomatically");
        Intrinsics.checkNotNullParameter(updateToOptions, (String)"updateToOptions");
        Intrinsics.checkNotNullParameter((Object)installLocation, (String)"installLocation");
        this.title = title2;
        this.installUpdateAutomatically = installUpdateAutomatically;
        this.customName = customName;
        this.updateToOptions = updateToOptions;
        this.selectedUpdateToOption = selectedUpdateToOption;
        this.keepUsingVersionToggle = keepUsingVersionToggle;
        this.keepUsingVersionName = keepUsingVersionName;
        this.installLocation = installLocation;
        this.runInSplitMode = runInSplitMode;
        this.intelliJOptions = intelliJOptions;
        this.shellLauncher = shellLauncher;
    }

    @NotNull
    public final LockableValue<Boolean> getInstallUpdateAutomatically() {
        return this.installUpdateAutomatically;
    }

    @Override
    @Nullable
    public String getCustomName() {
        return this.customName;
    }

    @NotNull
    public final List<UpdateOption> getUpdateToOptions() {
        return this.updateToOptions;
    }

    public final int getSelectedUpdateToOption() {
        return this.selectedUpdateToOption;
    }

    public final boolean getKeepUsingVersionToggle() {
        return this.keepUsingVersionToggle;
    }

    @Nullable
    public final String getKeepUsingVersionName() {
        return this.keepUsingVersionName;
    }

    @NotNull
    public final InstallLocation getInstallLocation() {
        return this.installLocation;
    }

    @Nullable
    public final Boolean getRunInSplitMode() {
        return this.runInSplitMode;
    }

    @Nullable
    public final IntelliJOptions getIntelliJOptions() {
        return this.intelliJOptions;
    }

    @Nullable
    public final ShellScript getShellLauncher() {
        return this.shellLauncher;
    }

    @NotNull
    public String toString() {
        return "ToolSettings(title=" + this.title + ", installUpdateAutomatically=" + this.installUpdateAutomatically + ", customName=" + this.customName + ", updateToOptions=" + this.updateToOptions + ", selectedUpdateToOption=" + this.selectedUpdateToOption + ", keepUsingVersionToggle=" + this.keepUsingVersionToggle + ", keepUsingVersionName=" + this.keepUsingVersionName + ", installLocation=" + this.installLocation + ", runInSplitMode=" + this.runInSplitMode + ", intelliJOptions=" + this.intelliJOptions + ", shellLauncher=" + this.shellLauncher + ")";
    }

    public int hashCode() {
        int result2 = this.title.hashCode();
        result2 = result2 * 31 + this.installUpdateAutomatically.hashCode();
        result2 = result2 * 31 + (this.customName == null ? 0 : this.customName.hashCode());
        result2 = result2 * 31 + ((Object)this.updateToOptions).hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.selectedUpdateToOption);
        result2 = result2 * 31 + Boolean.hashCode(this.keepUsingVersionToggle);
        result2 = result2 * 31 + (this.keepUsingVersionName == null ? 0 : this.keepUsingVersionName.hashCode());
        result2 = result2 * 31 + this.installLocation.hashCode();
        result2 = result2 * 31 + (this.runInSplitMode == null ? 0 : ((Object)this.runInSplitMode).hashCode());
        result2 = result2 * 31 + (this.intelliJOptions == null ? 0 : this.intelliJOptions.hashCode());
        result2 = result2 * 31 + (this.shellLauncher == null ? 0 : this.shellLauncher.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ToolSettings)) {
            return false;
        }
        ToolSettings toolSettings = (ToolSettings)other;
        if (!Intrinsics.areEqual((Object)this.title, (Object)toolSettings.title)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.installUpdateAutomatically, toolSettings.installUpdateAutomatically)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.customName, (Object)toolSettings.customName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.updateToOptions, toolSettings.updateToOptions)) {
            return false;
        }
        if (this.selectedUpdateToOption != toolSettings.selectedUpdateToOption) {
            return false;
        }
        if (this.keepUsingVersionToggle != toolSettings.keepUsingVersionToggle) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.keepUsingVersionName, (Object)toolSettings.keepUsingVersionName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.installLocation, (Object)toolSettings.installLocation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.runInSplitMode, (Object)toolSettings.runInSplitMode)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.intelliJOptions, (Object)toolSettings.intelliJOptions)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.shellLauncher, (Object)toolSettings.shellLauncher);
    }
}

