/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools;

import com.intellij.station.comms.common.services.IdeProtocolHandlerRequest;
import com.intellij.station.comms.common.services.IdeProtocolHandlerResponse;
import com.intellij.station.comms.common.services.IdeProtocolHandlerService;
import com.intellij.station.comms.common.services.RequestFocusMetaInfo;
import com.jetbrains.fus.reporting.lion3.FeatureUsageLogger;
import com.jetbrains.toolbox.common.RateLimiter;
import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import com.jetbrains.toolbox.common.extensions.URIExtensionsKt;
import com.jetbrains.toolbox.feed.Activation;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.fus.FusFieldDescriptions;
import com.jetbrains.toolbox.interop.Pid;
import com.jetbrains.toolbox.project.FileSystemProject;
import com.jetbrains.toolbox.project.InstalledToolOpenProject;
import com.jetbrains.toolbox.project.LaunchMethod;
import com.jetbrains.toolbox.project.LinkedProject;
import com.jetbrains.toolbox.project.ProjectManager;
import com.jetbrains.toolbox.project.VcsRepository;
import com.jetbrains.toolbox.protocolhandler.ProtocolHandler;
import com.jetbrains.toolbox.station.comms.services.IdeConnection;
import com.jetbrains.toolbox.station.comms.services.StationServicesClientProvider;
import com.jetbrains.toolbox.station.comms.services.StationServicesClientToIde;
import com.jetbrains.toolbox.tools.ToolManagerProtocolHandler;
import com.jetbrains.toolbox.tools.ToolProcessManager;
import com.jetbrains.toolbox.tools.launcher.ProcessLauncher;
import com.jetbrains.toolbox.tools.launcher.ProcessParameters;
import com.jetbrains.toolbox.tools.launcher.ToolParameters;
import com.jetbrains.toolbox.tools.model.AvailableTools;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.ChannelStateKt;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.ProjectId;
import com.jetbrains.toolbox.tools.model.State;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolProcess;
import com.jetbrains.toolbox.tools.model.ToolProcessState;
import com.jetbrains.toolbox.tools.model.ToolWithVersions;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nToolManagerProtocolHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolManagerProtocolHandler.kt\ncom/jetbrains/toolbox/tools/ToolManagerProtocolHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,393:1\n188#2,3:394\n126#2:481\n153#2,3:482\n808#3,11:397\n774#3:408\n865#3,2:409\n1374#3:411\n1460#3,2:412\n808#3,11:414\n1563#3:425\n1634#3,3:426\n1462#3,3:429\n808#3,11:432\n808#3,11:443\n774#3:454\n865#3,2:455\n1563#3:457\n1634#3,3:458\n774#3:461\n865#3:462\n1761#3,3:463\n866#3:466\n1563#3:467\n1634#3,3:468\n295#3,2:471\n1#4:473\n536#5:474\n521#5,6:475\n*S KotlinDebug\n*F\n+ 1 ToolManagerProtocolHandler.kt\ncom/jetbrains/toolbox/tools/ToolManagerProtocolHandler\n*L\n57#1:394,3\n380#1:481\n380#1:482,3\n114#1:397,11\n114#1:408\n114#1:409,2\n116#1:411\n116#1:412,2\n118#1:414,11\n119#1:425\n119#1:426,3\n116#1:429,3\n122#1:432,11\n125#1:443,11\n126#1:454\n126#1:455,2\n148#1:457\n148#1:458,3\n150#1:461\n150#1:462\n154#1:463,3\n150#1:466\n188#1:467\n188#1:468,3\n189#1:471,2\n378#1:474\n378#1:475,6\n*E\n"})
public final class ToolManagerProtocolHandler
implements ProtocolHandler {
    @NotNull
    private final ProcessLauncher processLauncher;
    @NotNull
    private final StateFlow<Map<ChannelId, ChannelState>> tools;
    @NotNull
    private final StateFlow<AvailableTools> availableTools;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final RateLimiter rateLimiter;
    @NotNull
    private final FeatureUsageLogger fusLogger;
    @NotNull
    private final ToolProcessManager toolProcessManager;
    @NotNull
    private final StationServicesClientProvider stationClientProvider;
    @NotNull
    private final String toolSuffix;

    public ToolManagerProtocolHandler(@NotNull ProcessLauncher processLauncher, @NotNull StateFlow<? extends Map<ChannelId, ? extends ChannelState>> tools2, @NotNull StateFlow<AvailableTools> availableTools2, @NotNull ProjectManager projectManager, @NotNull RateLimiter rateLimiter, @NotNull FeatureUsageLogger fusLogger, @NotNull ToolProcessManager toolProcessManager, @NotNull StationServicesClientProvider stationClientProvider) {
        Intrinsics.checkNotNullParameter((Object)processLauncher, (String)"processLauncher");
        Intrinsics.checkNotNullParameter(tools2, (String)"tools");
        Intrinsics.checkNotNullParameter(availableTools2, (String)"availableTools");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)rateLimiter, (String)"rateLimiter");
        Intrinsics.checkNotNullParameter((Object)fusLogger, (String)"fusLogger");
        Intrinsics.checkNotNullParameter((Object)toolProcessManager, (String)"toolProcessManager");
        Intrinsics.checkNotNullParameter((Object)stationClientProvider, (String)"stationClientProvider");
        this.processLauncher = processLauncher;
        this.tools = tools2;
        this.availableTools = availableTools2;
        this.projectManager = projectManager;
        this.rateLimiter = rateLimiter;
        this.fusLogger = fusLogger;
        this.toolProcessManager = toolProcessManager;
        this.stationClientProvider = stationClientProvider;
        this.toolSuffix = ".tool";
    }

    @Override
    public boolean canHandle(@NotNull URI uri) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            if (Intrinsics.areEqual((Object)uri.getHost(), (Object)"fleet")) {
                return false;
            }
            String string = uri.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            if (this.asChannelId-73xg5Po(string) != null) {
                return true;
            }
            Map<ApplicationType, ToolWithVersions> $this$any$iv = ((AvailableTools)this.availableTools.getValue()).getTools();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<ApplicationType, ToolWithVersions>> iterator2 = $this$any$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<ApplicationType, ToolWithVersions> element$iv;
                    Map.Entry<ApplicationType, ToolWithVersions> it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Activation activation = it.getValue().getTool().getActivation();
                    List<String> hosts = activation != null ? activation.getHosts() : null;
                    if (!(hosts != null && hosts.contains(uri.getHost()))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String asChannelId-73xg5Po(String $this$asChannelId_u2d73xg5Po) {
        if (!StringsKt.endsWith$default((String)$this$asChannelId_u2d73xg5Po, (String)this.toolSuffix, (boolean)false, (int)2, null)) {
            return null;
        }
        String id = ChannelId.constructor-impl(StringsKt.removeSuffix((String)$this$asChannelId_u2d73xg5Po, (CharSequence)this.toolSuffix));
        return ((Map)this.tools.getValue()).keySet().contains(ChannelId.box-impl(id)) ? id : null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object handle(@NotNull URI uri, @NotNull Continuation<? super Unit> $completion) {
        block13: {
            block12: {
                if (!this.rateLimiter.ensureRateLimit()) {
                    Logger.INSTANCE.debug("Suspiciously frequent call of JB protocol usage. Ignoring " + uri);
                    return Unit.INSTANCE;
                }
                v0 = uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPath(...)");
                var4_3 = new String[]{"/"};
                path = StringsKt.split$default((CharSequence)v0, (String[])var4_3, (boolean)false, (int)0, (int)6, null);
                command = (String)CollectionsKt.getOrNull((List)path, (int)1);
                if (command == null) break block12;
                switch (command.hashCode()) {
                    case 2102494577: {
                        if (!command.equals("navigate")) {
                            ** break;
                        }
                        ** GOTO lbl24
                    }
                    case 1427818632: {
                        if (command.equals("download")) break;
                        ** break;
                    }
                    case -1331673466: {
                        if (!command.equals("diogen")) {
                            ** break;
                        }
                        ** GOTO lbl24
                    }
                    case 1536904518: {
                        if (!command.equals("checkout")) ** break;
lbl24:
                        // 3 sources

                        v1 = this.handleProject(uri, command, $completion);
                        if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            return v1;
                        }
                        return Unit.INSTANCE;
                    }
                }
                this.handleMatterhorn(uri);
                break block13;
            }
            if ((tool = this.getToolByURL(uri)) != null) {
                var6_6 = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)uri.toString(), (String)"toString(...)");
                Boxing.boxBoolean((boolean)this.handleDefault(tool, var6_6));
            } else {
                Logger.INSTANCE.warn("Couldn't find a tool to handle '" + uri + "', and no special handling is available");
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileSystemProject> filterProjects(Map<String, String> query2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterIsInstance$iv2;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv2;
        void $this$filterIsInstanceTo$iv$iv3;
        String remoteUrl = query2.get("checkout.repo");
        String projectName = query2.get("project");
        ProjectManager.Model knownProjects = (ProjectManager.Model)this.projectManager.getState().getValue();
        Iterable $this$filterIsInstance$iv3 = knownProjects.getProjects();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv3;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
            if (!(element$iv$iv instanceof VcsRepository)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv3 = (List)destination$iv$iv;
        boolean $i$f$filter22 = false;
        $this$filterIsInstanceTo$iv$iv3 = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            VcsRepository it = (VcsRepository)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getCloneUrl().toString(), (Object)remoteUrl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List vcsProjects = (List)destination$iv$iv;
        Iterable $i$f$filter22 = vcsProjects;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            VcsRepository repo = (VcsRepository)element$iv$iv;
            boolean bl = false;
            Collection<LinkedProject> collection = knownProjects.getLinkedProjects().get(ProjectId.box-impl(repo.getId-kZr3Ip4()));
            if (collection != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterIsInstanceTo$iv$iv4;
                void $this$filterIsInstance$iv4;
                Iterable iterable2 = collection;
                boolean $i$f$filterIsInstance22 = false;
                void var19_34 = $this$filterIsInstance$iv4;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv4) {
                    if (!(element$iv$iv2 instanceof LinkedProject.IsVcsRoot)) continue;
                    destination$iv$iv3.add(element$iv$iv2);
                }
                Iterable $i$f$filterIsInstance22 = (List)destination$iv$iv3;
                boolean $i$f$map = false;
                destination$iv$iv3 = $this$map$iv;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LinkedProject.IsVcsRoot isVcsRoot = (LinkedProject.IsVcsRoot)item$iv$iv;
                    Collection collection2 = destination$iv$iv4;
                    boolean bl2 = false;
                    collection2.add(knownProjects.get-CD0_5dk(it.getProjectId-kZr3Ip4()));
                }
                list2 = (List)destination$iv$iv4;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$filterIsInstance32 = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstance$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo3 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof FileSystemProject)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List matchedVcsProjects = (List)destination$iv$iv2;
        Iterable $i$f$filterIsInstance32 = knownProjects.getProjects();
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterIsInstanceTo4 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FileSystemProject)) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv5;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileSystemProject it = (FileSystemProject)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)projectName)) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        List matchedNamedProjects = (List)destination$iv$iv5;
        return CollectionsKt.plus((Collection)matchedVcsProjects, (Iterable)matchedNamedProjects);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object findProcessOrProject(Map<String, String> query, Continuation<? super Pair<FileSystemProject, IdeConnection>> $completion) {
        processes = (Set)this.toolProcessManager.getProcesses().getValue();
        matchedProjects = this.filterProjects(query);
        $this$map$iv = matchedProjects;
        $i$f$map = false;
        var8_8 = $this$map$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var13_16 = (FileSystemProject)item$iv$iv;
            var23_19 = destination$iv$iv /* !! */ ;
            $i$a$-map-ToolManagerProtocolHandler$findProcessOrProject$matchedProjectIds$1 = false;
            var23_19.add(ProjectId.box-impl(it.getId-kZr3Ip4()));
        }
        matchedProjectIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv /* !! */ ));
        $this$filter$iv = processes;
        $i$f$filter = false;
        destination$iv$iv /* !! */  = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block15: {
                process = (ToolProcess)element$iv$iv;
                $i$a$-filter-ToolManagerProtocolHandler$findProcessOrProject$matchedProcesses$1 = false;
                status = (ToolProcessState)process.getState().getValue();
                if (!(status instanceof ToolProcessState.MaybeHasConnection) || !(status instanceof ToolProcessState.HasProjects)) ** GOTO lbl-1000
                $this$any$iv = ((ToolProcessState.HasProjects)status).getProjects();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = ((ProjectId)element$iv).unbox-impl();
                        $i$a$-any-ToolManagerProtocolHandler$findProcessOrProject$matchedProcesses$1$1 = false;
                        if (!matchedProjectIds.contains(ProjectId.box-impl(it))) continue;
                        v0 = true;
                        break block15;
                    }
                    v0 = false;
                }
            }
            if (!v0) ** GOTO lbl-1000
            v1 = ((ToolProcessState.MaybeHasConnection)status).getConnection();
            if (v1 != null ? v1.supports(IdeProtocolHandlerService.INSTANCE) : false) {
                v2 = true;
            } else lbl-1000:
            // 3 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        matchedProcesses = (List)destination$iv$iv;
        block0 : switch (matchedProcesses.size()) {
            case 0: {
                switch (matchedProjectIds.size()) {
                    case 0: {
                        v3 = TuplesKt.to(null, null);
                        break block0;
                    }
                    case 1: {
                        v3 = TuplesKt.to((Object)matchedProjects.get(0), null);
                        break block0;
                    }
                }
                v3 = TuplesKt.to((Object)matchedProjects.get(0), null);
                break;
            }
            case 1: {
                var9_10 = ((ToolProcess)matchedProcesses.get(0)).getState().getValue();
                v4 = var9_10 instanceof ToolProcessState.MaybeHasConnection != false ? (ToolProcessState.MaybeHasConnection)var9_10 : null;
                v3 = TuplesKt.to(null, (Object)(v4 != null ? v4.getConnection() : null));
                break;
            }
            default: {
                var9_10 = ((ToolProcess)matchedProcesses.get(0)).getState().getValue();
                v5 = var9_10 instanceof ToolProcessState.MaybeHasConnection != false ? (ToolProcessState.MaybeHasConnection)var9_10 : null;
                v3 = TuplesKt.to(null, (Object)(v5 != null ? v5.getConnection() : null));
            }
        }
        return v3;
    }

    /*
     * Unable to fully structure code
     */
    private final Object openViaIdeConnection(URI uri, Map<String, String> query, IdeConnection connection, String command, Pair<ChannelId, ToolInstance> exactTool, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof openViaIdeConnection.1)) ** GOTO lbl-1000
        var21_7 = $completion;
        if ((var21_7.label & -2147483648) != 0) {
            var21_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                /* synthetic */ Object result;
                final /* synthetic */ ToolManagerProtocolHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ToolManagerProtocolHandler.access$openViaIdeConnection(this.this$0, null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var22_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = uri;
                $continuation.L$1 = query;
                $continuation.L$2 = connection;
                $continuation.L$3 = command;
                $continuation.L$4 = exactTool;
                $continuation.label = 1;
                v0 = this.toolProcessManager.findByPid-4PZGNJc(Pid.constructor-impl(connection.getPid()), (Continuation<? super ToolProcess>)$continuation);
                if (v0 == var22_9) {
                    return var22_9;
                }
                ** GOTO lbl30
            }
            case 1: {
                exactTool = (Pair)$continuation.L$4;
                command = (String)$continuation.L$3;
                connection = (IdeConnection)$continuation.L$2;
                query = (Map)$continuation.L$1;
                uri = (URI)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                v1 = (v2 = (StateFlow<ToolProcessState>)v0) != null && (v2 = v2.getState()) != null ? (ToolProcessState)v2.getValue() : (status = null);
                if (exactTool != null && status instanceof ToolProcessState.MaybeHasChannelId) {
                    var8_13 = ((ToolProcessState.MaybeHasChannelId)status).getChannelId-5lgeRk0();
                    var9_16 = ((ChannelId)exactTool.getFirst()).unbox-impl();
                    v3 = var8_13;
                    if (!(v3 == null ? false : ChannelId.equals-impl0(v3, var9_16))) {
                        v4 = ((ToolProcessState.MaybeHasChannelId)status).getChannelId-5lgeRk0();
                        Logger.INSTANCE.info("Requested channel ID " + ChannelId.toString-impl(((ChannelId)exactTool.getFirst()).unbox-impl()) + " doesn't match the channel ID of running tool " + (v4 == null ? "null" : ChannelId.toString-impl(v4)) + ", will use the running tool");
                    }
                }
                client = this.stationClientProvider.clientFor(connection);
                $this$map$iv = this.filterProjects(query);
                $i$f$map = false;
                var12_25 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var17_32 = (FileSystemProject)item$iv$iv;
                    var19_34 = destination$iv$iv;
                    $i$a$-map-ToolManagerProtocolHandler$openViaIdeConnection$projects$1 = false;
                    var19_34.add(ProjectId.box-impl(it.getId-kZr3Ip4()));
                }
                projects = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                v5 = status instanceof ToolProcessState.HasProjects != false ? (ToolProcessState.HasProjects)status : null;
                if (v5 == null || (v5 = v5.getProjects()) == null) ** GOTO lbl66
                $this$firstOrNull$iv = (Iterable)v5;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = ((ProjectId)element$iv).unbox-impl();
                    $i$a$-firstOrNull-ToolManagerProtocolHandler$openViaIdeConnection$projectInProcess$1 = false;
                    if (!projects.contains(ProjectId.box-impl(it))) continue;
                    v6 = element$iv;
                    ** GOTO lbl63
                }
                v6 = null;
lbl63:
                // 2 sources

                v7 = v6;
                v8 = v7 != null ? v7.unbox-impl() : null;
                ** GOTO lbl67
lbl66:
                // 1 sources

                v8 = projectInProcess = null;
lbl67:
                // 2 sources

                if (!Intrinsics.areEqual((Object)command, (Object)"checkout") || !client.supports(RequestFocusMetaInfo.INSTANCE) || projectInProcess == null) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)uri);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)connection);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)exactTool);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)status);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)projects);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)projectInProcess);
                $continuation.label = 2;
                v9 = client.request(RequestFocusMetaInfo.INSTANCE, new RequestFocusMetaInfo.FocusRequest(true, projectInProcess), $continuation);
                if (v9 == var22_9) {
                    return var22_9;
                }
                ** GOTO lbl94
            }
            case 2: {
                projectInProcess = (String)$continuation.L$8;
                projects = (Set)$continuation.L$7;
                client = (StationServicesClientToIde)$continuation.L$6;
                status = (ToolProcessState)$continuation.L$5;
                exactTool = (Pair)$continuation.L$4;
                command = (String)$continuation.L$3;
                connection = (IdeConnection)$continuation.L$2;
                query = (Map)$continuation.L$1;
                uri = (URI)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v9 = $result;
lbl94:
                // 2 sources

                response = (RequestFocusMetaInfo.FocusResponse)v9;
                v10 = response.getSuccess();
                ** GOTO lbl134
            }
        }
        v11 = IdeProtocolHandlerService.INSTANCE;
        v12 = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"toString(...)");
        $continuation.L$0 = uri;
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)query);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)connection);
        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)command);
        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)exactTool);
        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)status);
        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)client);
        $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)projects);
        $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)projectInProcess);
        $continuation.label = 3;
        v13 = client.request(v11, new IdeProtocolHandlerRequest(v12), $continuation);
        if (v13 == var22_9) {
            return var22_9;
        }
        ** GOTO lbl126
        {
            case 3: {
                projectInProcess = (String)$continuation.L$8;
                projects = (Set)$continuation.L$7;
                client = (StationServicesClientToIde)$continuation.L$6;
                status = (ToolProcessState)$continuation.L$5;
                exactTool = (Pair)$continuation.L$4;
                command = (String)$continuation.L$3;
                connection = (IdeConnection)$continuation.L$2;
                query = (Map)$continuation.L$1;
                uri = (URI)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v13 = $result;
lbl126:
                // 2 sources

                result = (response = (IdeProtocolHandlerResponse)v13).getExitCode() == 0;
                v14 = response.getMessage();
                if (v14 != null) {
                    it = v14;
                    $i$a$-let-ToolManagerProtocolHandler$openViaIdeConnection$2 = false;
                    Logger.INSTANCE.info("URL open for " + uri + ": IDE says " + it);
                }
                v10 = result != false;
lbl134:
                // 2 sources

                return Boxing.boxBoolean((boolean)v10);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean openViaCommandLine(Pair<ChannelId, ToolInstance> toolToUseBasedOnProject, String command2, FileSystemProject project2, URI uri) {
        if (toolToUseBasedOnProject != null) {
            boolean bl;
            if (Intrinsics.areEqual((Object)command2, (Object)"checkout")) {
                String[] stringArray = new String[]{project2.getPath().toString()};
                bl = this.handleDefault((ToolInstance)toolToUseBasedOnProject.getSecond(), stringArray);
            } else {
                ToolInstance toolInstance = (ToolInstance)toolToUseBasedOnProject.getSecond();
                String[] stringArray = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)uri.toString(), (String)"toString(...)");
                bl = this.handleDefault(toolInstance, stringArray);
            }
            return bl;
        }
        Logger.INSTANCE.info("No tool found to open " + uri + " (existing project open)");
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final Object tryFindIdeConnection-R5oYZt4(String channelId, Continuation<? super IdeConnection> $completion) {
        if (!($completion instanceof tryFindIdeConnection.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ToolManagerProtocolHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ToolManagerProtocolHandler.access$tryFindIdeConnection-R5oYZt4(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = channelId;
                $continuation.label = 1;
                v0 = FlowKt.first(this.toolProcessManager.getProcessesForChannel-CH08qv8(channelId), (Continuation)$continuation);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                channelId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if ((processes = (Set)v0).size() > 1) {
                    Logger.INSTANCE.info("Found more than one process for channel " + ChannelId.toString-impl(channelId) + ", will use the first one");
                }
                v1 = var4_7 = (v2 = (StateFlow<ToolProcessState>)CollectionsKt.firstOrNull((Iterable)processes)) != null && (v2 = v2.getState()) != null ? (ToolProcessState)v2.getValue() : null;
                v3 = var4_7 instanceof ToolProcessState.MaybeHasConnection != false ? (ToolProcessState.MaybeHasConnection)var4_7 : null;
                if (v3 != null && (v3 = v3.getConnection()) != null) {
                    it = var5_8 = v3;
                    $i$a$-takeIf-ToolManagerProtocolHandler$tryFindIdeConnection$2 = false;
                    v4 = it.supports(IdeProtocolHandlerService.INSTANCE) ? var5_8 : null;
                } else {
                    v4 = null;
                }
                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Pair<ChannelId, ToolInstance> getToolToUse-6t_uRKQ(URI uri, String projectId) {
        LaunchMethod launchMethod;
        String string = projectId;
        if (string != null) {
            String it = string;
            boolean bl = false;
            v1 = (LaunchMethod)CollectionsKt.firstOrNull(((ProjectManager.Model)this.projectManager.getState().getValue()).sortedLaunchMethods-CD0_5dk(it));
        } else {
            v1 = launchMethod = null;
        }
        if (launchMethod instanceof InstalledToolOpenProject) {
            Pair pair;
            ToolInstance toolInstance;
            ChannelState channelState = (ChannelState)((Map)this.tools.getValue()).get(ChannelId.box-impl(((InstalledToolOpenProject)launchMethod).getChannelId-5CZByfs()));
            ToolInstance toolInstance2 = toolInstance = channelState != null ? ChannelStateKt.toToolInstanceOrNull(channelState) : null;
            if (toolInstance2 != null) {
                ToolInstance it = toolInstance2;
                boolean bl = false;
                pair = TuplesKt.to((Object)ChannelId.box-impl(((InstalledToolOpenProject)launchMethod).getChannelId-5CZByfs()), (Object)it);
            } else {
                pair = null;
            }
            return pair;
        }
        Logger.INSTANCE.info("URL open for " + uri + ": launch method not available (" + launchMethod + ")");
        Set<ApplicationType> appTypes = this.getAppTypeByURL(uri);
        return this.getFirstInstalledMatchingTool(appTypes);
    }

    /*
     * Exception decompiling
     */
    private final Object handleProject(URI uri, String command, Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[SWITCH], 8[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private final void handleMatterhorn(URI uri) {
        tool = this.getToolByURL(uri);
        protocol = new Ref.ObjectRef();
        result = new Ref.BooleanRef();
        try {
            query = URIExtensionsKt.parseQuery(uri);
            downloadUrl = query.get("url");
            v0 = downloadUrl;
            if (v0 == null) {
                v0 = "";
            }
            protocol.element = this.getProtocol(v0);
            if (tool == null || !this.isDownloadUrlValid(downloadUrl)) ** GOTO lbl-1000
            var7_8 = new String[2];
            var7_8[0] = "matterhornProjectOpener";
            Intrinsics.checkNotNullExpressionValue((Object)uri.toString(), (String)"toString(...)");
            if (this.handleDefault(tool, var7_8)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            result.element = v1;
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Couldn't handle '" + uri + "'");
        }
        this.fusLogger.logVararg(Fus.Counters.Extension.INSTANCE.getMatterhorn(), (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handleMatterhorn$lambda$16(java.net.URI kotlin.jvm.internal.Ref$ObjectRef kotlin.jvm.internal.Ref$BooleanRef com.jetbrains.toolbox.fus.FusFieldDescriptions$ExtensionProject ), (Lcom/jetbrains/toolbox/fus/FusFieldDescriptions$ExtensionProject;)Lkotlin/Unit;)((URI)uri, (Ref.ObjectRef)protocol, (Ref.BooleanRef)result));
    }

    private final boolean handleDefault(ToolInstance tool, String ... parameter) {
        boolean bl;
        try {
            this.processLauncher.launch(ToolParameters.Companion.of(tool), new ProcessParameters(ArraysKt.toList((Object[])parameter), false, true, null, null, null, null, 122, null));
            bl = true;
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Tool " + InstalledToolKt.displayNameWithVersion(tool.getChannel(), tool.getTool()) + " failed to start with parameters [" + ArraysKt.joinToString$default((Object[])parameter, null, null, null, (int)0, null, ToolManagerProtocolHandler::handleDefault$lambda$17, (int)31, null) + "]");
            bl = false;
        }
        return bl;
    }

    private final boolean isDownloadUrlValid(String downloadUrl) {
        if (downloadUrl == null) {
            Logger.INSTANCE.warn("Missing query parameter 'url'");
            return false;
        }
        URI downloadUri = StringExtensionsKt.toUriOrNull(downloadUrl);
        if (downloadUri == null) {
            Logger.INSTANCE.warn("Couldn't parse download URL " + downloadUrl);
            return false;
        }
        if (!Intrinsics.areEqual((Object)downloadUri.getHost(), (Object)"matterhorn.labs.jb.gg") && !Intrinsics.areEqual((Object)downloadUri.getHost(), (Object)"dev-matterhorn.labs.jb.gg")) {
            Logger.INSTANCE.warn("Invalid download URL host '" + downloadUri.getHost() + "'");
            return false;
        }
        return true;
    }

    private final Pair<ChannelId, ToolInstance> getExactToolByURL(URI uri) {
        Pair pair;
        String string = uri.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        String string2 = this.asChannelId-73xg5Po(string);
        if (string2 != null) {
            String channelId = string2;
            boolean bl = false;
            Object object = (ChannelState)((Map)this.tools.getValue()).get(ChannelId.box-impl(channelId));
            if (object != null && (object = ChannelStateKt.toToolInstanceOrNull((State)object)) != null) {
                Object it = object;
                boolean bl2 = false;
                pair = TuplesKt.to((Object)ChannelId.box-impl(channelId), (Object)it);
            } else {
                pair = null;
            }
        } else {
            pair = null;
        }
        return pair;
    }

    private final Set<ApplicationType> getAppTypeByURL(URI uri) {
        String string = uri.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        String[] stringArray = new String[]{"."};
        return this.applicationTypesByHost((String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0));
    }

    private final Pair<ChannelId, ToolInstance> getFirstInstalledMatchingTool(Set<ApplicationType> applicationTypes) {
        Map.Entry entry;
        block3: {
            for (Map.Entry entry2 : SequencesKt.filter((Sequence)MapsKt.asSequence((Map)((Map)this.tools.getValue())), arg_0 -> ToolManagerProtocolHandler.getFirstInstalledMatchingTool$lambda$20(applicationTypes, arg_0))) {
                Pair pair;
                boolean bl = false;
                String channelId = ((ChannelId)entry2.getKey()).unbox-impl();
                ChannelState state2 = (ChannelState)entry2.getValue();
                if (ChannelStateKt.toToolInstanceOrNull(state2) != null) {
                    ToolInstance it;
                    boolean bl2 = false;
                    pair = TuplesKt.to((Object)ChannelId.box-impl(channelId), (Object)it);
                } else {
                    pair = null;
                }
                if ((entry2 = pair) == null) continue;
                entry = entry2;
                break block3;
            }
            entry = null;
        }
        return entry;
    }

    private final ToolInstance getToolByURL(URI uri) {
        ToolInstance toolInstance;
        try {
            ToolInstance toolInstance2;
            Pair<ChannelId, ToolInstance> exactTool = this.getExactToolByURL(uri);
            if (exactTool != null) {
                toolInstance2 = (ToolInstance)exactTool.getSecond();
            } else {
                Set<ApplicationType> applicationTypes = this.getAppTypeByURL(uri);
                Pair<ChannelId, ToolInstance> pair = this.getFirstInstalledMatchingTool(applicationTypes);
                toolInstance2 = pair != null ? (ToolInstance)pair.getSecond() : null;
            }
            toolInstance = toolInstance2;
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e);
            toolInstance = null;
        }
        return toolInstance;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ApplicationType> applicationTypesByHost(String host) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Map<ApplicationType, ToolWithVersions> $this$filter$iv = ((AvailableTools)this.availableTools.getValue()).getTools();
        boolean $i$f$filter = false;
        Map<ApplicationType, ToolWithVersions> map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator2.next();
            boolean bl = false;
            Object object = ((ToolWithVersions)it.getValue()).getTool().getActivation();
            boolean bl2 = object != null && (object = ((Activation)object).getHosts()) != null ? object.contains(host) : false;
            if (!bl2) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(ApplicationType.box-impl(((ApplicationType)it.getKey()).unbox-impl()));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final String getProtocol(String remoteUrl) {
        return StringsKt.startsWith$default((String)remoteUrl, (String)"git@", (boolean)false, (int)2, null) ? "ssh" : (StringsKt.startsWith$default((String)remoteUrl, (String)"ssh://", (boolean)false, (int)2, null) ? "ssh" : (StringsKt.startsWith$default((String)remoteUrl, (String)"https://", (boolean)false, (int)2, null) ? "https" : (StringsKt.startsWith$default((String)remoteUrl, (String)"http://", (boolean)false, (int)2, null) ? "http" : null)));
    }

    @Override
    public boolean getImpliesUiMode() {
        return ProtocolHandler.super.getImpliesUiMode();
    }

    private static final Unit handleProject$lambda$14(URI $uri, Ref.BooleanRef $result, FusFieldDescriptions.Extension $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setHost($uri.getHost());
        $this$logVararg.setSuccessful($result.element);
        return Unit.INSTANCE;
    }

    private static final Unit handleProject$lambda$15(URI $uri, Ref.ObjectRef $protocol, Ref.ObjectRef $action, Ref.BooleanRef $result, FusFieldDescriptions.ExtensionProject $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setHost($uri.getHost());
        $this$logVararg.setProtocol((String)$protocol.element);
        $this$logVararg.setAction((String)$action.element);
        $this$logVararg.setSuccessful($result.element);
        return Unit.INSTANCE;
    }

    private static final Unit handleMatterhorn$lambda$16(URI $uri, Ref.ObjectRef $protocol, Ref.BooleanRef $result, FusFieldDescriptions.ExtensionProject $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setHost($uri.getHost());
        $this$logVararg.setProtocol((String)$protocol.element);
        $this$logVararg.setAction("download");
        $this$logVararg.setSuccessful($result.element);
        return Unit.INSTANCE;
    }

    private static final CharSequence handleDefault$lambda$17(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }

    private static final boolean getFirstInstalledMatchingTool$lambda$20(Set $applicationTypes, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ChannelState state2 = (ChannelState)entry.getValue();
        return $applicationTypes.contains(ApplicationType.box-impl(state2.getTool().getToolId-UtVBrGo()));
    }

    public static final /* synthetic */ Object access$openViaIdeConnection(ToolManagerProtocolHandler $this, URI uri, Map query2, IdeConnection connection, String command2, Pair exactTool, Continuation $completion) {
        return $this.openViaIdeConnection(uri, query2, connection, command2, (Pair<ChannelId, ToolInstance>)exactTool, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$tryFindIdeConnection-R5oYZt4(ToolManagerProtocolHandler $this, String channelId, Continuation $completion) {
        return $this.tryFindIdeConnection-R5oYZt4(channelId, (Continuation<? super IdeConnection>)$completion);
    }

    public static final /* synthetic */ Object access$handleProject(ToolManagerProtocolHandler $this, URI uri, String command2, Continuation $completion) {
        return $this.handleProject(uri, command2, (Continuation<? super Unit>)$completion);
    }
}

