/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.platform.image.internal.ImageId;
import com.jetbrains.toolbox.tools.ToolIconRefresher;
import com.jetbrains.toolbox.tools.image.ImageManager;
import com.jetbrains.toolbox.tools.model.AvailableBuild;
import com.jetbrains.toolbox.tools.model.AvailableTools;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.SideEffect;
import com.jetbrains.toolbox.tools.model.ToolIconSideEffect;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolRefreshHandler;
import com.jetbrains.toolbox.tools.model.ToolWithVersions;
import com.jetbrains.toolbox.tools.model.VersionWithBuilds;
import com.jetbrains.toolbox.tools.model.WithSideEffects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Instant;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nToolIconRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolIconRefresher.kt\ncom/jetbrains/toolbox/tools/ToolIconRefresher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1563#2:85\n1634#2,3:86\n1869#2:90\n1869#2,2:91\n1870#2:93\n1#3:89\n*S KotlinDebug\n*F\n+ 1 ToolIconRefresher.kt\ncom/jetbrains/toolbox/tools/ToolIconRefresher\n*L\n31#1:85\n31#1:86,3\n72#1:90\n73#1:91,2\n72#1:93\n*E\n"})
public final class ToolIconRefresher
implements ToolRefreshHandler {
    @NotNull
    private final ImageManager imageManager;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final StateFlow<AvailableTools> availableTools;
    @NotNull
    private final Collection<SideEffect> sideEffects;
    @NotNull
    private final ConcurrentHashMap<Path, Instant> pathToLastModifiedMap;

    public ToolIconRefresher(@NotNull ImageManager imageManager, @NotNull FileSystem fileSystem, @NotNull StateFlow<AvailableTools> availableTools2) {
        Intrinsics.checkNotNullParameter((Object)imageManager, (String)"imageManager");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(availableTools2, (String)"availableTools");
        this.imageManager = imageManager;
        this.fileSystem = fileSystem;
        this.availableTools = availableTools2;
        this.sideEffects = CollectionsKt.listOf((Object)ToolIconSideEffect.INSTANCE);
        this.pathToLastModifiedMap = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public Collection<SideEffect> getSideEffects() {
        return this.sideEffects;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        if (!($completion instanceof onRefresh.1)) ** GOTO lbl-1000
        var15_3 = $completion;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ToolIconRefresher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.onRefresh(null, (Continuation<? super ToolInstance>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$map$iv = this.iconPathsFromAvailableTools-dgXOpgo(toolInstance.getTool().getToolId-UtVBrGo(), toolInstance.getTool().getBuildNumber-Y_E1uuk());
                $i$f$map = false;
                var6_9 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var11_14 = (Path)item$iv$iv;
                    var13_16 = destination$iv$iv;
                    $i$a$-map-ToolIconRefresher$onRefresh$iconPaths$1 = false;
                    var13_16.add(toolInstance.getChannel().getInstallationDirectory().resolve((Path)it));
                }
                iconPaths = (List)destination$iv$iv;
                pathToUpdate = this.firstExistingIfUpdatedOrNull(iconPaths);
                if (pathToUpdate == null) break;
                Logger.INSTANCE.info("Using icon path '" + pathToUpdate + "' for " + InstalledToolKt.displayNameWithVersion(toolInstance.getChannel(), toolInstance.getTool()));
                $continuation.L$0 = toolInstance;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)iconPaths);
                $continuation.L$2 = pathToUpdate;
                $continuation.label = 1;
                v0 = ImageManager.convert-lK-al4Y$default(this.imageManager, pathToUpdate, false, (Continuation)$continuation, 2, null);
                if (v0 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl43
            }
            case 1: {
                pathToUpdate = (Path)$continuation.L$2;
                iconPaths = (List)$continuation.L$1;
                toolInstance = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = (ImageId)$result;
                v0 = v1 != null ? v1.unbox-impl() : null;
lbl43:
                // 2 sources

                if ((icon = v0) == null) {
                    Logger.INSTANCE.warn("Couldn't process icon at path '" + pathToUpdate + "'");
                    return toolInstance;
                }
                return ToolInstance.copy$default(toolInstance, null, InstalledTool.copy-O5aDtfo$default(toolInstance.getTool(), null, null, null, icon, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, null, 1048567, null), 1, null);
            }
        }
        Logger.INSTANCE.trace("No bundled icon found for " + InstalledToolKt.displayNameWithVersion(toolInstance.getChannel(), toolInstance.getTool()));
        return toolInstance;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Path firstExistingIfUpdatedOrNull(Collection<Path> paths) {
        for (Path path2 : paths) {
            Path path3;
            Instant lastModified;
            Logger.INSTANCE.trace("Checking icon at '" + path2 + "'");
            Object object = this.fileSystem.metadataOrNull(path2);
            if (object != null && (object = object.getLastModifiedAtMillis()) != null) {
                long it = ((Number)object).longValue();
                boolean bl = false;
                v1 = Instant.Companion.fromEpochMilliseconds(it);
            } else {
                v1 = lastModified = null;
            }
            if (lastModified == null) {
                Logger.INSTANCE.trace("Icon at '" + path2 + "' doesn't exist, skipping");
                continue;
            }
            Instant previousLastModified = this.pathToLastModifiedMap.put(path2, lastModified);
            if (!Intrinsics.areEqual((Object)lastModified, (Object)previousLastModified)) {
                Logger.INSTANCE.debug("Using modified icon at '" + path2 + "' (last modified " + lastModified + ", previous last modified " + previousLastModified + ")");
                path3 = path2;
            } else {
                Logger.INSTANCE.trace("Not updating the icon at '" + path2 + "' as it doesn't appear to have been modified");
                path3 = null;
            }
            return path3;
        }
        return null;
    }

    private final Collection<Path> iconPathsFromAvailableTools-dgXOpgo(String toolId, String buildNumber) {
        Object object;
        block8: {
            block7: {
                Collection collection;
                block6: {
                    object = ((AvailableTools)this.availableTools.getValue()).getTools().get(ApplicationType.box-impl(toolId));
                    if (object == null) break block7;
                    ToolWithVersions it = object;
                    boolean bl = false;
                    HashSet<Path> paths = new HashSet<Path>();
                    Iterable $this$forEach$iv = it.getVersions();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        VersionWithBuilds it2 = (VersionWithBuilds)element$iv;
                        boolean bl2 = false;
                        Iterable $this$forEach$iv2 = it2.getBuilds();
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            AvailableBuild it3 = (AvailableBuild)element$iv2;
                            boolean bl3 = false;
                            Path iconPath = it3.getIconPath();
                            if (iconPath == null) continue;
                            if (BuildNumber.equals-impl0(it3.getId-Y_E1uuk(), buildNumber)) {
                                collection = CollectionsKt.listOf((Object)iconPath);
                                break block6;
                            }
                            paths.add(iconPath);
                        }
                    }
                    collection = paths;
                }
                object = collection;
                if (collection != null) break block8;
            }
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull ToolInstance initial, @NotNull Continuation<? super ToolInstance> $completion) {
        return ToolRefreshHandler.super.onRefresh(toolInstance, initial, $completion);
    }

    @Override
    public boolean dependsOn(@NotNull WithSideEffects other) {
        return ToolRefreshHandler.super.dependsOn(other);
    }

    @Override
    @NotNull
    public Collection<SideEffect> getRunAfter() {
        return ToolRefreshHandler.super.getRunAfter();
    }
}

