/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools;

import com.jetbrains.toolbox.common.extensions.ByteArrayExtensionsKt;
import com.jetbrains.toolbox.common.security.ShaKt;
import com.jetbrains.toolbox.feed.LicenseAgreement;
import com.jetbrains.toolbox.settings.Storage;
import com.jetbrains.toolbox.tools.LicenseAgreementManager;
import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nLicenseAgreementManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseAgreementManagerImpl.kt\ncom/jetbrains/toolbox/tools/LicenseAgreementManagerImpl\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,30:1\n230#2,5:31\n*S KotlinDebug\n*F\n+ 1 LicenseAgreementManagerImpl.kt\ncom/jetbrains/toolbox/tools/LicenseAgreementManagerImpl\n*L\n18#1:31,5\n*E\n"})
public final class LicenseAgreementManagerImpl
implements LicenseAgreementManager {
    @NotNull
    private final MutableStateFlow<Storage> storage;

    public LicenseAgreementManagerImpl(@NotNull MutableStateFlow<Storage> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        this.storage = storage;
    }

    @Override
    public boolean isAccepted(@NotNull LicenseAgreement licenseAgreement) {
        Intrinsics.checkNotNullParameter((Object)licenseAgreement, (String)"licenseAgreement");
        return ((Storage)this.storage.getValue()).getAcceptedLicenseAgreementHashes().contains(this.getSha256(licenseAgreement));
    }

    @Override
    public void acceptLicenseAgreement(@NotNull LicenseAgreement licenseAgreement) {
        Storage storage;
        Storage nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)licenseAgreement, (String)"licenseAgreement");
        MutableStateFlow<Storage> $this$update$iv = this.storage;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            Storage it = (Storage)prevValue$iv;
            boolean bl = false;
            String hash = this.getSha256(licenseAgreement);
            if (!it.getAcceptedLicenseAgreementHashes().contains(hash)) {
                storage = Storage.copy-sSrm3y0$default(it, false, false, null, null, CollectionsKt.plus((Collection)it.getAcceptedLicenseAgreementHashes(), (Object)hash), null, null, null, false, 0L, false, null, null, false, null, 32751, null);
                continue;
            }
            storage = it;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = storage)));
    }

    private final String getSha256(LicenseAgreement $this$sha256) {
        String string = $this$sha256.getFullHtml();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return ByteArrayExtensionsKt.toHex$default(ShaKt.sha256(byArray), null, false, 3, null);
    }
}

