/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools;

import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstallLocation {
    @NotNull
    private final Path fullPath;
    @NotNull
    private final String displayPath;

    public InstallLocation(@NotNull Path fullPath, @NotNull String displayPath) {
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Intrinsics.checkNotNullParameter((Object)displayPath, (String)"displayPath");
        this.fullPath = fullPath;
        this.displayPath = displayPath;
    }

    @NotNull
    public final Path getFullPath() {
        return this.fullPath;
    }

    @NotNull
    public final String getDisplayPath() {
        return this.displayPath;
    }

    @NotNull
    public String toString() {
        return "InstallLocation(fullPath=" + this.fullPath + ", displayPath=" + this.displayPath + ")";
    }

    public int hashCode() {
        int result2 = this.fullPath.hashCode();
        result2 = result2 * 31 + this.displayPath.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InstallLocation)) {
            return false;
        }
        InstallLocation installLocation = (InstallLocation)other;
        if (!Intrinsics.areEqual((Object)this.fullPath, (Object)installLocation.fullPath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.displayPath, (Object)installLocation.displayPath);
    }
}

