/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.tools.model.Channel;
import com.jetbrains.toolbox.tools.model.ChannelBackupEntry;
import com.jetbrains.toolbox.tools.model.ChannelBackupOptions;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.SideEffect;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolRefreshHandler;
import com.jetbrains.toolbox.tools.model.UpdateFilter;
import com.jetbrains.toolbox.tools.model.WithSideEffects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nBackupDirectoryCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupDirectoryCleaner.kt\ncom/jetbrains/toolbox/tools/BackupDirectoryCleaner\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n622#2:79\n1617#3,9:80\n1869#3:89\n1870#3:91\n1626#3:92\n774#3:93\n865#3,2:94\n1#4:90\n*S KotlinDebug\n*F\n+ 1 BackupDirectoryCleaner.kt\ncom/jetbrains/toolbox/tools/BackupDirectoryCleaner\n*L\n37#1:79\n50#1:80,9\n50#1:89\n50#1:91\n50#1:92\n59#1:93\n59#1:94,2\n50#1:90\n*E\n"})
public final class BackupDirectoryCleaner
implements ToolRefreshHandler {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Clock clock;
    @NotNull
    private final StateFlow<SelfSettings> settings;

    public BackupDirectoryCleaner(@NotNull FileSystem fileSystem, @NotNull Clock clock, @NotNull StateFlow<SelfSettings> settings2) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(settings2, (String)"settings");
        this.fileSystem = fileSystem;
        this.clock = clock;
        this.settings = settings2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Set set2;
        ChannelBackupOptions backupOptions = toolInstance.getChannel().getBackupOptions();
        String toolName = InstalledToolKt.displayNameWithoutVersion(toolInstance.getChannel(), toolInstance.getTool());
        Instant gracePeriodEnd = this.clock.now().minus-LRDsOJo(((SelfSettings)this.settings.getValue()).getInternal().getBackupCacheTTL-UwyO8pc());
        if (((SelfSettings)this.settings.getValue()).getBackupLimit() > 0) {
            void $this$sortedByDescending$iv;
            Sequence sequence2 = SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)backupOptions.getEntries()), arg_0 -> BackupDirectoryCleaner.onRefresh$lambda$0(this, arg_0)), arg_0 -> BackupDirectoryCleaner.onRefresh$lambda$1(toolInstance, arg_0)), arg_0 -> BackupDirectoryCleaner.onRefresh$lambda$2(gracePeriodEnd, arg_0));
            boolean $i$f$sortedByDescending = false;
            set2 = SequencesKt.toSet((Sequence)SequencesKt.take((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ChannelBackupEntry it = (ChannelBackupEntry)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)it.getCreatedAt();
                    it = (ChannelBackupEntry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getCreatedAt()));
                }
            }), (int)((SelfSettings)this.settings.getValue()).getBackupLimit()));
        } else {
            set2 = SetsKt.emptySet();
        }
        Set backupEntriesToPreserve = set2;
        Set backupEntriesToEliminate = SetsKt.minus(backupOptions.getEntries(), (Iterable)backupEntriesToPreserve);
        if (backupEntriesToEliminate.isEmpty()) {
            Logger.INSTANCE.debug("No backups to remove for " + toolName);
            return toolInstance;
        }
        Iterable $this$mapNotNull$iv = backupEntriesToEliminate;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ChannelBackupEntry it = (ChannelBackupEntry)element$iv$iv;
            boolean bl2 = false;
            Path directory = it.getDirectory();
            Logger.INSTANCE.info("Removing backup directory '" + directory + "' of " + toolName + ", number of backups exceeds limit " + ((SelfSettings)this.settings.getValue()).getBackupLimit());
            if (this.removeBackup(directory, toolName) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set eliminatedDirectories = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$mapNotNull$iv = backupOptions.getEntries();
        ChannelBackupOptions channelBackupOptions = backupOptions;
        boolean bl = false;
        Path path2 = null;
        UpdateFilter updateFilter = null;
        String string = null;
        Channel channel = toolInstance.getChannel();
        ToolInstance toolInstance2 = toolInstance;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChannelBackupEntry it = (ChannelBackupEntry)element$iv$iv;
            boolean bl4 = false;
            if (!(!eliminatedDirectories.contains(it.getDirectory()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return ToolInstance.copy$default(toolInstance2, Channel.copy$default(channel, string, updateFilter, path2, bl, channelBackupOptions.copy(CollectionsKt.toSet((Iterable)list2)), false, null, false, null, null, null, 2031, null), null, 2, null);
    }

    private final Path removeBackup(Path directory, String toolName) {
        try {
            this.fileSystem.deleteRecursively(directory);
            Logger.INSTANCE.info("Removed backup directory '" + directory + "' of " + toolName);
            return directory;
        }
        catch (IOException e) {
            Logger.INSTANCE.error("Can't remove backup directory '" + directory + "' of " + toolName + ", " + e.getMessage());
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Can't remove backup directory '" + directory + "' of " + toolName);
        }
        return null;
    }

    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull ToolInstance initial, @NotNull Continuation<? super ToolInstance> $completion) {
        return ToolRefreshHandler.super.onRefresh(toolInstance, initial, $completion);
    }

    @Override
    public boolean dependsOn(@NotNull WithSideEffects other) {
        return ToolRefreshHandler.super.dependsOn(other);
    }

    @Override
    @NotNull
    public Collection<SideEffect> getSideEffects() {
        return ToolRefreshHandler.super.getSideEffects();
    }

    @Override
    @NotNull
    public Collection<SideEffect> getRunAfter() {
        return ToolRefreshHandler.super.getRunAfter();
    }

    private static final boolean onRefresh$lambda$0(BackupDirectoryCleaner this$0, ChannelBackupEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.fileSystem.exists(it.getDirectory());
    }

    private static final boolean onRefresh$lambda$1(ToolInstance $toolInstance, ChannelBackupEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BuildNumber.equals-impl0(it.getBuildNumber-Y_E1uuk(), $toolInstance.getTool().getBuildNumber-Y_E1uuk());
    }

    private static final boolean onRefresh$lambda$2(Instant $gracePeriodEnd, ChannelBackupEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCreatedAt().compareTo($gracePeriodEnd) < 0;
    }
}

