/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.theme.linux;

import com.jetbrains.toolbox.interop.ThemeCallback;
import com.jetbrains.toolbox.theme.linux.ISettings;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class LinuxSystemThemeWrapper {
    @NotNull
    private static final Companion Companion = new Companion(null);

    private final DBusConnection getSessionBus() {
        return DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
    }

    private final UInt32 unpackUInt32(Variant<?> $this$unpackUInt32) {
        Object value2 = $this$unpackUInt32.getValue();
        return value2 instanceof UInt32 ? (UInt32)value2 : (value2 instanceof Variant ? this.unpackUInt32((Variant)value2) : null);
    }

    private final boolean isDark(UInt32 $this$isDark) {
        return switch ($this$isDark.intValue()) {
            case 0 -> {
                Logger.INSTANCE.debug("The system reports there is no preference for color-scheme, treating it as isDark=false");
                yield false;
            }
            case 1 -> true;
            case 2 -> false;
            default -> {
                Logger.INSTANCE.debug("Unknown UInt32 for color-scheme (" + $this$isDark + "), treating it as isDark=false");
                yield false;
            }
        };
    }

    private final Boolean isDark(Variant<?> $this$isDark) {
        UInt32 uInt32 = this.unpackUInt32($this$isDark);
        if (uInt32 == null) {
            Logger.INSTANCE.warn("Can't unpack UInt32 for " + $this$isDark);
            return null;
        }
        return this.isDark(uInt32);
    }

    private final Boolean getCurrentSystemThemeIsDark() {
        DBusInterface dBusInterface = this.getSessionBus().getRemoteObject("org.freedesktop.portal.Desktop", "/org/freedesktop/portal/desktop", ISettings.class);
        Intrinsics.checkNotNull((Object)dBusInterface);
        ISettings remoteObject = (ISettings)dBusInterface;
        Variant colorScheme = remoteObject.Read("org.freedesktop.appearance", "color-scheme");
        return this.isDark(colorScheme);
    }

    public final boolean setListenerAndTheme(@NotNull ThemeCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        try {
            DBusSigHandler colorSchemeHandler = arg_0 -> LinuxSystemThemeWrapper.setListenerAndTheme$lambda$0(this, callback, arg_0);
            this.getSessionBus().addSigHandler(ISettings.SettingChanged.class, colorSchemeHandler);
            Logger.INSTANCE.debug("System theme listener set");
        }
        catch (Throwable t2) {
            Logger.INSTANCE.warn(t2, "Failed to set system theme listener, so system theme changes won't be applied in runtime (please report it if you believe it should work): " + t2.getMessage());
        }
        try {
            Boolean isDark = this.getCurrentSystemThemeIsDark();
            if (isDark != null) {
                callback.callback(isDark);
                Logger.INSTANCE.debug("Current system theme set to isDark=" + isDark);
                return true;
            }
            Logger.INSTANCE.warn("Current system theme is unknown, skipping theme setting, marking system theme as unsupported");
            return false;
        }
        catch (Throwable t3) {
            Logger.INSTANCE.warn(t3, "Failed to set current system theme, marking system theme as unsupported: " + t3.getMessage());
            return false;
        }
    }

    private static final void setListenerAndTheme$lambda$0(LinuxSystemThemeWrapper this$0, ThemeCallback $callback, ISettings.SettingChanged it) {
        Logger.INSTANCE.debug("Received signal: " + it);
        if (Intrinsics.areEqual((Object)it.getNamespace(), (Object)"org.freedesktop.appearance") && Intrinsics.areEqual((Object)it.getKey(), (Object)"color-scheme")) {
            Boolean isDark = this$0.isDark(it.getValue());
            if (isDark == null) {
                Logger.INSTANCE.warn("System theme is unknown, skipping theme setting");
                return;
            }
            $callback.callback(isDark);
            Logger.INSTANCE.debug("System theme set to isDark=" + isDark);
        }
    }

    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

