/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.theme;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.interop.NativeInteropWin32;
import com.jetbrains.toolbox.interop.ThemeCallback;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.settings.Theme;
import com.jetbrains.toolbox.settings.UISettings;
import com.jetbrains.toolbox.theme.ThemeManager;
import com.jetbrains.toolbox.theme.linux.LinuxSystemThemeWrapper;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class ThemeManagerImpl
implements ThemeManager {
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final MutableStateFlow<Boolean> _isDarkTheme;
    private boolean systemIsDark;
    @NotNull
    private final ThemeCallback nativeThemeCallback;
    private final boolean isSystemThemeSupported;

    public ThemeManagerImpl(@NotNull SettingsManager settingsManager, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.settingsManager = settingsManager;
        this._isDarkTheme = StateFlowKt.MutableStateFlow((Object)false);
        this.nativeThemeCallback = arg_0 -> ThemeManagerImpl.nativeThemeCallback$lambda$0(this, arg_0);
        this.evaluateTheme(((SelfSettings)this.settingsManager.getSettings().getValue()).getUi().getTheme());
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ThemeManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.settingsManager.getSettings()), (Function2)((Function2)new Function2<SelfSettings, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ ThemeManagerImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                SelfSettings selfSettings = (SelfSettings)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.this$0.evaluateTheme(it.getUi().getTheme());
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(SelfSettings p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.isSystemThemeSupported = switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
            case 1 -> {
                NativeInteropWin32.INSTANCE.onThemeChange(this.getNativeThemeCallback());
                yield true;
            }
            case 2 -> true;
            case 3 -> new LinuxSystemThemeWrapper().setListenerAndTheme(this.getNativeThemeCallback());
            default -> {
                Logger.INSTANCE.warn("Can't determine OS, so won't listen to system theme changes");
                yield false;
            }
        };
        this.settingsManager.updateSettings((Function1<? super SelfSettings, SelfSettings>)((Function1)arg_0 -> ThemeManagerImpl._init_$lambda$1(this, arg_0)));
    }

    @Override
    @NotNull
    public StateFlow<Boolean> isDarkTheme() {
        return FlowKt.asStateFlow(this._isDarkTheme);
    }

    @Override
    @NotNull
    public ThemeCallback getNativeThemeCallback() {
        return this.nativeThemeCallback;
    }

    @Override
    public boolean isSystemThemeSupported() {
        return this.isSystemThemeSupported;
    }

    private final void evaluateTheme(Theme userSelectedTheme) {
        this._isDarkTheme.setValue((Object)(switch (WhenMappings.$EnumSwitchMapping$1[userSelectedTheme.ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            case 3 -> this.systemIsDark;
            default -> throw new NoWhenBranchMatchedException();
        }));
    }

    private static final void nativeThemeCallback$lambda$0(ThemeManagerImpl this$0, boolean isDark) {
        this$0.systemIsDark = isDark;
        this$0.evaluateTheme(((SelfSettings)this$0.settingsManager.getSettings().getValue()).getUi().getTheme());
    }

    private static final SelfSettings _init_$lambda$1(ThemeManagerImpl this$0, SelfSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Theme resetUiTheme = !this$0.isSystemThemeSupported() && it.getUi().getTheme() == Theme.System ? Theme.Light : it.getUi().getTheme();
        return SelfSettings.copy$default(it, null, null, false, false, null, 0, null, null, null, null, null, null, UISettings.copy$default(it.getUi(), null, resetUiTheme, null, null, 0.0f, 29, null), null, null, null, null, 126975, null);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Theme.values().length];
            try {
                nArray[Theme.Light.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Theme.Dark.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Theme.System.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

