/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tbe.test.access;

import com.jetbrains.toolbox.accounts.JetBrainsAccountSecureToken;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Token;
import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.common.extensions.URIExtensionsKt;
import com.jetbrains.toolbox.common.io.OkHttpBuilderExtensionsKt;
import com.jetbrains.toolbox.tbe.test.access.AuthContext;
import com.jetbrains.toolbox.tbe.test.access.AuthRequest;
import com.jetbrains.toolbox.tbe.test.access.TestAuthenticationService;
import java.io.Closeable;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nTestAuthenticationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestAuthenticationService.kt\ncom/jetbrains/toolbox/tbe/test/access/TestAuthenticationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,290:1\n1#2:291\n*E\n"})
public final class TestAuthenticationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final cookieJar.1 cookieJar = new CookieJar(){
        private final List<Cookie> cookies;
        {
            Object[] objectArray = new Cookie[]{new Cookie.Builder().name("_st-JBA").value("1i1ZB_U-0VG8X9ls-vDjTQyQDNGnv_ACGbSvFXHbVoOXA-T3RWjT6BRQAIPoR1EW").domain("account.jetbrains.com").build()};
            this.cookies = CollectionsKt.mutableListOf((Object[])objectArray);
        }

        public List<Cookie> loadForRequest(HttpUrl url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return this.cookies;
        }

        public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
            this.cookies.addAll((Collection<Cookie>)cookies);
        }
    };
    @NotNull
    private final OkHttpClient client = OkHttpBuilderExtensionsKt.readTimeout-HG0u8IE(OkHttpBuilderExtensionsKt.callTimeout-HG0u8IE(OkHttpBuilderExtensionsKt.connectTimeout-HG0u8IE(new OkHttpClient.Builder().followRedirects(false), DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)), DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)), DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)).cookieJar(this.cookieJar).build();

    private final Response loginRequest(AuthContext context2) {
        String clientId = context2.getClientId();
        String redirectUri = "jetbrains://toolbox/jba/auth";
        List<String> scope2 = context2.getScope();
        String state2 = context2.getState();
        String codeChallenge = context2.getCodeChallenge();
        HttpUrl httpUrl = new HttpUrl.Builder().scheme("https").host("account.jetbrains.com").addPathSegment("oauth").addPathSegment("login").addQueryParameter("response_type", "code id_token").addQueryParameter("code_challenge", codeChallenge).addQueryParameter("code_challenge_method", "S256").addQueryParameter("client_id", clientId).addQueryParameter("redirect_uri", redirectUri).addQueryParameter("scope", CollectionsKt.joinToString$default((Iterable)scope2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)).addQueryParameter("state", state2).build();
        Request request2 = new Request.Builder().url(httpUrl).build();
        return this.client.newCall(request2).execute();
    }

    private final Response signinRequest(HttpUrl signInUrl, AuthRequest authRequest) {
        HttpUrl url = new HttpUrl.Builder().scheme(signInUrl.scheme()).host(signInUrl.host()).addPathSegments(CollectionsKt.joinToString$default((Iterable)signInUrl.pathSegments(), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null)).addQueryParameter("_st", "1i1ZB_U-0VG8X9ls-vDjTQyQDNGnv_ACGbSvFXHbVoOXA-T3RWjT6BRQAIPoR1EW").build();
        MultipartBody.Builder builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM).addFormDataPart("username", authRequest.getEmail()).addFormDataPart("password", authRequest.getPassword());
        String string = signInUrl.queryParameter("login_challenge");
        Intrinsics.checkNotNull((Object)string);
        MultipartBody body = builder.addFormDataPart("challenge", string).build();
        Request request2 = new Request.Builder().method("POST", body).url(url).build();
        return this.client.newCall(request2).execute();
    }

    private final Response consent(String consentChallengeValue, AuthContext context2) {
        HttpUrl url = new HttpUrl.Builder().scheme("https").host("account.jetbrains.com").addPathSegment("oauth2").addPathSegment("consent").addPathSegment("accept").addQueryParameter("_st", "1i1ZB_U-0VG8X9ls-vDjTQyQDNGnv_ACGbSvFXHbVoOXA-T3RWjT6BRQAIPoR1EW").build();
        String scope2 = CollectionsKt.joinToString$default((Iterable)context2.getScope(), null, null, null, (int)0, null, TestAuthenticationService::consent$lambda$0, (int)31, null);
        MultipartBody body = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM).addFormDataPart("scopes", "[" + scope2 + "]").addFormDataPart("challenge", consentChallengeValue).build();
        Request request2 = new Request.Builder().url(url).method("POST", body).build();
        return this.client.newCall(request2).execute();
    }

    /*
     * WARNING - void declaration
     */
    private final JetBrainsAccountSecureToken buildTokenEntity(Response response2) {
        Instant instant;
        Json json2 = JsonKt.getJsonx();
        ResponseBody responseBody = response2.body();
        String string = responseBody != null ? responseBody.string() : null;
        Intrinsics.checkNotNull((Object)string);
        JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)json2.parseToJsonElement(string));
        Logger.INSTANCE.info("Fetched token: " + jsonObject);
        OAuth2Token result2 = (OAuth2Token)JsonKt.getJsonx().decodeFromJsonElement((DeserializationStrategy)OAuth2Token.Companion.serializer(), (JsonElement)jsonObject);
        Clock.System clock = Clock.System.INSTANCE;
        Instant expirationNow = clock.now();
        OAuth2Token oAuth2Token = result2;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        Long l = null;
        Duration duration = null;
        Duration duration2 = result2.getExpiresIn-FghU774();
        if (duration2 != null) {
            void it;
            long l2 = duration2.unbox-impl();
            Duration duration3 = duration;
            Long l3 = l;
            String string9 = string8;
            String string10 = string7;
            String string11 = string6;
            String string12 = string5;
            String string13 = string4;
            String string14 = string3;
            String string15 = string2;
            OAuth2Token oAuth2Token2 = oAuth2Token;
            boolean bl = false;
            Instant instant2 = expirationNow.plus-LRDsOJo((long)it);
            oAuth2Token = oAuth2Token2;
            string2 = string15;
            string3 = string14;
            string4 = string13;
            string5 = string12;
            string6 = string11;
            string7 = string10;
            string8 = string9;
            l = l3;
            duration = duration3;
            instant = instant2;
        } else {
            instant = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        String string16 = null;
        OAuth2Token oAuth2Token3 = OAuth2Token.copy-I-hR9vI$default(oAuth2Token, string2, string3, string4, string5, string6, string7, string8, l, duration, instant, null, 1535, null);
        return new JetBrainsAccountSecureToken(oAuth2Token3, string16, n, defaultConstructorMarker);
    }

    private final Response followRedirect(String redirectUrl) {
        return this.client.newCall(new Request.Builder().url(redirectUrl).build()).execute();
    }

    private final AuthContext createContext(AuthRequest authRequest) {
        MessageDigest messageDigest;
        String codeVerifier2 = "minimum64bytesminimum64bytesminimum64bytesminimum64bytesminimum6";
        byte[] byArray = codeVerifier2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes2 = byArray;
        MessageDigest $this$createContext_u24lambda_u242 = messageDigest = MessageDigest.getInstance("SHA-256");
        boolean bl = false;
        $this$createContext_u24lambda_u242.update(bytes2);
        MessageDigest messageDigest2 = messageDigest;
        String codeChallenge = Base64.getUrlEncoder().withoutPadding().encodeToString(messageDigest2.digest());
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String state2 = string;
        Intrinsics.checkNotNull((Object)codeChallenge);
        return new AuthContext(codeVerifier2, codeChallenge, state2, authRequest.getClientId(), authRequest.getScope());
    }

    private final void validateResponse(Response response2) {
        if (response2.isSuccessful() || response2.code() == 302) {
            return;
        }
        Request request2 = response2.request();
        ResponseBody responseBody = response2.body();
        String string = "Failed request:  " + request2.method() + " " + request2.url() + "\n " + request2.headers() + ";\nresponse was: " + response2.code() + "\n " + response2.headers() + ";\n" + (responseBody != null ? responseBody.string() : null);
        throw new IllegalStateException(string.toString());
    }

    private final String getLocationHeader(Response response2) {
        String string = Response.header$default(response2, "Location", null, 2, null);
        if (string == null) {
            boolean bl = false;
            String string2 = "Location header is missing";
            throw new IllegalArgumentException(string2.toString());
        }
        return string;
    }

    private final Response fetchToken(AuthRequest authRequest, AuthContext context2, String code) {
        MultipartBody body = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM).addFormDataPart("grant_type", "authorization_code").addFormDataPart("client_id", authRequest.getClientId()).addFormDataPart("code", code).addFormDataPart("redirect_uri", "jetbrains://toolbox/jba/auth").addFormDataPart("code_verifier", context2.getCodeVerifier()).addFormDataPart("state", context2.getState()).build();
        Request request2 = new Request.Builder().url("https://oauth.account.jetbrains.com/oauth2/token").post(body).build();
        return this.client.newCall(request2).execute();
    }

    private final JetBrainsAccountSecureToken withRetry(int times, Function0<JetBrainsAccountSecureToken> block) {
        Throwable lastException = null;
        int n = 0;
        while (n < times) {
            int attempt = n++;
            boolean bl = false;
            try {
                return (JetBrainsAccountSecureToken)block.invoke();
            }
            catch (Throwable e) {
                lastException = e;
                Logger.INSTANCE.warn(e, "Failed to fetch token. Attempt " + attempt + "/" + times);
            }
        }
        Throwable throwable = lastException;
        if (throwable == null) {
            String string = "All attempts failed but not exception was caught";
            throw new IllegalStateException(string.toString());
        }
        throw throwable;
    }

    static /* synthetic */ JetBrainsAccountSecureToken withRetry$default(TestAuthenticationService testAuthenticationService, int n, Function0 function0, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return testAuthenticationService.withRetry(n, (Function0<JetBrainsAccountSecureToken>)function0);
    }

    @NotNull
    public final JetBrainsAccountSecureToken fetchToken(@NotNull AuthRequest authRequest) {
        Intrinsics.checkNotNullParameter((Object)authRequest, (String)"authRequest");
        return TestAuthenticationService.withRetry$default(this, 0, () -> TestAuthenticationService.fetchToken$lambda$17(this, authRequest), 1, null);
    }

    private static final CharSequence consent$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final JetBrainsAccountSecureToken fetchToken$lambda$17(TestAuthenticationService this$0, AuthRequest $authRequest) {
        JetBrainsAccountSecureToken jetBrainsAccountSecureToken;
        Object it;
        Object it2;
        Object it3;
        Object it4;
        Object it5;
        Object it6;
        AuthContext context2 = this$0.createContext($authRequest);
        Closeable closeable = this$0.loginRequest(context2);
        Object object = null;
        try {
            it6 = (Response)closeable;
            boolean bl = false;
            this$0.validateResponse((Response)it6);
            it6 = this$0.getLocationHeader((Response)it6);
        }
        catch (Throwable bl) {
            object = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Object loginRedirectUrl = it6;
        object = this$0.followRedirect((String)loginRedirectUrl);
        it6 = null;
        try {
            HttpUrl httpUrl;
            it5 = (Response)object;
            boolean bl = false;
            this$0.validateResponse((Response)it5);
            String location = this$0.getLocationHeader((Response)it5);
            try {
                httpUrl = HttpUrl.Companion.get(location);
            }
            catch (Throwable e) {
                ResponseBody responseBody = ((Response)it5).body();
                throw new IllegalStateException("Failed to parse sign in url: " + location + ";response was: " + ((Response)it5).code() + ",\n" + ((Response)it5).headers() + "\n" + (responseBody != null ? responseBody.string() : null), e);
            }
            it5 = httpUrl;
        }
        catch (Throwable bl) {
            it6 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)it6);
        }
        Object signInUrl = it5;
        it6 = this$0.signinRequest((HttpUrl)signInUrl, $authRequest);
        it5 = null;
        try {
            it4 = (Response)it6;
            boolean bl = false;
            this$0.validateResponse((Response)it4);
            it4 = this$0.getLocationHeader((Response)it4);
        }
        catch (Throwable bl) {
            it5 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it6, (Throwable)it5);
        }
        Object signInRedirectUrl = it4;
        it5 = this$0.followRedirect((String)signInRedirectUrl);
        it4 = null;
        try {
            HttpUrl httpUrl;
            it3 = (Response)it5;
            boolean bl = false;
            this$0.validateResponse((Response)it3);
            String location = this$0.getLocationHeader((Response)it3);
            try {
                httpUrl = HttpUrl.Companion.get(location);
            }
            catch (Throwable e) {
                ResponseBody responseBody = ((Response)it3).body();
                throw new IllegalStateException("Failed to parse consent url: " + location + ";response was: " + ((Response)it3).code() + ",\n" + ((Response)it3).headers() + "\n" + (responseBody != null ? responseBody.string() : null), e);
            }
            it3 = httpUrl;
        }
        catch (Throwable bl) {
            it4 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it5, (Throwable)it4);
        }
        Object consentUrl = it3;
        String string = ((HttpUrl)consentUrl).queryParameter("consent_challenge");
        if (string == null) {
            boolean $i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$challengeValue$22 = false;
            String $i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$challengeValue$22 = "consent_challenge is missing in " + (HttpUrl)consentUrl;
            throw new IllegalArgumentException($i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$challengeValue$22.toString());
        }
        String challengeValue = string;
        Closeable $i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$challengeValue$22 = this$0.consent(challengeValue, context2);
        Throwable bl = null;
        try {
            it2 = (Response)$i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$challengeValue$22;
            boolean bl2 = false;
            this$0.validateResponse((Response)it2);
            it2 = this$0.getLocationHeader((Response)it2);
        }
        catch (Throwable bl2) {
            bl = bl2;
            throw bl2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$challengeValue$22, (Throwable)bl);
        }
        Object consentChallengeRedirect = it2;
        String sessionID = URIExtensionsKt.parseQuery(new URI((String)consentChallengeRedirect)).get("authSessionId");
        if (sessionID == null) {
            boolean $i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$22 = false;
            String $i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$22 = "authSessionId is missing in " + (String)consentChallengeRedirect;
            throw new IllegalArgumentException($i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$22.toString());
        }
        String string2 = new URI("https://account.jetbrains.com/api/auth/sessions/" + sessionID).normalize().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Response authResponse = this$0.followRedirect(string2);
        this$0.validateResponse(authResponse);
        ResponseBody responseBody = authResponse.body();
        if (responseBody == null) {
            boolean $i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$body$22 = false;
            String $i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$body$22 = "authResponse body is missing";
            throw new IllegalArgumentException($i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$body$22.toString());
        }
        ResponseBody body = responseBody;
        String consentRedirectUrl = JsonKt.asString$default((JsonElement)JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(body.string())).get((Object)"returnTo"), null, 1, null);
        Closeable closeable2 = this$0.followRedirect(consentRedirectUrl);
        Throwable throwable = null;
        try {
            it = (Response)closeable2;
            boolean bl3 = false;
            this$0.validateResponse((Response)it);
            it = new URI(this$0.getLocationHeader((Response)it));
        }
        catch (Throwable bl3) {
            throwable = bl3;
            throw bl3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
        }
        Object it7 = it;
        boolean bl4 = false;
        Map<String, String> queries = URIExtensionsKt.parseQuery((URI)it7);
        String string3 = queries.get("code");
        if (string3 == null) {
            boolean bl5 = false;
            String string4 = "'code' is missing in " + queries;
            throw new IllegalArgumentException(string4.toString());
        }
        String tokenCode = string3;
        closeable2 = this$0.fetchToken($authRequest, context2, tokenCode);
        throwable = null;
        try {
            Response it8 = (Response)closeable2;
            boolean bl6 = false;
            this$0.validateResponse(it8);
            jetBrainsAccountSecureToken = this$0.buildTokenEntity(it8);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
        }
        return jetBrainsAccountSecureToken;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

