/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tbe.test.access;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AuthContext {
    @NotNull
    private final String codeVerifier;
    @NotNull
    private final String codeChallenge;
    @NotNull
    private final String state;
    @NotNull
    private final String clientId;
    @NotNull
    private final List<String> scope;

    public AuthContext(@NotNull String codeVerifier2, @NotNull String codeChallenge, @NotNull String state2, @NotNull String clientId, @NotNull List<String> scope2) {
        Intrinsics.checkNotNullParameter((Object)codeVerifier2, (String)"codeVerifier");
        Intrinsics.checkNotNullParameter((Object)codeChallenge, (String)"codeChallenge");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        this.codeVerifier = codeVerifier2;
        this.codeChallenge = codeChallenge;
        this.state = state2;
        this.clientId = clientId;
        this.scope = scope2;
    }

    @NotNull
    public final String getCodeVerifier() {
        return this.codeVerifier;
    }

    @NotNull
    public final String getCodeChallenge() {
        return this.codeChallenge;
    }

    @NotNull
    public final String getState() {
        return this.state;
    }

    @NotNull
    public final String getClientId() {
        return this.clientId;
    }

    @NotNull
    public final List<String> getScope() {
        return this.scope;
    }

    @NotNull
    public String toString() {
        return "AuthContext(codeVerifier=" + this.codeVerifier + ", codeChallenge=" + this.codeChallenge + ", state=" + this.state + ", clientId=" + this.clientId + ", scope=" + this.scope + ")";
    }

    public int hashCode() {
        int result2 = this.codeVerifier.hashCode();
        result2 = result2 * 31 + this.codeChallenge.hashCode();
        result2 = result2 * 31 + this.state.hashCode();
        result2 = result2 * 31 + this.clientId.hashCode();
        result2 = result2 * 31 + ((Object)this.scope).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AuthContext)) {
            return false;
        }
        AuthContext authContext = (AuthContext)other;
        if (!Intrinsics.areEqual((Object)this.codeVerifier, (Object)authContext.codeVerifier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.codeChallenge, (Object)authContext.codeChallenge)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.state, (Object)authContext.state)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clientId, (Object)authContext.clientId)) {
            return false;
        }
        return Intrinsics.areEqual(this.scope, authContext.scope);
    }
}

