/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.station.comms.services;

import com.intellij.station.comms.common.api.ServiceMetaInfo;
import com.intellij.station.comms.common.discovery.IntellijToolInformation;
import java.util.Set;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeConnection {
    @NotNull
    private final String connectionId;
    @NotNull
    private final String productCode;
    @NotNull
    private final String toolVersion;
    private final long pid;
    @NotNull
    private final String stationCommunicationAddress;
    @NotNull
    private final Set<String> knownEndpoints;
    @Nullable
    private final IntellijToolInformation intelliJToolInformation;

    public IdeConnection(@NotNull String connectionId, @NotNull String productCode, @NotNull String toolVersion, long pid, @NotNull String stationCommunicationAddress, @NotNull Set<String> knownEndpoints, @Nullable IntellijToolInformation intelliJToolInformation) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        Intrinsics.checkNotNullParameter((Object)toolVersion, (String)"toolVersion");
        Intrinsics.checkNotNullParameter((Object)stationCommunicationAddress, (String)"stationCommunicationAddress");
        Intrinsics.checkNotNullParameter(knownEndpoints, (String)"knownEndpoints");
        this.connectionId = connectionId;
        this.productCode = productCode;
        this.toolVersion = toolVersion;
        this.pid = pid;
        this.stationCommunicationAddress = stationCommunicationAddress;
        this.knownEndpoints = knownEndpoints;
        this.intelliJToolInformation = intelliJToolInformation;
    }

    @NotNull
    public final String getConnectionId() {
        return this.connectionId;
    }

    @NotNull
    public final String getProductCode() {
        return this.productCode;
    }

    @NotNull
    public final String getToolVersion() {
        return this.toolVersion;
    }

    public final long getPid() {
        return this.pid;
    }

    @NotNull
    public final String getStationCommunicationAddress() {
        return this.stationCommunicationAddress;
    }

    @Nullable
    public final IntellijToolInformation getIntelliJToolInformation() {
        return this.intelliJToolInformation;
    }

    public final boolean supports(@NotNull ServiceMetaInfo<?, ?> service) {
        Intrinsics.checkNotNullParameter(service, (String)"service");
        return this.knownEndpoints.contains(service.getEndpoint());
    }

    @NotNull
    public String toString() {
        return "IdeConnection(connectionId=" + this.connectionId + ", productCode=" + this.productCode + ", toolVersion=" + this.toolVersion + ", pid=" + this.pid + ", stationCommunicationAddress=" + this.stationCommunicationAddress + ", knownEndpoints=" + this.knownEndpoints + ", intelliJToolInformation=" + this.intelliJToolInformation + ")";
    }

    public int hashCode() {
        int result2 = this.connectionId.hashCode();
        result2 = result2 * 31 + this.productCode.hashCode();
        result2 = result2 * 31 + this.toolVersion.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.pid);
        result2 = result2 * 31 + this.stationCommunicationAddress.hashCode();
        result2 = result2 * 31 + ((Object)this.knownEndpoints).hashCode();
        result2 = result2 * 31 + (this.intelliJToolInformation == null ? 0 : this.intelliJToolInformation.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IdeConnection)) {
            return false;
        }
        IdeConnection ideConnection = (IdeConnection)other;
        if (!Intrinsics.areEqual((Object)this.connectionId, (Object)ideConnection.connectionId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.productCode, (Object)ideConnection.productCode)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.toolVersion, (Object)ideConnection.toolVersion)) {
            return false;
        }
        if (this.pid != ideConnection.pid) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stationCommunicationAddress, (Object)ideConnection.stationCommunicationAddress)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.knownEndpoints, ideConnection.knownEndpoints)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.intelliJToolInformation, (Object)ideConnection.intelliJToolInformation);
    }
}

