/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell.resolver;

import com.jetbrains.toolbox.interop.PlistResolver;
import com.jetbrains.toolbox.shell.model.ToolInfo;
import com.jetbrains.toolbox.shell.resolver.ExecutablePathResolver;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nMacExecutablePathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacExecutablePathResolver.kt\ncom/jetbrains/toolbox/shell/resolver/MacExecutablePathResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,20:1\n1#2:21\n*E\n"})
public final class MacExecutablePathResolver
implements ExecutablePathResolver {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final PlistResolver plistResolver;

    public MacExecutablePathResolver(@NotNull FileSystem fileSystem, @NotNull PlistResolver plistResolver) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)plistResolver, (String)"plistResolver");
        this.fileSystem = fileSystem;
        this.plistResolver = plistResolver;
    }

    @Override
    @NotNull
    public Path resolveExecutablePath(@NotNull ToolInfo tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        if (!this.fileSystem.exists(tool.getInstallDir())) {
            boolean bl = false;
            String string = "Failed to resolve executable path for " + tool.getInstallDir();
            throw new IllegalStateException(string.toString());
        }
        Path path2 = this.plistResolver.resolveExecutablePath(tool.getInstallDir());
        if (path2 == null) {
            throw new IllegalStateException(("Failed to read plist info of " + tool.getInstallDir()).toString());
        }
        return path2;
    }
}

