/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell.name;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.shell.model.ShellLauncherChannelExtensionKt;
import com.jetbrains.toolbox.shell.model.ShellLauncherToolExtension;
import com.jetbrains.toolbox.shell.model.ShellLauncherToolExtensionKt;
import com.jetbrains.toolbox.shell.name.ShellLauncherNameResolver;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class ShellLauncherNameResolverImpl
implements ShellLauncherNameResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OS.Type os;

    public ShellLauncherNameResolverImpl(@NotNull OS.Type os) {
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        this.os = os;
    }

    public /* synthetic */ ShellLauncherNameResolverImpl(OS.Type type2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            type2 = OS.INSTANCE.getType();
        }
        this(type2);
    }

    @Override
    @Nullable
    public String resolveName(@NotNull ToolInstance toolInstance) {
        Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
        String string = ShellLauncherChannelExtensionKt.getShellLauncherName(toolInstance.getChannel());
        if (string == null) {
            ShellLauncherToolExtension shellLauncherToolExtension = ShellLauncherToolExtensionKt.getShellLauncher(toolInstance.getTool());
            string = shellLauncherToolExtension != null ? shellLauncherToolExtension.getName() : null;
            if (string == null) {
                return null;
            }
        }
        String name2 = string;
        return this.os == OS.Type.Windows && !StringsKt.endsWith$default((String)name2, (String)".cmd", (boolean)false, (int)2, null) ? name2 + ".cmd" : name2;
    }

    public ShellLauncherNameResolverImpl() {
        this(null, 1, null);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

