/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell.generator;

import com.jetbrains.toolbox.shell.generator.AbstractShellLauncherGenerator;
import com.jetbrains.toolbox.shell.model.ToolInfo;
import com.jetbrains.toolbox.shell.resolver.ExecutableResolver;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;

public final class WindowsBashLauncherGenerator
extends AbstractShellLauncherGenerator {
    @NotNull
    private final String applicationFullNameVersion;
    @NotNull
    private final ExecutableResolver basicExecutableResolver;
    @NotNull
    private final ExecutableResolver fleetExecutableResolver;

    public WindowsBashLauncherGenerator(@NotNull String applicationFullNameVersion, @NotNull ExecutableResolver basicExecutableResolver, @NotNull ExecutableResolver fleetExecutableResolver) {
        Intrinsics.checkNotNullParameter((Object)applicationFullNameVersion, (String)"applicationFullNameVersion");
        Intrinsics.checkNotNullParameter((Object)basicExecutableResolver, (String)"basicExecutableResolver");
        Intrinsics.checkNotNullParameter((Object)fleetExecutableResolver, (String)"fleetExecutableResolver");
        this.applicationFullNameVersion = applicationFullNameVersion;
        this.basicExecutableResolver = basicExecutableResolver;
        this.fleetExecutableResolver = fleetExecutableResolver;
    }

    @Override
    @NotNull
    protected String getApplicationFullNameVersion() {
        return this.applicationFullNameVersion;
    }

    @Override
    @NotNull
    public String generateShellScript(@NotNull ToolInfo tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        ExecutableResolver resolver = switch (WhenMappings.$EnumSwitchMapping$0[tool.getAppType().ordinal()]) {
            case 1 -> this.basicExecutableResolver;
            case 2 -> this.fleetExecutableResolver;
            default -> throw new NoWhenBranchMatchedException();
        };
        Path executable = resolver.resolveExecutablePath(tool);
        return StringsKt.trimMargin$default((String)("\n      |#!/usr/bin/env bash\n      |#" + this.createHeaderComment() + "\n      |\n      |if command -v wslpath > /dev/null; then\n      |  \"$(wslpath \"" + executable + "\")\" \"$@\";\n      |elif command -v cygpath > /dev/null; then\n      |  \"$(cygpath \"" + executable + "\")\" \"$@\";\n      |else\n      |  MSYS_NO_PATHCONV=1 cmd.exe /C \"" + tool.getLauncherName() + "\" \"$@\"\n      |fi\n    "), null, (int)1, null);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToolInfo.AppType.values().length];
            try {
                nArray[ToolInfo.AppType.IntellijBased.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolInfo.AppType.Fleet.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

