/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell.creator;

import com.jetbrains.toolbox.shell.creator.ShellLauncherCreator;
import com.jetbrains.toolbox.shell.model.ToolInfo;
import com.jetbrains.toolbox.shell.resolver.ExecutableResolver;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nSymlinkCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymlinkCreator.kt\ncom/jetbrains/toolbox/shell/creator/SymlinkCreator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,28:1\n1#2:29\n*E\n"})
public final class SymlinkCreator
implements ShellLauncherCreator {
    @NotNull
    private final ExecutableResolver resolver;
    @NotNull
    private final FileSystem fileSystem;

    public SymlinkCreator(@NotNull ExecutableResolver resolver, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.resolver = resolver;
        this.fileSystem = fileSystem;
    }

    @Override
    public void createLauncher(@NotNull ToolInfo tool, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileMetadata fileMetadata2 = this.fileSystem.metadataOrNull(file);
        if (!(!(fileMetadata2 != null ? fileMetadata2.isDirectory() : false))) {
            boolean bl = false;
            String string = "Unable to create symlink at '" + file + "' because there is a directory at this path.";
            throw new IllegalStateException(string.toString());
        }
        Path path2 = file.parent();
        if (path2 != null) {
            Path path3 = path2;
            FileSystem fileSystem = this.fileSystem;
            Path p0 = path3;
            boolean bl = false;
            fileSystem.createDirectories(p0);
        }
        Path executable = this.resolver.resolveExecutablePath(tool);
        this.fileSystem.delete(file);
        this.fileSystem.createSymlink(file, executable);
    }
}

