/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.settings;

import com.jetbrains.toolbox.i18n.UILanguage;
import com.jetbrains.toolbox.settings.BackgroundEffects;
import com.jetbrains.toolbox.settings.Theme;
import com.jetbrains.toolbox.settings.UISettings$;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
public final class UISettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String hotkey;
    @NotNull
    private final Theme theme;
    @NotNull
    private final UILanguage language;
    @NotNull
    private final BackgroundEffects backgroundEffects;
    private final float scale;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public UISettings(@NotNull String hotkey, @NotNull Theme theme, @NotNull UILanguage language, @NotNull BackgroundEffects backgroundEffects, float scale2) {
        Intrinsics.checkNotNullParameter((Object)hotkey, (String)"hotkey");
        Intrinsics.checkNotNullParameter((Object)((Object)theme), (String)"theme");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)((Object)backgroundEffects), (String)"backgroundEffects");
        this.hotkey = hotkey;
        this.theme = theme;
        this.language = language;
        this.backgroundEffects = backgroundEffects;
        this.scale = scale2;
    }

    public /* synthetic */ UISettings(String string, Theme theme, UILanguage uILanguage, BackgroundEffects backgroundEffects, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            theme = Theme.System;
        }
        if ((n & 4) != 0) {
            uILanguage = UILanguage.EN;
        }
        if ((n & 8) != 0) {
            backgroundEffects = BackgroundEffects.AlwaysOn;
        }
        if ((n & 0x10) != 0) {
            f = 1.0f;
        }
        this(string, theme, uILanguage, backgroundEffects, f);
    }

    @NotNull
    public final String getHotkey() {
        return this.hotkey;
    }

    @NotNull
    public final Theme getTheme() {
        return this.theme;
    }

    @NotNull
    public final UILanguage getLanguage() {
        return this.language;
    }

    @NotNull
    public final BackgroundEffects getBackgroundEffects() {
        return this.backgroundEffects;
    }

    public final float getScale() {
        return this.scale;
    }

    @NotNull
    public final UISettings copy(@NotNull String hotkey, @NotNull Theme theme, @NotNull UILanguage language, @NotNull BackgroundEffects backgroundEffects, float scale2) {
        Intrinsics.checkNotNullParameter((Object)hotkey, (String)"hotkey");
        Intrinsics.checkNotNullParameter((Object)((Object)theme), (String)"theme");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)((Object)backgroundEffects), (String)"backgroundEffects");
        return new UISettings(hotkey, theme, language, backgroundEffects, scale2);
    }

    public static /* synthetic */ UISettings copy$default(UISettings uISettings, String string, Theme theme, UILanguage uILanguage, BackgroundEffects backgroundEffects, float f, int n, Object object) {
        if ((n & 1) != 0) {
            string = uISettings.hotkey;
        }
        if ((n & 2) != 0) {
            theme = uISettings.theme;
        }
        if ((n & 4) != 0) {
            uILanguage = uISettings.language;
        }
        if ((n & 8) != 0) {
            backgroundEffects = uISettings.backgroundEffects;
        }
        if ((n & 0x10) != 0) {
            f = uISettings.scale;
        }
        return uISettings.copy(string, theme, uILanguage, backgroundEffects, f);
    }

    @NotNull
    public String toString() {
        return "UISettings(hotkey=" + this.hotkey + ", theme=" + this.theme + ", language=" + this.language + ", backgroundEffects=" + this.backgroundEffects + ", scale=" + this.scale + ")";
    }

    public int hashCode() {
        int result2 = this.hotkey.hashCode();
        result2 = result2 * 31 + this.theme.hashCode();
        result2 = result2 * 31 + this.language.hashCode();
        result2 = result2 * 31 + this.backgroundEffects.hashCode();
        result2 = result2 * 31 + Float.hashCode(this.scale);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UISettings)) {
            return false;
        }
        UISettings uISettings = (UISettings)other;
        if (!Intrinsics.areEqual((Object)this.hotkey, (Object)uISettings.hotkey)) {
            return false;
        }
        if (this.theme != uISettings.theme) {
            return false;
        }
        if (this.language != uISettings.language) {
            return false;
        }
        if (this.backgroundEffects != uISettings.backgroundEffects) {
            return false;
        }
        return Float.compare(this.scale, uISettings.scale) == 0;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$settings_api(UISettings self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        if (output2.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual((Object)self.hotkey, (Object)"")) {
            output2.encodeStringElement(serialDesc, 0, self.hotkey);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 1) ? true : self.theme != Theme.System) {
            output2.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)lazyArray[1].getValue(), (Object)self.theme);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 2) ? true : self.language != UILanguage.EN) {
            output2.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), (Object)self.language);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 3) ? true : self.backgroundEffects != BackgroundEffects.AlwaysOn) {
            output2.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)lazyArray[3].getValue(), (Object)self.backgroundEffects);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 4) ? true : Float.compare(self.scale, 1.0f) != 0) {
            output2.encodeFloatElement(serialDesc, 4, self.scale);
        }
    }

    public /* synthetic */ UISettings(int seen0, String hotkey, Theme theme, UILanguage language, BackgroundEffects backgroundEffects, float scale2, SerializationConstructorMarker serializationConstructorMarker) {
        if ((0 & seen0) != 0) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.hotkey = (seen0 & 1) == 0 ? "" : hotkey;
        this.theme = (seen0 & 2) == 0 ? Theme.System : theme;
        this.language = (seen0 & 4) == 0 ? UILanguage.EN : language;
        this.backgroundEffects = (seen0 & 8) == 0 ? BackgroundEffects.AlwaysOn : backgroundEffects;
        this.scale = (seen0 & 0x10) == 0 ? 1.0f : scale2;
    }

    public UISettings() {
        this(null, null, null, null, 0.0f, 31, null);
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> Theme.Companion.serializer()), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> UILanguage.Companion.serializer()), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> BackgroundEffects.Companion.serializer()), null};
        $childSerializers = lazyArray;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<UISettings> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

