/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.services;

import com.jetbrains.toolbox.datamodel.ServiceGenerator;
import com.jetbrains.toolbox.datamodel.ServiceInstance;
import com.jetbrains.toolbox.feed.Service;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

public abstract class ServiceGeneratorImpl<I extends ServiceInstance>
implements ServiceGenerator<I> {
    @NotNull
    private final String id;
    private final boolean allowsMultipleInstances;
    private final boolean visible;
    @NotNull
    private final MutableStateFlow<Service> _info;
    @NotNull
    private final StateFlow<Service> info;
    @NotNull
    private final String fusId;

    public ServiceGeneratorImpl(@NotNull String id, boolean allowsMultipleInstances, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.allowsMultipleInstances = allowsMultipleInstances;
        this.visible = visible;
        this._info = StateFlowKt.MutableStateFlow((Object)new Service(this.id, null, null, null, null, 30, null));
        this.info = FlowKt.asStateFlow(this._info);
        this.fusId = this.id;
    }

    @Override
    @NotNull
    public final String getId() {
        return this.id;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    @NotNull
    public StateFlow<Service> getInfo() {
        return this.info;
    }

    @Override
    public boolean update(@NotNull Service service) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        boolean it = bl = Intrinsics.areEqual((Object)this.id, (Object)service.getId());
        boolean bl2 = false;
        if (it) {
            this._info.setValue((Object)service);
        }
        return bl;
    }

    @NotNull
    public String toString() {
        return ((Service)this._info.getValue()).toString();
    }

    @Override
    @NotNull
    public String getFusId() {
        return this.fusId;
    }

    @Override
    public boolean matches(@NotNull String filter2, @NotNull I18n i18n) {
        return ServiceGenerator.super.matches(filter2, i18n);
    }
}

