/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.services;

import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.datamodel.DataloreServiceConfig;
import com.jetbrains.toolbox.datamodel.DataloreServiceInstance;
import com.jetbrains.toolbox.datamodel.ServiceConfig;
import com.jetbrains.toolbox.integration.UrlHandler;
import com.jetbrains.toolbox.services.ServiceGeneratorImpl;
import com.jetbrains.toolbox.settings.Storage;
import com.jetbrains.toolbox.settings.StorageManager;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nDataloreServiceGeneratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataloreServiceGeneratorImpl.kt\ncom/jetbrains/toolbox/services/DataloreServiceGeneratorImpl\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,44:1\n230#2,5:45\n230#2,5:50\n*S KotlinDebug\n*F\n+ 1 DataloreServiceGeneratorImpl.kt\ncom/jetbrains/toolbox/services/DataloreServiceGeneratorImpl\n*L\n22#1:45,5\n31#1:50,5\n*E\n"})
public final class DataloreServiceGeneratorImpl
extends ServiceGeneratorImpl<DataloreServiceInstance> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final UrlHandler urlHandler;
    @NotNull
    private final MutableStateFlow<DataloreServiceInstance> _instance;
    @NotNull
    private final StateFlow<List<DataloreServiceInstance>> serviceInstances;

    public DataloreServiceGeneratorImpl(@NotNull StorageManager storageManager, @NotNull UrlHandler urlHandler) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)urlHandler, (String)"urlHandler");
        super("Datalore", false, true);
        this.storageManager = storageManager;
        this.urlHandler = urlHandler;
        this._instance = StateFlowKt.MutableStateFlow((Object)(((Storage)this.storageManager.getStorage().getValue()).getDataloreConnected() ? new DataloreServiceInstance(this) : null));
        this.serviceInstances = FlowExtensionsKt.mapState((StateFlow)this._instance, DataloreServiceGeneratorImpl::serviceInstances$lambda$0);
    }

    @Override
    @NotNull
    public StateFlow<List<DataloreServiceInstance>> getServiceInstances() {
        return this.serviceInstances;
    }

    @Override
    @Nullable
    public Object connect(@NotNull ServiceConfig config, @NotNull Continuation<? super Unit> $completion) {
        Storage it;
        Storage nextValue$iv;
        Object prevValue$iv;
        if (!(config instanceof DataloreServiceConfig)) {
            return Unit.INSTANCE;
        }
        MutableStateFlow<Storage> $this$update$iv = this.storageManager.getStorage();
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (Storage)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Storage.copy-sSrm3y0$default(it, false, false, null, null, null, null, null, null, true, 0L, false, null, null, false, null, 32511, null))));
        DataloreServiceInstance instance2 = new DataloreServiceInstance(this);
        this._instance.setValue((Object)instance2);
        this.urlHandler.openUrl("https://www.jetbrains.com/datalore?utm_source=product&utm_medium=link&utm_campaign=TBA");
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object disconnect(@NotNull String instanceId, @NotNull Continuation<? super Unit> $completion) {
        Storage it;
        Storage nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<Storage> $this$update$iv = this.storageManager.getStorage();
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (Storage)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Storage.copy-sSrm3y0$default(it, false, false, null, null, null, null, null, null, false, 0L, false, null, null, false, null, 32511, null))));
        this._instance.setValue(null);
        return Unit.INSTANCE;
    }

    @Override
    public boolean getRequiresLogin() {
        return false;
    }

    private static final List serviceInstances$lambda$0(DataloreServiceInstance it) {
        return CollectionsKt.listOfNotNull((Object)it);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

