/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.rpc.metrics;

import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.common.formatting.HumanMemorySizeKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.function.BiFunction;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.selects.OnTimeoutKt;
import kotlinx.coroutines.selects.SelectBuilder;
import kotlinx.coroutines.selects.SelectImplementation;
import kotlinx.rpc.krpc.KrpcTransportMessage;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nTransportMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportMetrics.kt\ncom/jetbrains/toolbox/rpc/metrics/TransportMetrics\n+ 2 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n7#2,2:85\n9#2,5:88\n222#3:87\n1#4:93\n*S KotlinDebug\n*F\n+ 1 TransportMetrics.kt\ncom/jetbrains/toolbox/rpc/metrics/TransportMetrics\n*L\n62#1:85,2\n62#1:88,5\n62#1:87\n*E\n"})
public final class TransportMetrics {
    @NotNull
    private final String name;
    private final long debounceTimeout;
    @NotNull
    private final Channel<Pair<String, Integer>> logChannel;
    @NotNull
    private final Regex regex;

    private TransportMetrics(String name2, CoroutineScope scope2, long debounceTimeout) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.name = name2;
        this.debounceTimeout = debounceTimeout;
        this.logChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.regex = new Regex("\\d+:(?:.+\\.)*(?<class>.+)\\.`\\$rpcServiceStub`\\.`(?<method>.+)\\$rpcMethod`:\\d+");
        BuildersKt.launch$default((CoroutineScope)scope2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ TransportMetrics this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var24_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        map = new LinkedHashMap<K, V>();
lbl7:
                        // 3 sources

                        while (true) {
                            var4_5 = this.this$0;
                            $i$f$select = 0;
                            $this$select_u24lambda_u240$iv = new SelectImplementation(this.getContext());
                            $i$a$-run-SelectKt$select$2$iv = 0;
                            $this$invokeSuspend_u24lambda_u240 = (SelectBuilder)$this$select_u24lambda_u240$iv;
                            $i$a$-select-TransportMetrics$1$message$1 = false;
                            $this$invokeSuspend_u24lambda_u240.invoke(TransportMetrics.access$getLogChannel$p(var4_5).getOnReceive(), (Function2)new Function2<Pair<? extends String, ? extends Integer>, Continuation<? super Pair<? extends String, ? extends Integer>>, Object>(null){
                                int label;
                                /* synthetic */ Object L$0;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Pair pair = (Pair)this.L$0;
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            void it;
                                            ResultKt.throwOnFailure((Object)$result);
                                            return it;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value2;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(Pair<String, Integer> p1, Continuation<? super Pair<String, Integer>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            });
                            if (map.isEmpty() == false) {
                                OnTimeoutKt.onTimeout-8Mi8wO0((SelectBuilder)$this$invokeSuspend_u24lambda_u240, (long)TransportMetrics.access$getDebounceTimeout$p(var4_5), (Function1)((Function1)new Function1<Continuation<? super Pair<? extends String, ? extends Integer>>, Object>(null){
                                    int label;

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                return null;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(Continuation<? super Pair<String, Integer>> p1) {
                                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }));
                            }
                            this.L$0 = map;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$select_u24lambda_u240$iv);
                            this.I$0 = $i$f$select;
                            this.I$1 = $i$a$-run-SelectKt$select$2$iv;
                            this.label = 1;
                            v0 = $this$select_u24lambda_u240$iv.doSelect((Continuation)this);
                            if (v0 == var24_2) {
                                return var24_2;
                            }
                            ** GOTO lbl37
                            break;
                        }
                    }
                    case 1: {
                        $i$a$-run-SelectKt$select$2$iv = this.I$1;
                        $i$f$select = this.I$0;
                        $this$select_u24lambda_u240$iv = (SelectImplementation)this.L$1;
                        map = (Map)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl37:
                        // 2 sources

                        message = (Pair)v0;
                        if (message == null) ** GOTO lbl44
                        callId = (String)message.component1();
                        size = ((Number)message.component2()).intValue();
                        map.compute(callId, (BiFunction<Object, Object, Metric>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$2(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)Lcom/jetbrains/toolbox/rpc/metrics/TransportMetrics$Metric;)((Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$1(int java.lang.String com.jetbrains.toolbox.rpc.metrics.TransportMetrics$Metric ), (Ljava/lang/String;Lcom/jetbrains/toolbox/rpc/metrics/TransportMetrics$Metric;)Lcom/jetbrains/toolbox/rpc/metrics/TransportMetrics$Metric;)((int)size)));
                        ** GOTO lbl7
lbl44:
                        // 1 sources

                        var5_7 = this.this$0;
                        $this$invokeSuspend_u24lambda_u246 = var6_8 = new StringBuilder();
                        $i$a$-buildString-TransportMetrics$1$message$2 = false;
                        $this$invokeSuspend_u24lambda_u246.append(TransportMetrics.access$getName$p(var5_7)).append('\n');
                        $this$sortedByDescending$iv = map.entrySet();
                        $i$f$sortedByDescending = false;
                        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                Map.Entry it = (Map.Entry)b;
                                boolean bl = false;
                                Comparable comparable = Long.valueOf(((Metric)it.getValue()).getTotalSize());
                                it = (Map.Entry)a;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(((Metric)it.getValue()).getTotalSize()));
                            }
                        });
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            var13_16 = (Map.Entry)element$iv;
                            $i$a$-forEach-TransportMetrics$1$message$2$2 = false;
                            key = (String)var13_16.getKey();
                            metric = (Metric)var13_16.getValue();
                            $this$invokeSuspend_u24lambda_u246.append(StringsKt.padEnd$default((String)key, (int)60, (char)'\u0000', (int)2, null) + ": " + StringsKt.padEnd$default((String)TransportMetrics.access$getBytes(var5_7, metric.getTotalSize()), (int)11, (char)'\u0000', (int)2, null) + "= " + StringsKt.padEnd$default((String)TransportMetrics.access$getBytes(var5_7, metric.getAvgSize()), (int)11, (char)'\u0000', (int)2, null) + "*" + metric.getCount()).append('\n');
                        }
                        var9_11 = $this$invokeSuspend_u24lambda_u246;
                        var10_13 = map.values();
                        var17_22 = var5_7;
                        var18_23 = 0L;
                        for (E var14_18 : var10_13) {
                            key = (Metric)var14_18;
                            var20_24 = var18_23;
                            $i$a$-sumOfLong-TransportMetrics$1$message$2$3 = false;
                            var22_25 = it.getTotalSize();
                            var18_23 = var20_24 + var22_25;
                        }
                        var20_24 = var18_23;
                        var9_11.append("Total: " + TransportMetrics.access$getBytes(var17_22, var20_24)).append('\n');
                        message = var6_8.toString();
                        Logger.INSTANCE.debug(message);
                        map.clear();
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Metric invokeSuspend$lambda$1(int $size, String string, Metric m) {
                Metric metric = m;
                if (metric == null) {
                    metric = new Metric(0, 0L);
                }
                Metric metric2 = metric;
                return metric2.copy(metric2.getCount() + 1, metric2.getTotalSize() + (long)$size);
            }

            private static final Metric invokeSuspend$lambda$2(Function2 $tmp0, Object p0, Object p1) {
                return (Metric)$tmp0.invoke(p0, p1);
            }
        }), (int)3, null);
    }

    public /* synthetic */ TransportMetrics(String string, CoroutineScope coroutineScope, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
        }
        this(string, coroutineScope, l, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object log(@NotNull KrpcTransportMessage message2, @NotNull Continuation<? super Unit> $completion) {
        Object object;
        KrpcTransportMessage.StringMessage stringMessage = message2 instanceof KrpcTransportMessage.StringMessage ? (KrpcTransportMessage.StringMessage)message2 : null;
        if (stringMessage == null) {
            return Unit.INSTANCE;
        }
        KrpcTransportMessage.StringMessage msg = stringMessage;
        boolean $i$f$catching = false;
        try {
            void this_$iv;
            boolean bl = false;
            Json json2 = JsonKt.getJsonx();
            String string$iv = msg.getValue();
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            Object object2 = (JsonElement)((JsonObject)this_$iv.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), string$iv)).get((Object)"callId");
            object = Result.constructor-impl(object2 != null && (object2 = JsonElementKt.getJsonPrimitive((JsonElement)object2)) != null && (object2 = object2.getContent()) != null ? this.shorten((String)object2) : null);
        }
        catch (CancellationException c$iv) {
            throw c$iv;
        }
        catch (Throwable t$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
        }
        Object object3 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            boolean bl = false;
            Logger.INSTANCE.error("Failed to parse '" + msg.getValue() + "': " + it.getMessage());
        }
        String string = (String)(Result.isFailure-impl((Object)object3) ? null : object3);
        if (string == null) {
            return Unit.INSTANCE;
        }
        String callId = string;
        Object object4 = this.logChannel.send((Object)TuplesKt.to((Object)callId, (Object)Boxing.boxInt((int)msg.getValue().length())), $completion);
        if (object4 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object4;
        }
        return Unit.INSTANCE;
    }

    private final String shorten(String $this$shorten) {
        MatchResult matchResult = this.regex.matchEntire((CharSequence)$this$shorten);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
            return $this$shorten;
        }
        MatchResult groups = matchResult;
        Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"class");
        if (object == null || (object = object.getValue()) == null) {
            return $this$shorten;
        }
        Object clazz = object;
        Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"method");
        if (object2 == null || (object2 = object2.getValue()) == null) {
            return $this$shorten;
        }
        Object method = object2;
        return (String)clazz + "." + (String)method;
    }

    private final String getBytes(long $this$bytes) {
        return HumanMemorySizeKt.humanFileSize($this$bytes, $this$bytes < 1024L ? 0 : 1);
    }

    public /* synthetic */ TransportMetrics(String name2, CoroutineScope scope2, long debounceTimeout, DefaultConstructorMarker $constructor_marker) {
        this(name2, scope2, debounceTimeout);
    }

    public static final /* synthetic */ Channel access$getLogChannel$p(TransportMetrics $this) {
        return $this.logChannel;
    }

    public static final /* synthetic */ long access$getDebounceTimeout$p(TransportMetrics $this) {
        return $this.debounceTimeout;
    }

    public static final /* synthetic */ String access$getBytes(TransportMetrics $this, long $receiver) {
        return $this.getBytes($receiver);
    }

    public static final /* synthetic */ String access$getName$p(TransportMetrics $this) {
        return $this.name;
    }

    public static final class Metric {
        private final int count;
        private final long totalSize;
        private final long avgSize;

        public Metric(int count, long totalSize) {
            this.count = count;
            this.totalSize = totalSize;
            this.avgSize = this.count == 0 ? 0L : this.totalSize / (long)this.count;
        }

        public final int getCount() {
            return this.count;
        }

        public final long getTotalSize() {
            return this.totalSize;
        }

        public final long getAvgSize() {
            return this.avgSize;
        }

        public final int component1() {
            return this.count;
        }

        public final long component2() {
            return this.totalSize;
        }

        @NotNull
        public final Metric copy(int count, long totalSize) {
            return new Metric(count, totalSize);
        }

        public static /* synthetic */ Metric copy$default(Metric metric, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = metric.count;
            }
            if ((n2 & 2) != 0) {
                l = metric.totalSize;
            }
            return metric.copy(n, l);
        }

        @NotNull
        public String toString() {
            return "Metric(count=" + this.count + ", totalSize=" + this.totalSize + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.count);
            result2 = result2 * 31 + Long.hashCode(this.totalSize);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Metric)) {
                return false;
            }
            Metric metric = (Metric)other;
            if (this.count != metric.count) {
                return false;
            }
            return this.totalSize == metric.totalSize;
        }
    }
}

