/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.resharper.vs;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.interop.Win32Registry;
import com.jetbrains.toolbox.resharper.model.VisualStudioInstance;
import com.jetbrains.toolbox.resharper.vs.VisualStudioDetector;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.tinylog.kotlin.Logger;

@VisibleForTesting
public final class VisualStudio2015MinusDetector
implements VisualStudioDetector {
    @NotNull
    private final Win32Registry win32Registry;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Map<String, String> ourVsMarketingVersionsMap;
    @NotNull
    private final String vsBaseRegPath;

    public VisualStudio2015MinusDetector(@NotNull Win32Registry win32Registry, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)win32Registry, (String)"win32Registry");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.win32Registry = win32Registry;
        this.fileSystem = fileSystem;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"8.0", (Object)"2005"), TuplesKt.to((Object)"9.0", (Object)"2008"), TuplesKt.to((Object)"10.0", (Object)"2010"), TuplesKt.to((Object)"11.0", (Object)"2012"), TuplesKt.to((Object)"12.0", (Object)"2013"), TuplesKt.to((Object)"14.0", (Object)"2015"), TuplesKt.to((Object)"15.0", (Object)"2017")};
        this.ourVsMarketingVersionsMap = MapsKt.mapOf((Pair[])pairArray);
        this.vsBaseRegPath = "SOFTWARE\\Microsoft\\VisualStudio";
    }

    @Override
    @NotNull
    public Set<VisualStudioInstance> detectVisualStudioInstances() {
        Set set2;
        Set $this$detectVisualStudioInstances_u24lambda_u240 = set2 = SetsKt.createSetBuilder();
        boolean bl = false;
        Object[] objectArray = new Boolean[]{true, false};
        Iterator iterator2 = CollectionsKt.listOf((Object[])objectArray).iterator();
        while (iterator2.hasNext()) {
            boolean wow6432 = (Boolean)iterator2.next();
            for (String vsVersion : this.win32Registry.listKeys(Win32Registry.Hive.HKLM.INSTANCE, this.vsBaseRegPath, wow6432)) {
                CollectionsKt.addAll((Collection)$this$detectVisualStudioInstances_u24lambda_u240, this.detectAllInstances(vsVersion, wow6432));
            }
        }
        return SetsKt.build((Set)set2);
    }

    private final Sequence<VisualStudioInstance> detectAllInstances(String vsVersion, boolean wow6432) {
        Path installDir;
        String string = this.win32Registry.readValue(Win32Registry.Hive.HKLM.INSTANCE, this.vsBaseRegPath + "\\" + vsVersion, "InstallDir", wow6432);
        Path path2 = installDir = string != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null) : null;
        if (installDir == null || !this.fileSystem.exists(installDir)) {
            return SequencesKt.emptySequence();
        }
        Path devenvExe = installDir.resolve("devenv.exe");
        if (!this.fileSystem.exists(devenvExe)) {
            Logger.INSTANCE.info("InstallDir for Visual Studio " + installDir + " is present, but executable " + devenvExe + " is missing");
            return SequencesKt.emptySequence();
        }
        Logger.INSTANCE.info("Detected Visual Studio version " + vsVersion + " at " + installDir);
        String string2 = this.ourVsMarketingVersionsMap.get(vsVersion);
        if (string2 == null) {
            string2 = vsVersion;
        }
        String displayName = "Visual Studio " + string2;
        String string3 = BuildNumber.constructor-impl(vsVersion);
        Sequence systemInstance = SequencesKt.sequenceOf((Object)new VisualStudioInstance(null, displayName, string3, "", devenvExe, null));
        Sequence userInstances2 = SequencesKt.map((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.win32Registry.listKeys(Win32Registry.Hive.HKCU.INSTANCE, this.vsBaseRegPath, wow6432)), arg_0 -> VisualStudio2015MinusDetector.detectAllInstances$lambda$1(vsVersion, arg_0)), arg_0 -> VisualStudio2015MinusDetector.detectAllInstances$lambda$2(vsVersion, arg_0)), VisualStudio2015MinusDetector::detectAllInstances$lambda$3), arg_0 -> VisualStudio2015MinusDetector.detectAllInstances$lambda$4(vsVersion, displayName, devenvExe, arg_0));
        return SequencesKt.plus((Sequence)systemInstance, (Sequence)userInstances2);
    }

    private static final boolean detectAllInstances$lambda$1(String $vsVersion, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$vsVersion) && StringsKt.startsWith$default((String)it, (String)$vsVersion, (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it, (String)($vsVersion + "_"), (boolean)false, (int)2, null);
    }

    private static final String detectAllInstances$lambda$2(String $vsVersion, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.removePrefix((String)it, (CharSequence)$vsVersion);
    }

    private static final Unit detectAllInstances$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger.INSTANCE.info("Detected Visual Studio User Hive " + it);
        return Unit.INSTANCE;
    }

    private static final VisualStudioInstance detectAllInstances$lambda$4(String $vsVersion, String $displayName, Path $devenvExe, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = BuildNumber.constructor-impl($vsVersion);
        return new VisualStudioInstance(null, $displayName, string, it, $devenvExe, null);
    }
}

