/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.resharper;

import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.resharper.DotNetToolDetector;
import com.jetbrains.toolbox.resharper.DotNetToolExecutableNameResolver;
import com.jetbrains.toolbox.resharper.dto.PackagesDto;
import com.jetbrains.toolbox.resharper.model.InstalledDotNetTool;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.tinylog.kotlin.Logger;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nDotNetToolDetectorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetToolDetectorImpl.kt\ncom/jetbrains/toolbox/resharper/DotNetToolDetectorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Okio.kt\nokio/Okio__OkioKt\n+ 5 FileSystem.kt\nokio/FileSystem\n+ 6 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,94:1\n1208#2,2:95\n1236#2,4:97\n1625#2:101\n1869#2:102\n1870#2:104\n1626#2:105\n2756#2:106\n1#3:103\n1#3:107\n66#4:108\n52#4,4:110\n60#4,10:116\n56#4,3:126\n71#4,3:129\n67#5:109\n68#5:114\n80#6:115\n183#7,2:132\n*S KotlinDebug\n*F\n+ 1 DotNetToolDetectorImpl.kt\ncom/jetbrains/toolbox/resharper/DotNetToolDetectorImpl\n*L\n25#1:95,2\n25#1:97,4\n35#1:101\n35#1:102\n35#1:104\n35#1:105\n36#1:106\n35#1:103\n36#1:107\n47#1:108\n47#1:110,4\n47#1:116,10\n47#1:126,3\n47#1:129,3\n47#1:109\n47#1:114\n47#1:115\n81#1:132,2\n*E\n"})
public final class DotNetToolDetectorImpl
implements DotNetToolDetector {
    @NotNull
    private final DotNetToolExecutableNameResolver executableNameResolver;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path installRoot;
    @NotNull
    private final Map<String, InstalledDotNetTool.Type> types;

    /*
     * WARNING - void declaration
     */
    public DotNetToolDetectorImpl(@NotNull DotNetToolExecutableNameResolver executableNameResolver, @NotNull FileSystem fileSystem) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)executableNameResolver, (String)"executableNameResolver");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.executableNameResolver = executableNameResolver;
        this.fileSystem = fileSystem;
        this.installRoot = StandardPaths.INSTANCE.getLocalAppData().resolve("JetBrains").resolve("Installations");
        Iterable iterable = (Iterable)InstalledDotNetTool.Type.getEntries();
        DotNetToolDetectorImpl dotNetToolDetectorImpl = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            InstalledDotNetTool.Type type2 = (InstalledDotNetTool.Type)((Object)element$iv$iv);
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getShortName(), element$iv$iv);
        }
        dotNetToolDetectorImpl.types = destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<InstalledDotNetTool> detectInstalledDotNetTools() {
        Iterable iterable;
        void $this$mapNotNullTo$iv;
        Logger.INSTANCE.info(".NET tools install root: " + this.installRoot);
        if (!this.fileSystem.exists(this.installRoot) || !this.fileSystem.metadata(this.installRoot).isDirectory()) {
            Logger.INSTANCE.info(".NET tools install root not found at " + this.installRoot);
            return SetsKt.emptySet();
        }
        Iterable iterable2 = this.fileSystem.list(this.installRoot);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            InstalledDotNetTool it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Path p0 = (Path)element$iv;
            boolean bl2 = false;
            if (this.parsePackagesFile(p0) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Iterable $this$onEach$iv = destination$iv;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
            InstalledDotNetTool it = (InstalledDotNetTool)element$iv;
            boolean bl4 = false;
            Logger.INSTANCE.info("Discovered installed JetBrains .NET tools: " + it);
        }
        return (Set)iterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final InstalledDotNetTool parsePackagesFile(Path installDir) {
        Path packagesFile = installDir.resolve("packages");
        if (!this.fileSystem.exists(packagesFile)) {
            Logger.INSTANCE.info("Packages file is missing, skipping directory: " + installDir);
            return null;
        }
        try {
            InstalledDotNetTool.Tool tool;
            PackagesDto $i$a$-use-FileSystem$read$1$iv23332;
            Throwable thrown$iv$iv;
            block22: {
                void this_$iv;
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = packagesFile;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    void $this$decodeFromStream$iv;
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean $i$a$-use-FileSystem$read$1$iv23332 = false;
                    BufferedSource $this$parsePackagesFile_u24lambda_u242 = it$iv;
                    boolean bl2 = false;
                    Json json2 = JsonKt.getJsonx();
                    InputStream stream$iv = $this$parsePackagesFile_u24lambda_u242.inputStream();
                    boolean $i$f$decodeFromStream = false;
                    $this$decodeFromStream$iv.getSerializersModule();
                    $i$a$-use-FileSystem$read$1$iv23332 = (PackagesDto)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)PackagesDto.Companion.serializer()), (InputStream)stream$iv);
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        $i$a$-use-FileSystem$read$1$iv23332 = null;
                        break block22;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block23: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block23;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            PackagesDto result$iv$iv = $i$a$-use-FileSystem$read$1$iv23332;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            PackagesDto packagesDto = result$iv$iv;
            PackagesDto.HostInfo hostInfo = packagesDto.getHostInfo();
            String shortName = hostInfo.getShortName();
            InstalledDotNetTool.Tool.Known known = this.resolveToolOrNull(installDir, shortName);
            if (known != null) {
                tool = known;
            } else {
                InstalledDotNetTool.Tool.ReSharperPlatform reSharperPlatform = this.resolveAsReSharperOrNull(shortName);
                if (reSharperPlatform != null) {
                    tool = reSharperPlatform;
                } else {
                    DotNetToolDetectorImpl $this$parsePackagesFile_u24lambda_u243 = this;
                    boolean bl = false;
                    Logger.INSTANCE.warn("Unknown reSharper tool name='" + shortName + "'");
                    tool = new InstalledDotNetTool.Tool.Unknown(shortName);
                }
            }
            InstalledDotNetTool.Tool tool2 = tool;
            String string = hostInfo.getHive();
            int n = hostInfo.getWave();
            return new InstalledDotNetTool(tool2, installDir, string, n);
        }
        catch (Throwable t2) {
            Logger.INSTANCE.warn(t2, "Error parsing .NET install root: " + installDir);
            return null;
        }
    }

    private final InstalledDotNetTool.Tool.ReSharperPlatform resolveAsReSharperOrNull(String shortName) {
        return StringsKt.startsWith$default((String)shortName, (String)"ReSharperPlatformVs", (boolean)false, (int)2, null) ? new InstalledDotNetTool.Tool.ReSharperPlatform(StringsKt.removePrefix((String)shortName, (CharSequence)"ReSharperPlatformVs")) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final InstalledDotNetTool.Tool.Known resolveToolOrNull(Path installDir, String shortName) {
        Object v1;
        Iterable<String> executableNames;
        InstalledDotNetTool.Type type2;
        block3: {
            void $this$firstOrNull$iv;
            InstalledDotNetTool.Type type3 = this.types.get(shortName);
            if (type3 == null) {
                return null;
            }
            type2 = type3;
            executableNames = this.executableNameResolver.getExecutableNames(type2);
            Sequence sequence2 = SequencesKt.map((Sequence)CollectionsKt.asSequence(executableNames), arg_0 -> DotNetToolDetectorImpl.resolveToolOrNull$lambda$4(installDir, arg_0));
            FileSystem fileSystem = this.fileSystem;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path p0 = (Path)element$iv;
                boolean bl = false;
                if (!fileSystem.exists(p0)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Path executable = v1;
        if (executable == null) {
            Logger.INSTANCE.warn("None of [" + CollectionsKt.joinToString$default(executableNames, null, null, null, (int)0, null, null, (int)63, null) + "] found in " + installDir);
            return null;
        }
        return new InstalledDotNetTool.Tool.Known(type2, executable, CollectionsKt.emptyList());
    }

    private static final Path resolveToolOrNull$lambda$4(Path $installDir, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $installDir.resolve(it);
    }
}

